/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.oplog;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogTaskService;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpLoggerImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OpLogManager {
    private static final Log logger = LogFactory.getLog(OpLogManager.class);
    private static final BlockingQueue<OpLogEntity> BLOCKING_QUEUE = new ArrayBlockingQueue<OpLogEntity>(256);

    public static OpLogger getLogger() {
        return new OpLoggerImpl();
    }

    static void offerOpLog(OpLogEntity opLogEntity) {
        try {
            BLOCKING_QUEUE.offer(opLogEntity, 500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error("OpLog offer to BLOCKING_QUEUE is interrupted. ", (Throwable)e);
        }
    }

    static OpLogEntity pollOpLog() {
        return (OpLogEntity)BLOCKING_QUEUE.poll();
    }

    static OpLogEntity peekOpLog() {
        return (OpLogEntity)BLOCKING_QUEUE.peek();
    }

    static {
        new OpLogTaskService().start();
    }
}

