/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.oplog;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.eye.api.oplog.AppenderWork;
import kd.bos.eye.api.oplog.CleanHistoryWork;

public class OpLogTaskService {
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(2, runnable -> {
        Thread t = new Thread(runnable, "OpLogTaskService-thread-" + threadNumber.getAndIncrement());
        t.setDaemon(true);
        return t;
    });

    public void start() {
        SERVICE.scheduleWithFixedDelay(new AppenderWork(), 5000L, 1000L, TimeUnit.MILLISECONDS);
        SERVICE.scheduleWithFixedDelay(new CleanHistoryWork(), this.getInitialDelay(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
    }

    public static void registScheduleWork(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        SERVICE.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private long getInitialDelay() {
        ZonedDateTime nextRun;
        ZonedDateTime now = ZonedDateTime.now();
        if (now.compareTo(nextRun = now.withHour(1).withMinute(0).withSecond(0)) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        return duration.getSeconds();
    }
}

