/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.oplog;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import kd.bos.eye.config.custom.ConfigDbHelper;

public class OpLogUtil {
    private static final String UNKNOWN_IP = "unknown";

    static boolean isEnableOpLog() {
        return Boolean.parseBoolean(ConfigDbHelper.getValueByKey("monitor.oplog.enable", "false"));
    }

    public static String getRemoteHost(HttpExchange exchange) {
        Headers headers = exchange.getRequestHeaders();
        String ip = headers.getFirst("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || UNKNOWN_IP.equalsIgnoreCase(ip)) {
            ip = headers.getFirst("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_IP.equalsIgnoreCase(ip)) {
            ip = headers.getFirst("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_IP.equalsIgnoreCase(ip)) {
            ip = exchange.getRemoteAddress().getAddress().getHostAddress();
        }
        if (ip == null || ip.length() == 0) {
            ip = UNKNOWN_IP;
        }
        if (ip != null) {
            String[] ips = ip.split(",");
            ip = ips[0];
        }
        return ip;
    }
}

