/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.oplog;

import com.sun.net.httpserver.HttpExchange;
import java.time.LocalDateTime;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;

public class OpLoggerImpl
implements OpLogger {
    @Override
    public void opLog(HttpExchange exchange, OpType opType, String opObject, String description) {
        if (OpLogUtil.isEnableOpLog()) {
            OpLogEntity opLogEntity = new OpLogEntity();
            opLogEntity.setId(DB.genLongId((String)"T_MONITOR_OPLOG"));
            Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
            opLogEntity.setUserName(userInfo.get("user"));
            opLogEntity.setOpTime(LocalDateTime.now());
            opLogEntity.setClientIp(OpLogUtil.getRemoteHost(exchange));
            opLogEntity.setOpType(opType.getTypeDescription());
            opLogEntity.setOpObject(opObject);
            opLogEntity.setDescription(description);
            OpLogManager.offerOpLog(opLogEntity);
        }
    }

    @Override
    public void opLog(OpLogEntity opLogEntity) {
        if (OpLogUtil.isEnableOpLog()) {
            OpLogManager.offerOpLog(opLogEntity);
        }
    }
}

