/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import kd.bos.eye.api.permission.CheckPermissionRequeset;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class CheckpermissionApiHandler
extends AbstractHttpHandler {
    public static final CheckpermissionApiHandler instance = new CheckpermissionApiHandler();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            CheckPermissionRequeset request = (CheckPermissionRequeset)ExchangeVueUtils.parsePostJson(exchange, CheckPermissionRequeset.class);
            String token = EyeAuther.getToken(exchange);
            String permission = request.getPermission();
            String model = System.getProperty("monitor.dev.model");
            if ("debug".equals(model)) {
                response.setMsg("success");
                response.setCode(0);
            } else {
                Map<String, String> info = SessionStore.get().get(token);
                String logintype = info.get("logintype");
                if (logintype.equals(SsoClients.COSMICEYE.getName())) {
                    CosmiceyeResponse rs = CosmiceyeAuth.get().checkpermission(token, permission);
                    if (rs != null) {
                        if (rs.getErrcode() == 0) {
                            response.setMsg("success");
                            response.setCode(0);
                        } else {
                            response.setCode(rs.getErrcode());
                            response.setMsg(rs.getDescription());
                            response.setData(null);
                        }
                    } else {
                        response.setCode(1);
                        response.setMsg(LangRes.get((String)"SsoLoginHandler_3", (String)"Third-party authentication request exception", (Object[])new Object[0]));
                    }
                } else {
                    response.setMsg("success");
                    response.setCode(0);
                }
            }
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg("SsoCheckpermission exception, message: " + e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

