/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.permission.dao.RoleDao;
import kd.bos.eye.api.permission.entity.Role;
import kd.bos.eye.api.permission.entity.RoleRequest;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.RequestTypeEnum;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class RoleHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        RoleDao roleDao = new RoleDao();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (!DBHelper.dbIsConfigured()) {
            map.put("isConfiged", "false");
            response.setCode(0);
            response.setData(map);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        try {
            RoleRequest roleRequest = ExchangeVueUtils.parseJsonFromPost(exchange, RoleRequest.class);
            if (roleRequest == null) {
                return;
            }
            String requestType = roleRequest.getRequestType();
            if (!EyeAuther.checkPermission(exchange, "role", requestType)) {
                throw new KDException("No permission!");
            }
            Boolean isConfFromMc = Boolean.parseBoolean(System.getProperty("monitor.db.mcconf.switch", "false"));
            if (RequestTypeEnum.ROLE_LIST_IS_DUPLICATE.getRequestType().equals(requestType)) {
                map.put("isDuplicateRole", roleDao.isDuplicateRole(roleRequest));
            } else if ("5".equals(requestType)) {
                Role role = roleDao.getRoleById(roleRequest.getId());
                JSONArray array = JSONArray.parseArray((String)role.getRoleResource());
                if (isConfFromMc.booleanValue()) {
                    JSONArray hiddenArray = JSONArray.parseArray((String)"[\"config-dbConfig\",\"config-dbConfig-add\",\"config-dbConfig-edit\"]");
                    array.removeAll((Collection)hiddenArray);
                }
                map.put("defaultChecked", array);
            } else {
                JSONArray permissionJSON = null;
                if (RequestTypeEnum.ROLE_LIST_ADD.getRequestType().equals(requestType)) {
                    roleDao.addRole(roleRequest);
                }
                if (RequestTypeEnum.ROLE_LIST_VIEW.getRequestType().equals(requestType)) {
                    permissionJSON = roleDao.getPermissionConfigJSON();
                }
                if (RequestTypeEnum.ROLE_LIST_EDIT.getRequestType().equals(requestType)) {
                    roleDao.editRole(roleRequest);
                }
                if (RequestTypeEnum.ROLE_LIST_DELETE.getRequestType().equals(requestType)) {
                    boolean isDeleted = roleDao.deleteRole(roleRequest);
                    map.put("isDeleted", isDeleted);
                }
                if (isConfFromMc.booleanValue() && permissionJSON != null) {
                    this.filerDbConfig(permissionJSON);
                }
                List<Role> roleList = roleDao.getRoleList();
                map.put("roleList", roleList);
                map.put("permissionData", permissionJSON);
                map.put("isConfiged", "true");
            }
            response.setCode(0);
            response.setData(map);
            this.addOpLog(exchange, requestType, roleRequest);
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg("role exception, message: " + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void filerDbConfig(JSONArray permissionJSON) {
        block0: for (JSONObject jsonObject : permissionJSON) {
            if (!"config".equals(jsonObject.getString("id"))) continue;
            JSONArray child = jsonObject.getJSONArray("children");
            Iterator childIterator = child.iterator();
            while (childIterator.hasNext()) {
                JSONObject dbObject = (JSONObject)childIterator.next();
                if (!"config-dbConfig".equals(dbObject.getString("id"))) continue;
                childIterator.remove();
                break block0;
            }
            break block0;
        }
    }

    private void addOpLog(HttpExchange exchange, String requestType, RoleRequest roleRequest) {
        if ("0".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"RoleHandler_1", (String)"\u89d2\u8272\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"RoleHandler_2", (String)"\u65b0\u589e{0}\u89d2\u8272", (Object[])new Object[]{roleRequest.getRoleName()}));
        }
        if ("1".equals(requestType)) {
            // empty if block
        }
        if ("2".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"RoleHandler_1", (String)"\u89d2\u8272\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"RoleHandler_4", (String)"\u4fee\u6539{0}\u89d2\u8272\u914d\u7f6e", (Object[])new Object[]{roleRequest.getRoleName()}));
        }
        if ("3".equals(requestType)) {
            OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"RoleHandler_1", (String)"\u89d2\u8272\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"RoleHandler_5", (String)"\u5220\u9664{0}\u89d2\u8272\u914d\u7f6e", (Object[])new Object[]{roleRequest.getRoleName()}));
        }
    }
}

