/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.util.JSONUtils;

public class SecondAuthHandler
extends AbstractHttpHandler {
    private static final String AUTH_FAILED = "0";
    private static final String AUTH_SUCCESS = "1";
    private static final String AUTH_OVER_TIMES = "2";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        try {
            Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
            String password = params.get("password");
            String token = SecondAuthHandler.getToken(exchange);
            Map<String, String> userInfo = SessionStore.get().get(token);
            String user = userInfo.get("user");
            String decryptPassword = MonitorLoginUtils.getDecryptPassword(user, password);
            String authType = AUTH_FAILED;
            if (EyeAuther.checkUser(user, decryptPassword)) {
                authType = AUTH_SUCCESS;
            }
            HashMap<String, String> authData = new HashMap<String, String>(2);
            authData.put("authType", authType);
            response.put("code", 0);
            response.put("data", authData);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

