/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission.dao;

import com.alibaba.fastjson.JSONArray;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.permission.dao.UserDao;
import kd.bos.eye.api.permission.entity.Permission;
import kd.bos.eye.api.permission.entity.Role;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangResourceStreamFactory;

public class RoleDao {
    private static final Log log = LogFactory.getLog(RoleDao.class);
    private static final String LOCK_PATH = "/dlock/monitor/RoleDao/initAdminRole";

    public static JSONArray getPermissionConfigJSON() {
        StringBuilder json = new StringBuilder();
        try (InputStream resourceAsStream = LangResourceStreamFactory.getResourceStream((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)"permission.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        }
        catch (Exception e) {
            log.error("can not read permission.json!", (Throwable)e);
        }
        return JSONArray.parseArray((String)json.toString());
    }

    public static List<Permission> getAllPermissionList() {
        JSONArray jsonArray = RoleDao.getPermissionConfigJSON();
        List permissions = jsonArray.toJavaList(Permission.class);
        return permissions;
    }

    public static String getAllPermission() {
        List<Permission> permissions = RoleDao.getAllPermissionList();
        ArrayList<String> permissionStrings = new ArrayList<String>(10);
        RoleDao.reverse("", permissions, permissionStrings, false);
        return JSONArray.toJSONString(permissionStrings);
    }

    private static void reverse(String configuredRoleResource, List<Permission> permissons, List<String> permissionString, boolean filter) {
        for (Permission permisson : permissons) {
            if (filter) {
                if (permisson.isInitializedToDb() || configuredRoleResource.contains(permisson.getId())) {
                    permissionString.add(permisson.getId());
                }
            } else {
                permissionString.add(permisson.getId());
            }
            if (permisson.getChildren().isEmpty()) continue;
            RoleDao.reverse(configuredRoleResource, permisson.getChildren(), permissionString, filter);
        }
    }

    public static void initAdminPermission() {
        RoleDao roleDao = new RoleDao();
        Role role = roleDao.getRoleByName("admin");
        if (role != null) {
            List<Permission> permissions = RoleDao.getAllPermissionList();
            ArrayList<String> permissionStrings = new ArrayList<String>(10);
            RoleDao.reverse(role.getRoleResource(), permissions, permissionStrings, true);
            role.setRoleResource(JSONArray.toJSONString(permissionStrings));
            roleDao.editRole(role);
        }
    }

    public List<Role> getRoleList() {
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid,frolename,froleresource,froledescription from t_monitor_role", new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Role> roleList = new ArrayList<Role>(result.size());
        for (Result row : result) {
            Role role = new Role();
            role.setId(row.getString("fid"));
            role.setRoleName(row.getString("frolename"));
            role.setRoleResource(row.getString("froleresource"));
            role.setRoleDescription(row.getString("froledescription"));
            roleList.add(role);
        }
        return roleList;
    }

    public Role getRoleById(String id) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> roleParamList = new ArrayList<String>(1);
        roleParamList.add(id);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid,frolename,froleresource,froledescription from t_monitor_role where fid=?", roleParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Role> roleList = new ArrayList<Role>(result.size());
        for (Result row : result) {
            Role role = new Role();
            role.setId(row.getString("fid"));
            role.setRoleName(row.getString("frolename"));
            role.setRoleResource(row.getString("froleresource"));
            role.setRoleDescription(row.getString("froledescription"));
            roleList.add(role);
        }
        return (Role)roleList.get(0);
    }

    public Role getRoleByName(String roleName) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> roleParamList = new ArrayList<String>(1);
        roleParamList.add(roleName);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid,frolename,froleresource,froledescription from t_monitor_role where frolename=?", roleParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Role> roleList = new ArrayList<Role>(result.size());
        for (Result row : result) {
            Role role = new Role();
            role.setId(row.getString("fid"));
            role.setRoleName(row.getString("frolename"));
            role.setRoleResource(row.getString("froleresource"));
            role.setRoleDescription(row.getString("froledescription"));
            roleList.add(role);
        }
        return roleList.isEmpty() ? null : (Role)roleList.get(0);
    }

    public boolean isDuplicateRole(Role role) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> roleParamList = new ArrayList<String>(1);
        roleParamList.add(role.getRoleName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select frolename from t_monitor_role where frolename=?", roleParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return result.size() > 0;
    }

    public void addRole(Role role) {
        role.setId(DB.genStringId((String)"t_monitor_role"));
        ArrayList<String> roleParamList = new ArrayList<String>(4);
        roleParamList.add(role.getId());
        roleParamList.add(role.getRoleName());
        roleParamList.add(role.getRoleResource());
        roleParamList.add(role.getRoleDescription());
        String sql = "insert into t_monitor_role(fid,frolename,froleresource,froledescription) values(?,?,?,?)";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, roleParamList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    public void initAdminRole() {
        DLock dLock = null;
        try {
            dLock = DLock.create((String)LOCK_PATH);
            if (!dLock.tryLock()) {
                return;
            }
            if (this.getRoleByName("admin") != null) {
                return;
            }
            Role role = new Role();
            role.setId(DB.genStringId((String)"t_monitor_role"));
            role.setRoleName("admin");
            role.setRoleResource(RoleDao.getAllPermission());
            role.setRoleDescription(LangRes.get((String)"RoleInit", (String)"System Administrator Role", (Object[])new Object[0]));
            this.addRole(role);
        }
        catch (Exception e) {
            log.error("initAdminRole init error", (Throwable)e);
        }
        finally {
            if (dLock != null) {
                dLock.unlock();
            }
        }
    }

    public void editRole(Role role) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> roleParamList = new ArrayList<String>(6);
        roleParamList.add(role.getRoleName());
        roleParamList.add(role.getRoleResource());
        roleParamList.add(role.getRoleDescription());
        roleParamList.add(role.getId());
        String sql = "update t_monitor_role set frolename=?,froleresource=?,froledescription=? where fid=?";
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, roleParamList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public boolean deleteRole(Role role) {
        UserDao userDao = new UserDao();
        int userCount = userDao.getUserCountByRole(role.getRoleName());
        if (userCount != 0) {
            return false;
        }
        ArrayList<String> roleParamList = new ArrayList<String>(1);
        roleParamList.add(role.getId());
        DBRequest dbRequest = new DBRequest();
        String sql = "delete from t_monitor_role where fid=?";
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, roleParamList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
        return true;
    }

    static {
        try {
            RoleDao.initAdminPermission();
            log.info("update admin permissions success.");
        }
        catch (Exception e) {
            log.error("update admin permissions failed. ERRROR: ", (Throwable)e);
        }
    }
}

