/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.permission.dao;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.permission.entity.User;
import kd.bos.eye.api.permission.entity.UserRequest;
import kd.bos.eye.util.PBKDF2Util;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;

public class UserDao {
    private static Log log = LogFactory.getLog(UserDao.class);
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String LOCK_PATH = "/dlock/monitor/UserDao/initAdminUser";

    public List<User> getUserList() {
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid,fusername,fuserrole,fusersource,fuserdescription,fexpiredate from t_monitor_user", new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<User> roleList = new ArrayList<User>(result.size());
        for (Result row : result) {
            User user = new User();
            user.setId(row.getString("fid"));
            user.setUserName(row.getString("fusername"));
            user.setUserRole(row.getString("fuserrole"));
            user.setUserSource(row.getString("fusersource"));
            user.setUserDescription(row.getString("fuserdescription"));
            user.setExpireDate(row.getString("fexpiredate"));
            roleList.add(user);
        }
        return roleList;
    }

    public User getUserByName(String userName) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> userParamList = new ArrayList<String>(1);
        userParamList.add(userName);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid,fusername,fuserpassword,fuserrole,fusersource,fuserdescription,fexpiredate from t_monitor_user where fusername=?", userParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<User> userList = new ArrayList<User>(result.size());
        for (Result row : result) {
            User user = new User();
            user.setId(row.getString("fid"));
            user.setUserName(row.getString("fusername"));
            user.setUserPassword(row.getString("fuserpassword"));
            user.setUserRole(row.getString("fuserrole"));
            user.setUserSource(row.getString("fusersource"));
            user.setUserDescription(row.getString("fuserdescription"));
            user.setExpireDate(row.getString("fexpiredate"));
            userList.add(user);
        }
        return userList.size() != 0 ? (User)userList.get(0) : null;
    }

    public int getUserCountByRole(String roleName) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> userParamList = new ArrayList<String>(1);
        userParamList.add(roleName);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fid from t_monitor_user where fuserrole=?", userParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return result.size();
    }

    public boolean isDuplicateUser(User user) {
        String adminUser = System.getProperty("monitor.user");
        if (adminUser.equals(user.getUserName())) {
            return true;
        }
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> userParamList = new ArrayList<String>(1);
        userParamList.add(user.getUserName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fusername from t_monitor_user where fusername=?", userParamList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return result.size() > 0;
    }

    public void addUser(UserRequest user) {
        user.setId(DB.genStringId((String)"t_monitor_user"));
        ArrayList<String> userParamList = new ArrayList<String>(6);
        userParamList.add(user.getId());
        userParamList.add(user.getUserName());
        String encodePassword = PBKDF2Util.createDbPassword(user.getUserPassword());
        String initUser = System.getProperty("monitor.user");
        if (!Objects.equals(initUser, user.getUserName())) {
            encodePassword = encodePassword + "_NEW";
        }
        userParamList.add(encodePassword);
        userParamList.add(user.getUserRole());
        userParamList.add(user.getUserSource());
        userParamList.add(user.getUserDescription());
        if (user.getExpireDate() == null || user.getExpireDate().isEmpty()) {
            userParamList.add(null);
        } else {
            userParamList.add(user.getExpireDate());
        }
        String sql = "insert into t_monitor_user(fid,fusername,fuserpassword,fuserrole,fusersource,fuserdescription,fexpiredate) values(?,?,?,?,?,?,?)";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, userParamList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAdminUser() {
        DLock dLock = null;
        try {
            dLock = DLock.create((String)LOCK_PATH);
            if (!dLock.tryLock()) {
                return;
            }
            String initUser = System.getProperty("monitor.user");
            String mp = System.getProperty("monitor.password");
            if (this.getUserByName(initUser) != null) {
                return;
            }
            UserRequest userRequest = new UserRequest();
            userRequest.setId(DB.genStringId((String)"t_monitor_user"));
            userRequest.setUserName(initUser);
            userRequest.setUserRole("admin");
            userRequest.setUserSource(" ");
            userRequest.setExpireDate(null);
            userRequest.setUserDescription(LangRes.get((String)"UserInit", (String)"System Administrator", (Object[])new Object[0]));
            if (mp != null) {
                mp = Encrypters.decode((String)mp);
                try {
                    userRequest.setUserPassword(mp);
                }
                catch (Exception e) {
                    log.error("encryptAes failed!", (Throwable)e);
                }
            }
            this.addUser(userRequest);
        }
        catch (Exception e) {
            log.error("initAdminUser init error", (Throwable)e);
        }
        finally {
            if (dLock != null) {
                dLock.unlock();
            }
        }
    }

    public void editUser(UserRequest user) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> userParamList = new ArrayList<String>(6);
        userParamList.add(user.getUserName());
        userParamList.add(user.getUserRole());
        userParamList.add(user.getUserSource());
        userParamList.add(user.getUserDescription());
        if (user.getExpireDate() == null || user.getExpireDate().isEmpty()) {
            userParamList.add(null);
        } else {
            userParamList.add(user.getExpireDate());
        }
        userParamList.add(user.getId());
        String sql = "update t_monitor_user set fusername=?,fuserrole=?,fusersource=?,fuserdescription=?,fexpiredate=? where fid=?";
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, userParamList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public void editUserPassword(UserRequest user) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> userParamList = new ArrayList<String>(6);
        userParamList.add(user.getUserName());
        userParamList.add(PBKDF2Util.createDbPassword(user.getUserPassword()));
        if (user.getExpireDate() == null || user.getExpireDate().isEmpty()) {
            userParamList.add(null);
        } else {
            userParamList.add(user.getExpireDate());
        }
        userParamList.add(user.getId());
        String sql = "update t_monitor_user set fusername=?,fuserpassword=?,fexpiredate=? where fid=?";
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, userParamList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public void deleteUser(User user) {
        ArrayList<String> userParamList = new ArrayList<String>(1);
        userParamList.add(user.getId());
        DBRequest dbRequest = new DBRequest();
        String sql = "delete from t_monitor_user where fid=?";
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, userParamList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public List<String> getRoleList() {
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select frolename from t_monitor_role", new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<String> roleList = new ArrayList<String>(result.size());
        for (Result row : result) {
            roleList.add(row.getString("frolename"));
        }
        return roleList;
    }
}

