/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.pktemptable;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.metric.PKTempTableConfigSnapshot;
import kd.bos.db.pktemptable.metric.PKTempTableMXBean;
import kd.bos.db.pktemptable.metric.PKTempTableMXBeanImpl;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.pktemptable.PKTempTableConfigVO;
import kd.bos.eye.api.pktemptable.PKTempTableResponseData;
import kd.bos.eye.api.pktemptable.PKTempTableResponseMetricVO;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.service.ClusterService;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.eye.util.EyeUrlUtils;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableHandler.class);
    private final ClusterService clusterService = ClusterService.getInstance();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, Handle<ApiResponse<?>>> mapping = new HashMap();
    private final Handle<ApiResponse<?>> defaultHandle = this::queryMetric;

    public PKTempTableHandler() {
        this.mapping.put("checkVersion", this::checkNewVersion);
        this.mapping.put("queryMetric", this::queryMetric);
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = this.getParams(exchange, false);
        String opt = params.get("opt");
        Handle<ApiResponse<?>> handle = this.mapping.get(opt);
        if (handle == null) {
            handle = this.defaultHandle;
        }
        this.writeJson(JSONUtils.toString(handle.doHandle(exchange)), exchange);
    }

    private List<PKTempTableConfigVO> getConfigList() {
        PKTempTableConfigSnapshot config = PKTempTableMXBeanImpl.getInstance().getConfig();
        ArrayList<PKTempTableConfigVO> voList = new ArrayList<PKTempTableConfigVO>(16);
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_1", (String)"Enable Performance Statistics", (Object[])new Object[0]), "db.temptable.metric", config.isMetric()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_2", (String)"Enable Temporary Table Reuse", (Object[])new Object[0]), "db.temptable.reuse", config.isReuse()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_3", (String)"Temporary Table Pool Size", (Object[])new Object[0]), "db.temptable.table_size", config.getTableSize()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_4", (String)"Maximum Temporary Tables in the Pool", (Object[])new Object[0]), "db.temptable.max_table_size", config.getMaxTableSize()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_5", (String)"BigString Temporary Table Pool Size", (Object[])new Object[0]), "db.temptable.big_string_table_size", config.getBigStringTableSize()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_6", (String)"Create Temporary Table Threads", (Object[])new Object[0]), "db.temptable.produce_thread_count", config.getProduceThreadCount()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_7", (String)"Reuse Temporary Table Threads", (Object[])new Object[0]), "db.temptable.reuse_thread_count", config.getReuseThreadCount()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_8", (String)"Temporary Table Borrow Timeout (Minutes)", (Object[])new Object[0]), "db.temptable.table_use_timeout_minute", config.getTableUseTimeoutMinute()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_9", (String)"BigString Temporary Table Field Length", (Object[])new Object[0]), "db.temptable.big_string_length", config.getBigStringLength()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_10", (String)"Temporary Table Timeout Cleanup Time (Minutes)", (Object[])new Object[0]), "db.temptable.table_clear_timeout_minute", config.getTableClearTimeoutMinute()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_11", (String)"MySQL using Memory Engine", (Object[])new Object[0]), "db.temptable.mysql_use_memory_engine", config.isMysqlUseMemoryEngine()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_12", (String)"MySQL using LoadDataInfile", (Object[])new Object[0]), "db.temptable.mysql_use_load_infile", config.isMysqlUseLoadInfile()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_13", (String)"Temporary Table Index", (Object[])new Object[0]), "db.temptable.with_index", config.isTempWithIndex()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_14", (String)"Check if the table exists (recommended to enable only in development environment)", (Object[])new Object[0]), "db.temptable.always_valid", config.isAlwaysValid()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_15", (String)"Trace Exception Logs", (Object[])new Object[0]), "db.temptable.log_runtime_exception", config.isLogRuntimeException()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_16", (String)"Record Insert Data Stack Threshold", (Object[])new Object[0]), "db.temptable.log_stack_threshold", config.getLogStackThreshold()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_17", (String)"Enable Primary Key Index", (Object[])new Object[0]), "db.temptable.table_create_with_pk", config.isTableCreateWithPk()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_18", (String)"Drop Table Retry Interval (Seconds)", (Object[])new Object[0]), "db.temptable.drop_retry_timeout_minute", config.getDropRetryTimeoutMinute()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_19", (String)"SQLServer Enable Bulk", (Object[])new Object[0]), "db.temptable.sql_server_use_bulk", config.isSqlServerUseBulk()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_20", (String)"Enable Transaction-Scoped Temporary Table Reuse", (Object[])new Object[0]), "db.temptable.tx_temptable_reuse", config.isTxTempTableReuse()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_21", (String)"Maximum Number of Temporary Tables in a Transaction", (Object[])new Object[0]), "db.temptable.tx_temptable_maxsize", config.getTxTempTableMaxSize()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_22", (String)"Transaction-Scoped Temporary Table Cleanup Data Threshold", (Object[])new Object[0]), "db.temptable.tx_temptable_clean_threshold", config.getTxTempTableCleanThreshold()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_23", (String)"Table Timeout Cleanup Time (Seconds)", (Object[])new Object[0]), "db.temptable.drop_timeout_second", config.getDropTimeoutSecond()));
        voList.add(new PKTempTableConfigVO(LangRes.get((String)"PKTempTableHandler_24", (String)"Truncate Table Timeout Time (Seconds)", (Object[])new Object[0]), "db.temptable.truncate_timeout_second", config.getTruncateTimeoutSecond()));
        return voList;
    }

    private void requestAndMerge(HttpExchange exchange, ApiResponse<PKTempTableResponseData> response) {
        ArrayList<EyeNodeInfo> nodes = this.clusterService.getSortedNodeInfo();
        ArrayList<PKTempTableResponseMetricVO> metrics = new ArrayList<PKTempTableResponseMetricVO>(nodes.size());
        String path = EyeUrlUtils.getHomeUrl(exchange, null) + "pktemptable/";
        for (EyeNodeInfo node : nodes) {
            PKTempTableResponseMetricVO vo = this.get(path, node);
            if (vo == null) continue;
            metrics.add(vo);
        }
        response.getData().setMetric(metrics);
    }

    private PKTempTableResponseMetricVO get(String path, EyeNodeInfo node) {
        if (node.getInstanceId().equalsIgnoreCase(Instance.getInstanceId())) {
            return PKTempTableResponseMetricVO.ofMXBean(Instance.getInstanceId(), (PKTempTableMXBean)PKTempTableMXBeanImpl.getInstance());
        }
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
        String url = node.getMonitorUrl(false) + path;
        String response = EyeHttpClients.get(url, proxyHeader, 500, 1000);
        try {
            ApiResponse rsp = (ApiResponse)this.objectMapper.readValue(response, (TypeReference)new TypeReference<ApiResponse<PKTempTableResponseData>>(){});
            if (rsp.getCode() != 0) {
                log.warn("Monitor to get node:{} pktemptable metric fail;requestUrl={} , msg={}", new Object[]{node.getInstanceId(), url, rsp.getMsg()});
                return null;
            }
            return ((PKTempTableResponseData)rsp.getData()).getMetric().get(0);
        }
        catch (Exception ex) {
            try {
                log.warn("Monitor to get node:{} pktemptable metric fail,parse response fail.", (Object)node.getInstanceId());
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private ApiResponse<Map<String, Boolean>> checkNewVersion(HttpExchange exchange) {
        ApiResponse<Map<String, Boolean>> response = new ApiResponse<Map<String, Boolean>>();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        result.put("newVersion", PKTempTableConfig.isNewVersion());
        response.setData(result);
        return response;
    }

    private ApiResponse<PKTempTableResponseData> queryMetric(HttpExchange exchange) {
        Map<String, String> params = this.getParams(exchange, false);
        boolean cluster = "true".equalsIgnoreCase(params.get("cluster"));
        boolean browser = "true".equalsIgnoreCase(params.get("browser"));
        ApiResponse<PKTempTableResponseData> response = new ApiResponse<PKTempTableResponseData>();
        PKTempTableResponseData data = new PKTempTableResponseData();
        response.setData(data);
        if (browser) {
            data.setConfigs(this.getConfigList());
        }
        if (cluster) {
            this.requestAndMerge(exchange, response);
        } else {
            data.setMetric(Lists.newArrayList((Object[])new PKTempTableResponseMetricVO[]{PKTempTableResponseMetricVO.ofMXBean(Instance.getInstanceId(), (PKTempTableMXBean)PKTempTableMXBeanImpl.getInstance())}));
        }
        return response;
    }

    @FunctionalInterface
    static interface Handle<T> {
        public T doHandle(HttpExchange var1);
    }
}

