/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.pmm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.eye.api.pmm.PmmConfig;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class PmmLoginHandler
extends AbstractHttpHandler {
    private static final Log LOGGER = LogFactory.getLog(PmmLoginHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String LOGIN = "login";

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        String url = PmmConfig.getUrl();
        String user = PmmConfig.getUser();
        String password = PmmConfig.getPassword();
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((String)url)) {
                String cookie = this.login(url, user, password);
                if (cookie == null) {
                    data.put("status", "failed");
                    data.put("redirectUrl", url.endsWith("/") ? url + LOGIN : url + "/" + LOGIN);
                } else {
                    exchange.getResponseHeaders().add("Set-Cookie", cookie);
                    data.put("status", "success");
                    data.put("redirectUrl", url.endsWith("/") ? url : url + "/");
                }
            } else {
                data.put("status", "unable");
            }
            response.put("code", 0);
            response.put("data", data);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String login(String url, String user, String password) {
        CloseableHttpClient httpClient = null;
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            url = url.endsWith("/") ? url + LOGIN : url + "/" + LOGIN;
            HttpPost loginRequest = new HttpPost(url);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("user", user);
            params.put("password", password);
            String payload = OBJECT_MAPPER.writeValueAsString(params);
            StringEntity entity = new StringEntity(payload);
            entity.setContentType("application/json");
            loginRequest.setEntity((HttpEntity)entity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)loginRequest);
            Header[] allHeaders = httpResponse.getAllHeaders();
            String string = this.getCookie(allHeaders);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("pmm login failed.", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getCookie(Header[] allHeaders) {
        for (Header header : allHeaders) {
            if (!header.getName().equals("Set-Cookie")) continue;
            return header.getValue();
        }
        return null;
    }

    private void redirectToHome(HttpExchange exchange, String url, String cookie) throws IOException {
        exchange.getResponseHeaders().add("Set-Cookie", cookie);
        exchange.getResponseHeaders().add("Location", url);
        exchange.sendResponseHeaders(302, -1L);
        exchange.close();
    }

    private void redirectToLogin(HttpExchange exchange, String url) throws IOException {
        url = url.endsWith("/") ? url + LOGIN : url + "/" + LOGIN;
        exchange.getResponseHeaders().add("Location", url);
        exchange.sendResponseHeaders(302, -1L);
        exchange.close();
    }
}

