/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.api.prometheus.PrometheusMetricsUtils;
import kd.bos.eye.api.thread.entity.NodeInfo;
import kd.bos.eye.util.ClusterUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ClusterMetricsHandler
implements HttpHandler {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(2);
    private static final int CONNECTION_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 1000;
    private static final Log logger = LogFactory.getLog(ClusterMetricsHandler.class);

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            if (this.auth(httpExchange)) {
                String metrics = this.collectAllNodesMetrics(this.getAuth(httpExchange));
                this.writeData(metrics, httpExchange);
            } else {
                this.writeData("access denied: auth failed.", httpExchange);
            }
        }
        catch (IllegalArgumentException e) {
            this.writeData("access denied: " + e.getMessage(), httpExchange);
        }
    }

    protected void writeData(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private boolean auth(HttpExchange httpExchange) {
        Object authorization = httpExchange.getRequestHeaders().get("Authorization");
        if (authorization == null) {
            throw new IllegalArgumentException("authorization information can not be null.");
        }
        String auth = (String)authorization.get(0);
        auth = auth.substring(6);
        String userPass = new String(Base64.getDecoder().decode(auth));
        int indexOf = userPass.indexOf(":");
        String account = userPass.substring(0, indexOf);
        String secret = userPass.substring(indexOf + 1);
        return HealthCheckConfig.checkAuth(account, Encrypters.decode((String)secret));
    }

    private String getAuth(HttpExchange httpExchange) {
        Object authorization = httpExchange.getRequestHeaders().get("Authorization");
        if (authorization == null) {
            throw new IllegalArgumentException("authorization information can not be null.");
        }
        return (String)authorization.get(0);
    }

    private String collectAllNodesMetrics(String auth) {
        List sortedNodeInfos = ClusterUtils.getSortedNodeInfos().stream().filter(nodeInfo -> !nodeInfo.getInstanceId().equals(Instance.getInstanceId())).collect(Collectors.toList());
        CountDownLatch countDownLatch = new CountDownLatch(sortedNodeInfos.size());
        StringBuilder metrics = new StringBuilder(PrometheusMetricsUtils.getPrometheusMetricsText());
        for (NodeInfo nodeInfo2 : sortedNodeInfos) {
            EXECUTOR_SERVICE.submit(new Thread(() -> {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Authorization", auth);
                String url = "http://" + nodeInfo2.getHostIp() + ":" + nodeInfo2.getHostMonitorPort() + "/monitor/eye/prometheusmetrics";
                try {
                    String result = this.getMetricsByHttp(url, header, 1000, 1000);
                    if (!result.startsWith("access denied")) {
                        metrics.append(result);
                    }
                }
                catch (IOException e) {
                    logger.error("collect prometheus metrics on " + nodeInfo2.getHostIp() + " failed. ERROR_INFO: ", (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            }, "Monitor-CollectPrometheusMetrics"));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error("Thread of prometheus metrics is interrupted.", (Throwable)e);
        }
        return metrics.toString();
    }

    private String getMetricsByHttp(String url, Map<String, String> headers, int connectionTimeout, int readTimeout) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build()).build();){
            HttpGet httpGet = new HttpGet(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }
}

