/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.api.prometheus.PrometheusMetricsUtils;

public class MetricsHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            if (this.auth(httpExchange)) {
                this.writeData(PrometheusMetricsUtils.getPrometheusMetricsText(), httpExchange);
            } else {
                this.writeData("access denied: auth failed.", httpExchange);
            }
        }
        catch (IllegalArgumentException e) {
            this.writeData("access denied: " + e.getMessage(), httpExchange);
        }
    }

    protected void writeData(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private boolean auth(HttpExchange httpExchange) {
        Object authorization = httpExchange.getRequestHeaders().get("Authorization");
        if (authorization == null) {
            throw new IllegalArgumentException("authorization information can not be null.");
        }
        String auth = (String)authorization.get(0);
        auth = auth.substring(6);
        String userPass = new String(Base64.getDecoder().decode(auth));
        int indexOf = userPass.indexOf(":");
        String account = userPass.substring(0, indexOf);
        String secret = userPass.substring(indexOf + 1);
        return HealthCheckConfig.checkAuth(account, Encrypters.decode((String)secret));
    }
}

