/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kd.bos.instance.Instance;
import kd.bos.metric.MetricSystem;
import kd.bos.util.NetAddressUtils;

public class PrometheusMetricsUtils {
    private static final MetricRegistry METRICS_REGISTRY = MetricSystem.getMetricRegistry();
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final String APP_NAME = Instance.getAppName();
    private static final String NEW_LINE = "\n";
    private static final String BLANK = " ";
    private static final String INSTANCE_IP = NetAddressUtils.getLocalIpAddress();
    private static final String COMMON_ADDITION_LABEL = "{appName=\"%s\",instanceId=\"%s\",ip=\"%s\"}";
    private static final String QUANTILE_ADDITION_LABEL = "{appName=\"%s\",instanceId=\"%s\",ip=\"%s\",quantile=\"%s\"}";
    private static final String GAUGE_TYPE = "gauge";
    private static final String COUNTER_TYPE = "counter";
    private static final String SUMMARY_TYPE = "summary";
    private static final double HISTOGRAM_FACTOR = 1.0;
    private static final double SUMMARY_FACTOR = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private static final String PERCENTILE_50 = "0.5";
    private static final String PERCENTILE_75 = "0.75";
    private static final String PERCENTILE_95 = "0.95";
    private static final String PERCENTILE_98 = "0.98";
    private static final String PERCENTILE_99 = "0.99";
    private static final String PERCENTILE_999 = "0.999";

    public static String getPrometheusMetricsText() {
        SortedMap gauges = METRICS_REGISTRY.getGauges();
        StringBuilder gaugesSb = PrometheusMetricsUtils.gaugesToText(gauges);
        SortedMap meters = METRICS_REGISTRY.getMeters();
        StringBuilder metersSb = PrometheusMetricsUtils.metersToText(meters);
        return gaugesSb.append((CharSequence)metersSb).append(NEW_LINE).toString();
    }

    private static StringBuilder gaugesToText(SortedMap<String, Gauge> gauges) {
        StringBuilder metricLines = new StringBuilder();
        for (Map.Entry<String, Gauge> metricEntry : gauges.entrySet()) {
            String metricName = metricEntry.getKey().replaceAll("[/.;,:-]", "_");
            metricLines.append("# TYPE ").append(metricName).append(BLANK).append(GAUGE_TYPE).append(NEW_LINE).append(metricName).append(String.format(COMMON_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP)).append(BLANK).append(metricEntry.getValue().getValue()).append(NEW_LINE);
        }
        return metricLines;
    }

    private static StringBuilder countersToText(SortedMap<String, Counter> counters) {
        StringBuilder metricLines = new StringBuilder();
        for (Map.Entry<String, Counter> metricEntry : counters.entrySet()) {
            String metricName = metricEntry.getKey().replaceAll("[/.;,:-]", "_");
            metricLines.append("# TYPE ").append(metricName).append(BLANK).append(GAUGE_TYPE).append(NEW_LINE).append(metricName).append(String.format(COMMON_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP)).append(BLANK).append(metricEntry.getValue().getCount()).append(NEW_LINE);
        }
        return metricLines;
    }

    private static StringBuilder metersToText(SortedMap<String, Meter> meters) {
        StringBuilder metricLines = new StringBuilder();
        for (Map.Entry<String, Meter> metricEntry : meters.entrySet()) {
            String metricName = metricEntry.getKey().replaceAll("[/.;,:-]", "_") + "_total";
            metricLines.append("# TYPE ").append(metricName).append(BLANK).append(COUNTER_TYPE).append(NEW_LINE).append(metricName).append(String.format(COMMON_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP)).append(BLANK).append(metricEntry.getValue().getCount()).append(NEW_LINE);
        }
        return metricLines;
    }

    private static StringBuilder timersToText(SortedMap<String, Timer> timers) {
        StringBuilder metricLines = new StringBuilder();
        for (Map.Entry<String, Timer> metricEntry : timers.entrySet()) {
            String metricName = metricEntry.getKey().replaceAll("[/.;,:-]", "_");
            metricLines.append("# TYPE ").append(metricName).append(BLANK).append(SUMMARY_TYPE).append(NEW_LINE).append((CharSequence)PrometheusMetricsUtils.snapshotToText(metricName, metricEntry.getValue().getSnapshot(), metricEntry.getValue().getCount(), SUMMARY_FACTOR));
        }
        return metricLines;
    }

    private static StringBuilder histogramToText(SortedMap<String, Histogram> histograms) {
        StringBuilder metricLines = new StringBuilder();
        for (Map.Entry<String, Histogram> metricEntry : histograms.entrySet()) {
            String metricName = metricEntry.getKey().replaceAll("[/.;,:-]", "_");
            metricLines.append("# TYPE ").append(metricName).append(BLANK).append(SUMMARY_TYPE).append(NEW_LINE).append((CharSequence)PrometheusMetricsUtils.snapshotToText(metricName, metricEntry.getValue().getSnapshot(), metricEntry.getValue().getCount(), 1.0));
        }
        return metricLines;
    }

    private static StringBuilder snapshotToText(String metricName, Snapshot snapshot, long count, double factor) {
        StringBuilder metricLine = new StringBuilder();
        metricLine.append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_50)).append(BLANK).append(snapshot.getMedian() * factor).append(NEW_LINE).append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_75)).append(BLANK).append(snapshot.get75thPercentile() * factor).append(NEW_LINE).append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_95)).append(BLANK).append(snapshot.get95thPercentile() * factor).append(NEW_LINE).append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_98)).append(BLANK).append(snapshot.get98thPercentile() * factor).append(NEW_LINE).append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_99)).append(BLANK).append(snapshot.get99thPercentile() * factor).append(NEW_LINE).append(metricName).append(String.format(QUANTILE_ADDITION_LABEL, APP_NAME, INSTANCE_ID, INSTANCE_IP, PERCENTILE_999)).append(BLANK).append(snapshot.get999thPercentile() * factor).append(NEW_LINE).append(metricName).append("_count").append(BLANK).append(count).append(NEW_LINE);
        return metricLine;
    }
}

