/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.sso.components;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.sso.components.impl.ComponentStatusCheckerBySocket;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class MiddlewareListApiHandler
extends AbstractHttpHandler {
    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Map<String, List>> response1 = new ApiResponse<Map<String, List>>();
        try {
            String cookieToken = EyeAuther.getToken(exchange);
            CosmiceyeResponse rs = CosmiceyeAuth.get().middlewareList(cookieToken);
            if (rs != null) {
                if (rs.getErrcode() == 0) {
                    response1.setCode(rs.getErrcode());
                    response1.setMsg(rs.getDescription());
                    response1.setData(this.MiddlewaresList(rs.getData()));
                } else {
                    response1.setCode(rs.getErrcode());
                    response1.setMsg(rs.getDescription());
                    response1.setData(null);
                }
            } else {
                response1.setCode(1);
                response1.setMsg(LangRes.get((String)"SsoLoginHandler_3", (String)"Third-party authentication request exception", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            response1.setCode(-1);
            response1.setMsg("MiddlewareList exception, message: " + e.getMessage());
        }
        String str = JSONUtils.toString(response1);
        this.writeJson(str, exchange);
    }

    private Map<String, List> MiddlewaresList(Map<String, List> middlewares) {
        ArrayList middlewaresList1 = new ArrayList();
        if (middlewares != null) {
            List middlewaresdatas = middlewares.get("middlewares");
            for (Map middlewaresdata : middlewaresdatas) {
                HashMap map = new HashMap(8);
                map.put("type", middlewaresdata.get("type"));
                String ip = (String)middlewaresdata.get("ip");
                map.put("ip", ip);
                map.put("host_type", middlewaresdata.get("host_type"));
                int port = (Integer)middlewaresdata.get("port");
                map.put("port", port);
                map.put("version", middlewaresdata.get("version"));
                String status = new ComponentStatusCheckerBySocket().check(middlewaresdata.get("type").toString(), ip, port);
                if (status.equals("ok")) {
                    map.put("status", "ok");
                    map.put("exception", "");
                } else {
                    map.put("status", "exception");
                    map.put("exception", status);
                }
                middlewaresList1.add(map);
            }
            HashMap<String, List> middlewaresList = new HashMap<String, List>(1);
            middlewaresList.put("middlewaresList", middlewaresList1);
            return middlewaresList;
        }
        return null;
    }
}

