/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.tenantresource;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.eye.api.tenantresource.ResourceQueueConfig;
import kd.bos.eye.api.tenantresource.TenantConfigMonitorDao;
import kd.bos.eye.api.tenantresource.TenantWeightPriority;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.resource.balancer.quota.TenantWeightManage;
import kd.bos.resource.balancer.quota.config.TenantConfigInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TenantConfigHandler
extends AbstractHttpHandler {
    private static final Log LOGGER = LogFactory.getLog(TenantConfigHandler.class);
    private TenantConfigMonitorDao dao = new TenantConfigMonitorDao();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        String resourceName = params.get("resourceName");
        String dataType = params.get("dataType");
        ApiResponse response = new ApiResponse();
        response.setMsg("success");
        response.setCode(0);
        HashMap<String, List<TenantWeightPriority>> data = new HashMap<String, List<TenantWeightPriority>>(2);
        List<Object> obj = null;
        try {
            if ("1".equals(dataType)) {
                List resourceList = ResourceConfigManage.getAllResourceList();
                resourceName = StringUtils.isEmpty((String)resourceName) ? (String)resourceList.get(0) : resourceName;
                obj = this.getTenantConfigInfoList(resourceName);
                data.put("resourceList", resourceList);
            } else if ("2".equals(dataType)) {
                obj = this.getDefaultTenantConfigInfoList();
            } else if ("3".equals(dataType)) {
                obj = this.getDefaultResourceQueueConfigList();
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            response.setMsg("fail to query:" + e.getMessage());
            response.setCode(-1);
        }
        data.put("dataList", obj);
        response.setData(data);
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    public List<TenantConfigInfo> getTenantConfigInfoList(String resourceName) {
        List accounts = TenantWeightManage.getAllAccountsOfCurrentEnv();
        ArrayList<TenantConfigInfo> tenants = new ArrayList<TenantConfigInfo>(16);
        ResourceQueueConfig resourceQueueConfig = this.dao.getResourceQueueConfig(resourceName);
        int totalWeight = 0;
        for (Account account : accounts) {
            String accountId = account.getAccountId();
            TenantConfigInfo tenantConfigInfo = this.dao.getTenantConfigFromDB(resourceName, accountId);
            TenantWeightPriority defaultTenant = this.dao.getTenantWeightPriority(accountId);
            if (tenantConfigInfo == null) {
                tenantConfigInfo = new TenantConfigInfo(resourceName, accountId);
                tenantConfigInfo.setWeight(-1);
                tenantConfigInfo.setMaxQueueSize(-1);
            }
            tenantConfigInfo.setTenantId(account.getTenantId());
            tenantConfigInfo.setAccountName(account.getAccountName());
            tenantConfigInfo.setPriority(defaultTenant.getPriority());
            tenantConfigInfo.setBaseWeight(defaultTenant.getWeight());
            tenantConfigInfo.setBaseQueueSize(resourceQueueConfig.getMaxQueueSize());
            totalWeight = tenantConfigInfo.getWeight() <= 0 ? (totalWeight += tenantConfigInfo.getBaseWeight()) : (totalWeight += tenantConfigInfo.getWeight());
            tenants.add(tenantConfigInfo);
        }
        for (TenantConfigInfo tenant : tenants) {
            int weight = tenant.getWeight() < 0 ? tenant.getBaseWeight() : tenant.getWeight();
            int proportion = 100 * weight / totalWeight;
            tenant.setProportion(proportion);
        }
        return tenants;
    }

    public List<TenantWeightPriority> getDefaultTenantConfigInfoList() {
        List accounts = TenantWeightManage.getAllAccountsOfCurrentEnv();
        ArrayList<TenantWeightPriority> tenants = new ArrayList<TenantWeightPriority>(16);
        int totalWeight = 0;
        for (Account account : accounts) {
            String accountId = account.getAccountId();
            TenantWeightPriority newOne = this.dao.getTenantWeightPriority(accountId);
            newOne.setAccountName(account.getAccountName());
            newOne.setTenantId(account.getTenantId());
            totalWeight += newOne.getWeight();
            tenants.add(newOne);
        }
        for (TenantWeightPriority tenant : tenants) {
            int proportion = 100 * tenant.getWeight() / totalWeight;
            tenant.setProportion(proportion);
        }
        return tenants;
    }

    public List<ResourceQueueConfig> getDefaultResourceQueueConfigList() {
        List resourceList = ResourceConfigManage.getAllResourceList();
        ArrayList<ResourceQueueConfig> configs = new ArrayList<ResourceQueueConfig>(6);
        for (String r : resourceList) {
            ResourceQueueConfig newConfig = this.dao.getResourceQueueConfig(r);
            configs.add(newConfig);
        }
        return configs;
    }
}

