/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.tenantresource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.tenantresource.entity.MetricsEnum;
import kd.bos.eye.api.tenantresource.entity.TenantMetrics;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.resource.balancer.quota.TenantWeightManage;
import kd.bos.util.JSONUtils;

public class TenantMetricsHandler
extends AbstractHttpHandler {
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final String SPLIT = "-";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        Map params = ExchangeVueUtils.parseJsonFromPost(exchange, Map.class);
        JSONArray array = storage.queryTenantMetrics(params);
        List list = array.toJavaList(TenantMetrics.class);
        Map<String, List> groupedAndSorted = list.stream().collect(Collectors.groupingBy(tenantMetrics -> tenantMetrics.getIp() + SPLIT + tenantMetrics.getAccountId() + SPLIT + tenantMetrics.getResourceName(), Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted(Comparator.comparing(TenantMetrics::getTimestamp)).collect(Collectors.toList()))));
        List accounts = TenantWeightManage.getAllAccountsOfCurrentEnv();
        HashMap nameMap = new HashMap(accounts.size());
        accounts.forEach(a -> nameMap.put(a.getAccountId(), a.getAccountName()));
        JSONObject retData = new JSONObject();
        for (Map.Entry<String, List> groupEntry : groupedAndSorted.entrySet()) {
            String id = groupEntry.getKey();
            List metrics = groupEntry.getValue();
            String appName = "";
            ArrayList<String> legends = new ArrayList<String>(3);
            legends.add(MetricsEnum.ACTIVE.getLabel());
            legends.add(MetricsEnum.WAITING.getLabel());
            legends.add(MetricsEnum.REJECTED.getLabel());
            HashMap<String, List> yData = new HashMap<String, List>(6);
            ArrayList<String> xData = new ArrayList<String>(16);
            for (TenantMetrics tenantMetrics2 : metrics) {
                if ("".equals(appName)) {
                    appName = tenantMetrics2.getAppName();
                }
                xData.add(tenantMetrics2.getxAxis());
                List aData = yData.computeIfAbsent(MetricsEnum.ACTIVE.getLabel(), k -> new ArrayList(16));
                aData.add(tenantMetrics2.getActive());
                List wData = yData.computeIfAbsent(MetricsEnum.WAITING.getLabel(), k -> new ArrayList(16));
                wData.add(tenantMetrics2.getWaiting());
                List rData = yData.computeIfAbsent(MetricsEnum.REJECTED.getLabel(), k -> new ArrayList(16));
                rData.add(tenantMetrics2.getRejected());
            }
            JSONObject data = new JSONObject();
            String[] sp = id.split(SPLIT);
            String accountId = sp.length > 1 ? sp[1] : sp[0];
            String name = nameMap.containsKey(accountId) ? (String)nameMap.get(accountId) : accountId;
            String title = appName + SPLIT + id.replace(accountId, name);
            data.put("name", (Object)title);
            data.put("xAxis", xData);
            data.put("legendData", legends);
            data.put("yAxis", yData);
            retData.put(id, (Object)data);
        }
        ApiResponse<JSONObject> apiResponse = new ApiResponse<JSONObject>();
        apiResponse.setData(retData);
        apiResponse.setCode(0);
        this.writeJson(JSONUtils.toString(apiResponse), exchange);
    }
}

