/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thirdauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.api.thirdauth.AuthRequestInfo;
import kd.bos.eye.api.thirdauth.AuthResponseInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.auth.third.DefaultTokenCheckPlugin;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;

public class ThirdAuthHandler
implements HttpHandler {
    private final Log logger = LogFactory.getLog(ThirdAuthHandler.class);
    public static final ThirdAuthHandler instance = new ThirdAuthHandler();
    private static final String HOME_URL = "/monitor/eye/#/thirdAuth";
    private static final String PLUGIN_PREFIX = "monitor.auth.plugin";
    private static final String MONITOR_AUTH_LOCATION_PATH = "monitor.auth.location.path";
    private static final String URL_SUFFIX = "url";
    private static final String DEFAULT_PLUGIN = "default";
    private static Map<String, String> locationPathMap = new ConcurrentHashMap<String, String>();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String locationPath;
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        if (!params.containsKey("token") && EyeAuther.check(exchange)) {
            String token = EyeAuther.getToken(exchange);
            ApiResponse apiResponse = new ApiResponse();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("clusterName", Instance.getClusterName());
            data.put("webPort", Integer.getInteger("EYE_HTTP_PORT"));
            data.put("circuitbreaker", System.getProperty("circuitbreaker.type", "nothing").toLowerCase());
            data.put("traceType", System.getProperty("gov.trace.reporter.type", "sword").toLowerCase());
            data.put("locationPath", locationPathMap.remove(token));
            apiResponse.setCode(0);
            apiResponse.setData(data);
            apiResponse.setMsg("success");
            String str = JSONUtils.toString(apiResponse);
            this.writeJson(str, exchange, token);
            return;
        }
        AuthResponseInfo response = new AuthResponseInfo();
        AuthRequestInfo request = new AuthRequestInfo(params.get("user"), params.get("role"), params.get("source"), params.get("token"), params.get("context"));
        if (!request.isComplete()) {
            this.sendParamsError(response, exchange);
            return;
        }
        String plugin = System.getProperty("monitor.auth.plugin." + request.getSource(), DEFAULT_PLUGIN);
        if (plugin.equals(DEFAULT_PLUGIN)) {
            String authUrl = System.getProperty("monitor.auth.plugin." + request.getSource() + "." + URL_SUFFIX);
            if (authUrl == null) {
                this.sendAuthUrlError(response, exchange);
                return;
            }
            DefaultTokenCheckPlugin tokenCheckPlugin = new DefaultTokenCheckPlugin();
            if (!tokenCheckPlugin.check(params)) {
                this.sendCheckError(response, exchange);
                return;
            }
        } else {
            Class<?> tokenCheckPlugin;
            try {
                tokenCheckPlugin = Class.forName(plugin);
            }
            catch (ClassNotFoundException e) {
                this.sendClassNotFoundError(response, exchange, e);
                return;
            }
            if (!this.checkByThridPlugin(tokenCheckPlugin, params)) {
                this.sendCheckError(response, exchange);
                return;
            }
        }
        if (StringUtils.isNotEmpty((String)(locationPath = params.get("locationPath")))) {
            locationPathMap.put(params.get("token"), locationPath);
        }
        this.success(exchange, request);
    }

    private void sendParamsError(AuthResponseInfo response, HttpExchange exchange) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_0", (String)"Parameter Error", (Object[])new Object[0]));
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange, null);
    }

    private void sendAuthUrlError(AuthResponseInfo response, HttpExchange exchange) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_1", (String)"Token Verification HTTP Interface not configured", (Object[])new Object[0]));
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange, null);
    }

    private void sendCheckError(AuthResponseInfo response, HttpExchange exchange) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_2", (String)"Token Verification Failed", (Object[])new Object[0]));
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange, null);
    }

    private void sendClassNotFoundError(AuthResponseInfo response, HttpExchange exchange, Exception e) throws IOException {
        response.setCode("1");
        response.setMessage(LangRes.get((String)"ThirdAuthHandler_3", (String)"Verification Plugin does not exist", (Object[])new Object[0]) + "Eeception: " + e);
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange, null);
    }

    private boolean checkByThridPlugin(Class<?> tokenCheckPlugin, Map<String, String> params) {
        boolean isSucceed = false;
        try {
            Method checkMethod = tokenCheckPlugin.getMethod("check", Map.class);
            isSucceed = (Boolean)checkMethod.invoke(tokenCheckPlugin.newInstance(), params);
        }
        catch (Exception e) {
            this.logger.error("Method invoke is fialed.", (Throwable)e);
        }
        return isSucceed;
    }

    protected void writeJson(String str, HttpExchange exchange, String token) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        if (StringUtils.isNotEmpty((String)token)) {
            exchange.getResponseHeaders().add("monitor-csrf-token", EyeAuther.getCsrfToken(token));
        }
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void success(HttpExchange exchange, AuthRequestInfo request) throws IOException {
        this.writeSession(request);
        exchange.getResponseHeaders().add("Set-Cookie", EyeAuther.AUTH_TOKEN + "=" + request.getToken() + ";path=/");
        String baseUrl = StringUtils.isEmpty((String)request.getContext()) ? SystemProperties.getProperty((String)"JETTY_CONTEXT", (String)"/ierp") : "/" + request.getContext();
        exchange.getResponseHeaders().add("Location", baseUrl + HOME_URL);
        exchange.sendResponseHeaders(302, -1L);
        exchange.close();
    }

    private void writeSession(AuthRequestInfo request) {
        HashMap<String, String> info = new HashMap<String, String>();
        String csrfToken = StringUtils.randomWord((int)32);
        info.put("user", request.getUser());
        info.put("role", request.getRole());
        info.put("source", request.getSource());
        info.put("token", request.getToken());
        info.put("monitor-csrf-token", csrfToken);
        info.put("logintype", "ierp");
        info.put("isFirstLogin", "false");
        info.put("isExpired", "false");
        SessionStore.get().store(request.getToken(), info);
    }
}

