/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.thread.ThreadDumpParamHook;
import kd.bos.eye.api.thread.ThreadDumpUtil;
import kd.bos.eye.api.thread.ThreadInfo;
import kd.bos.eye.api.thread.entity.AllThreadDumpInfo;
import kd.bos.eye.api.thread.entity.ThreadDumpInfo;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewThreadDumpProxyHandler
extends AbstractHttpHandler {
    private static final String TIME_SYMBOL = "/time:";
    private static final String TRACE_ID_SYMBOL = "/traceId:";
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final Set<String> excludeThreadNames = new HashSet<String>(6);
    private static final String HIDDEN_THREADS = System.getProperty("monitor.hidden.threads", "HistoricalDataClearService,ShardingMovingService,MsgJetSubscirbe,PKTempTableDBRegistryHeartbeatService,PKTempTableDBRegistryClearService");
    private static final List<String> monitorThreadList = new ArrayList<String>();
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Logger log = LoggerFactory.getLogger(NewThreadDumpProxyHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        AllThreadDumpInfo allThreadDumpInfo = this.createAllThreadDumpInfo(exchange);
        String str = JSONUtils.toString((Object)allThreadDumpInfo);
        this.writeJson(str, exchange);
    }

    private AllThreadDumpInfo createAllThreadDumpInfo(HttpExchange exchange) {
        List<ThreadInfo> filterThreadInfoList = this.filteredThreadInfoList(exchange, this.getThreadInfoList());
        List<String> deadLockThreadInfoList = this.getDeadLockThreadInfoList();
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String appName = params.get("appname");
        String ip = params.get("ip");
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>(16);
        HashMap<String, ThreadDumpInfo.ThreadDumpStatistic> threadDumpStatisticMap = new HashMap<String, ThreadDumpInfo.ThreadDumpStatistic>(8);
        AllThreadDumpInfo allThreadDumpInfo = new AllThreadDumpInfo();
        allThreadDumpInfo.setThreadDumpInfoList(threadDumpInfoList);
        allThreadDumpInfo.setThreadDumpStatisticMap(threadDumpStatisticMap);
        for (ThreadInfo threadInfo : filterThreadInfoList) {
            try {
                String afterShowTime;
                ThreadDumpInfo threadDumpInfo = new ThreadDumpInfo();
                RequestContext requestContext = this.getRequestContext(threadInfo);
                if (requestContext != null) {
                    threadDumpInfo.setClientUrl(requestContext.getClientUrl());
                    threadDumpInfo.setTenantId(requestContext.getTenantId());
                    if (!this.enableControlPrivacy()) {
                        threadDumpInfo.setUserName(requestContext.getUserName());
                    }
                    if (StringUtils.isNotEmpty((String)requestContext.getQueryString())) {
                        Map<String, String> parameterMap = this.parseQueryString(requestContext.getQueryString());
                        threadDumpInfo.setFormId(parameterMap.get("f"));
                        threadDumpInfo.setAction(parameterMap.get("ac"));
                    }
                    threadDumpInfo.setSupportTerminationSql(ThreadDumpUtil.isSupportTerminationSql(requestContext));
                }
                if (StringUtils.isEmpty((String)(afterShowTime = ThreadDumpParamHook.getValue("monitor.threaddump.termination.showtime")))) {
                    afterShowTime = "30";
                }
                threadDumpInfo.setAfterTimeShow(Long.parseLong(afterShowTime));
                threadDumpInfo.setAppName(appName);
                threadDumpInfo.setIp(ip);
                threadDumpInfo.setThreadId(threadInfo.getThreadId());
                String threadName = threadInfo.getThreadName();
                threadDumpInfo.setThreadName(threadName);
                this.handleThreadStatisticMap(threadInfo, threadDumpStatisticMap);
                this.fillThreadDumpInfo(threadInfo, threadDumpInfo);
                threadDumpInfo.setMemSpanInfoList(threadInfo.getMemSpanInfo());
                threadDumpInfo.setRemoteIPAndPort(this.getRemoteIpAndPort(threadInfo.getMemSpanInfo()));
                threadDumpInfo.setMonitorPort(MonitorConfig.getMonitorPort());
                ArrayList<String> stackInfoList = new ArrayList<String>(16);
                for (StackTraceElement stackTraceElement : threadInfo.getStackTraceElements()) {
                    stackInfoList.add(stackTraceElement.toString());
                }
                threadDumpInfo.setStackTraceInfoList(stackInfoList);
                threadDumpInfoList.add(threadDumpInfo);
            }
            catch (Exception e) {
                log.error("NewThreadDumpProxyHandler: threadDump query error, error info: {}, Log TraceId: {}", (Object)e.getMessage(), (Object)RequestContext.get().getTraceId());
            }
        }
        allThreadDumpInfo.setDeadLockList(deadLockThreadInfoList);
        return allThreadDumpInfo;
    }

    private List<ThreadInfo> getThreadInfoList() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        ArrayList<ThreadInfo> threadInfoList = new ArrayList<ThreadInfo>();
        allStackTraces.forEach((thread, stackTraceElements) -> {
            ThreadInfo threadInfo = new ThreadInfo(thread.getId(), thread.getName(), (StackTraceElement[])stackTraceElements, (Thread)thread);
            List threadTraceStatList = TraceStatistics.getThreadTraceStatisticInfo((Thread)thread);
            threadInfo.setTraceStatisticList(threadTraceStatList);
            Map instrumentMap = TracerImpl.getInstrumentMap((Thread)thread);
            ArrayList<ThreadInfo.MemSpanInfo> memSpanInfoList = new ArrayList<ThreadInfo.MemSpanInfo>(4);
            if (instrumentMap != null) {
                instrumentMap.forEach((memSpan, timeStamp) -> {
                    Instant instant = Instant.ofEpochMilli(timeStamp);
                    ThreadInfo.MemSpanInfo memSpanInfo = new ThreadInfo.MemSpanInfo();
                    memSpanInfo.setExecuteMethod(memSpan.getType() + "." + memSpan.getName());
                    memSpanInfo.setMethodDuration(String.valueOf(System.currentTimeMillis() - timeStamp));
                    memSpanInfo.setMethodStartTime(dateTimeFormatter.format(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault())));
                    ArrayList<KeyValueEntity> details = new ArrayList<KeyValueEntity>(4);
                    Map tags = memSpan.tags();
                    if (tags != null) {
                        tags.forEach((tagKey, tagValue) -> {
                            if (!"service".equals(tagKey)) {
                                details.add(new KeyValueEntity((String)tagKey, tagValue));
                            }
                        });
                    }
                    memSpanInfo.setDetails(details);
                    memSpanInfoList.add(memSpanInfo);
                });
            }
            threadInfo.setMemSpanInfo(memSpanInfoList);
            threadInfoList.add(threadInfo);
        });
        return threadInfoList;
    }

    private List<String> getDeadLockThreadInfoList() {
        long[] deadLockedThreadIds = threadMXBean.findDeadlockedThreads();
        if (deadLockedThreadIds == null || deadLockedThreadIds.length == 0) {
            return null;
        }
        ArrayList<String> deadLockThreadInfoList = new ArrayList<String>(deadLockedThreadIds.length);
        for (long pid : deadLockedThreadIds) {
            java.lang.management.ThreadInfo threadInfo = threadMXBean.getThreadInfo(pid, Integer.MAX_VALUE);
            String threadInfoString = threadInfo.toString();
            threadInfoString = threadInfoString.replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;").replaceAll("owned by", "owned by Thread ");
            deadLockThreadInfoList.add("Thread " + threadInfoString + "<br>");
        }
        return deadLockThreadInfoList;
    }

    private List<ThreadInfo> filteredThreadInfoList(HttpExchange exchange, List<ThreadInfo> threadInfoList) {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String paramThreadLive = params.get("live");
        String paramLiveSize = params.get("livesize");
        String paramThreadName = params.get("threadname");
        String paramKey = params.get("key");
        String paramExcludeKey = params.get("excludeKey");
        String traceId = params.get("traceId") == null ? "" : params.get("traceId");
        boolean isLive = "true".equals(paramThreadLive) || "on".equals(paramThreadLive);
        ArrayList<String> excludeKeys = null;
        if (StringUtils.isNotEmpty((String)paramExcludeKey)) {
            excludeKeys = new ArrayList<String>(Arrays.asList(paramExcludeKey.split("[,;]")));
        }
        int liveSize = 18;
        if (paramLiveSize != null) {
            try {
                liveSize = Integer.parseInt(paramLiveSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int finalLiveSize = liveSize;
        ArrayList<String> finalExcludeKeys = excludeKeys;
        if (paramThreadName != null && paramThreadName.contains("otherthread")) {
            List filteredThreadInfoList1 = threadInfoList.stream().filter(threadInfo -> this.isOutputThreadInfo((ThreadInfo)threadInfo, paramThreadName, (List<String>)finalExcludeKeys, finalLiveSize, isLive)).filter(threadInfo -> this.isContainKey((ThreadInfo)threadInfo, paramKey)).filter(threadInfo -> threadInfo.getThreadName().contains(traceId)).collect(Collectors.toList());
            List filteredThreadInfoList2 = threadInfoList.stream().filter(threadInfo -> this.isOutputOtherThreadInfo((ThreadInfo)threadInfo, paramThreadName, (List<String>)finalExcludeKeys, finalLiveSize, isLive)).filter(threadInfo -> this.isContainKey((ThreadInfo)threadInfo, paramKey)).filter(threadInfo -> threadInfo.getThreadName().contains(traceId)).collect(Collectors.toList());
            ArrayList<ThreadInfo> newList = new ArrayList<ThreadInfo>();
            newList.addAll(filteredThreadInfoList1);
            newList.addAll(filteredThreadInfoList2);
            return newList;
        }
        return threadInfoList.stream().filter(threadInfo -> this.isOutputThreadInfo((ThreadInfo)threadInfo, paramThreadName, (List<String>)finalExcludeKeys, finalLiveSize, isLive)).filter(threadInfo -> this.isContainKey((ThreadInfo)threadInfo, paramKey)).filter(threadInfo -> threadInfo.getThreadName().contains(traceId)).collect(Collectors.toList());
    }

    private boolean isOutputOtherThreadInfo(ThreadInfo threadInfo, String paramThreadName, List<String> excludeKeys, int liveSize, boolean isLive) {
        StackTraceElement[] stackTraceElements;
        String threadName = threadInfo.getThreadName();
        String paramThreadName1 = "RpcRequest,http-request-pool,MQConsumerChannelMonitor,RabbitMqAsyncConsumer,BOSSchedule,";
        if (threadName.toLowerCase().contains("http-request-pool")) {
            return false;
        }
        if (threadName.toLowerCase().contains("rpcrequest")) {
            return false;
        }
        if (threadName.toLowerCase().contains("mqconsumerchannelmonitor")) {
            return false;
        }
        if (threadName.toLowerCase().contains("rabbitmqasyncconsumer")) {
            return false;
        }
        if (threadName.toLowerCase().contains("bosschedule")) {
            return false;
        }
        for (String exclude : excludeThreadNames) {
            if (!threadName.contains(exclude)) continue;
            return false;
        }
        if (excludeKeys != null) {
            for (String excludeKey : excludeKeys) {
                if (threadInfo.getThreadName().contains(excludeKey)) {
                    return false;
                }
                StackTraceElement[] stackTraceElementArray = threadInfo.getStackTraceElements();
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    if (!stackTraceElement.getClassName().contains(excludeKey) && !stackTraceElement.getMethodName().contains(excludeKey)) continue;
                    return false;
                }
            }
        }
        if ((stackTraceElements = threadInfo.getStackTraceElements()) == null) {
            return false;
        }
        if (stackTraceElements.length > 0 && stackTraceElements[0] != null && stackTraceElements[0].toString().contains("Thread.dumpThreads")) {
            return false;
        }
        if (threadName.toLowerCase().contains("abandoned connection")) {
            return false;
        }
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (!stackTraceElement.toString().contains("ProxyHandler")) continue;
            return false;
        }
        return !isLive || stackTraceElements.length >= liveSize;
    }

    private boolean isOutputThreadInfo(ThreadInfo threadInfo, String paramThreadName, List<String> excludeKeys, int liveSize, boolean isLive) {
        StackTraceElement[] stackTraceElements;
        String threadName = threadInfo.getThreadName();
        for (String exclude : excludeThreadNames) {
            if (!threadName.contains(exclude)) continue;
            return false;
        }
        if (excludeKeys != null) {
            for (String excludeKey : excludeKeys) {
                if (threadInfo.getThreadName().contains(excludeKey)) {
                    return false;
                }
                StackTraceElement[] stackTraceElementArray = threadInfo.getStackTraceElements();
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    if (!stackTraceElement.getClassName().contains(excludeKey) && !stackTraceElement.getMethodName().contains(excludeKey)) continue;
                    return false;
                }
            }
        }
        if ((stackTraceElements = threadInfo.getStackTraceElements()) == null) {
            return false;
        }
        if (stackTraceElements.length > 0 && stackTraceElements[0] != null && stackTraceElements[0].toString().contains("Thread.dumpThreads")) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)paramThreadName)) {
            String[] threadNames = paramThreadName.split(",");
            for (int i = 0; i < threadNames.length && !threadName.toLowerCase().contains(threadNames[i].toLowerCase()); ++i) {
                if (i != threadNames.length - 1) continue;
                return false;
            }
        }
        if (threadName.toLowerCase().contains("abandoned connection")) {
            return false;
        }
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (!stackTraceElement.toString().contains("ProxyHandler")) continue;
            return false;
        }
        return !isLive || stackTraceElements.length >= liveSize;
    }

    private boolean isContainKey(ThreadInfo threadInfo, String paramKey) {
        if (paramKey == null) {
            return true;
        }
        String[] keys = paramKey.split("[,;]");
        boolean isContain = false;
        block0: for (String key : keys) {
            if (threadInfo.getThreadName().contains(key)) {
                isContain = true;
                break;
            }
            for (StackTraceElement stackTraceElement : threadInfo.getStackTraceElements()) {
                if (!stackTraceElement.getClassName().contains(key) && !stackTraceElement.getMethodName().contains(key)) continue;
                isContain = true;
                continue block0;
            }
        }
        return isContain;
    }

    private void fillThreadDumpInfo(ThreadInfo threadInfo, ThreadDumpInfo threadDumpInfo) {
        String showThreadName;
        String threadName = threadInfo.getThreadName();
        int pos = threadName.indexOf(TIME_SYMBOL);
        String traceId = null;
        if (pos > 0) {
            showThreadName = threadName.substring(0, pos);
            try {
                long time = Long.parseLong(threadName.substring(pos + TIME_SYMBOL.length(), pos + 13 + TIME_SYMBOL.length()));
                threadDumpInfo.setStartTime(dateTimeFormatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault())));
                threadDumpInfo.setDuration(String.valueOf(System.currentTimeMillis() - time));
            }
            catch (NumberFormatException e) {
                showThreadName = threadName;
            }
            int traceIdPos = threadName.indexOf(TRACE_ID_SYMBOL);
            if (traceIdPos > 0) {
                traceId = threadName.substring(traceIdPos + TRACE_ID_SYMBOL.length()).split("/")[0];
            }
        } else {
            showThreadName = threadName;
            threadDumpInfo.setStartTime("");
            threadDumpInfo.setDuration("");
        }
        threadDumpInfo.setShowThreadName(showThreadName);
        if (traceId != null) {
            threadDumpInfo.setTraceId(traceId);
        }
        if (pos > 0 && threadInfo.getTraceStatisticList() != null) {
            threadDumpInfo.setThreadTraceStatList(threadInfo.getTraceStatisticList());
        }
    }

    private void handleThreadStatisticMap(ThreadInfo threadInfo, Map<String, ThreadDumpInfo.ThreadDumpStatistic> threadDumpStatisticMap) {
        boolean find = false;
        for (String monitorThread : monitorThreadList) {
            if (!threadInfo.getThread().getName().contains(monitorThread)) continue;
            this.handleThreadStatistic(threadDumpStatisticMap, threadInfo, monitorThread);
            find = true;
        }
        if (!find) {
            this.handleThreadStatistic(threadDumpStatisticMap, threadInfo, "other");
        }
    }

    private void handleThreadStatistic(Map<String, ThreadDumpInfo.ThreadDumpStatistic> threadDumpStatisticMap, ThreadInfo threadInfo, String monitorThread) {
        if (threadInfo.getThread().getState() == Thread.State.WAITING) {
            this.fillStatisticMap(threadDumpStatisticMap, monitorThread, "WAITING");
        } else if (threadInfo.getThread().getState() == Thread.State.RUNNABLE) {
            this.fillStatisticMap(threadDumpStatisticMap, monitorThread, "RUNNABLE");
        } else if (threadInfo.getThread().getState() == Thread.State.BLOCKED) {
            this.fillStatisticMap(threadDumpStatisticMap, monitorThread, "BLOCKED");
        } else if (threadInfo.getThread().getState() == Thread.State.TIMED_WAITING) {
            this.fillStatisticMap(threadDumpStatisticMap, monitorThread, "TIMED_WAITING");
        }
    }

    private void fillStatisticMap(Map<String, ThreadDumpInfo.ThreadDumpStatistic> paramThreadDumpStatisticMap, String monitorThread, String flag) {
        ThreadDumpInfo.ThreadDumpStatistic threadDumpStatistic = paramThreadDumpStatisticMap.get(flag);
        if (threadDumpStatistic == null) {
            threadDumpStatistic = new ThreadDumpInfo.ThreadDumpStatistic();
            threadDumpStatistic.setTotal(1);
            paramThreadDumpStatisticMap.put(flag, threadDumpStatistic);
        } else {
            threadDumpStatistic.setTotal(threadDumpStatistic.getTotal() + 1);
        }
        Map<String, Integer> subStatMap = threadDumpStatistic.getSubStatisticMap();
        if (subStatMap == null) {
            subStatMap = new HashMap<String, Integer>();
            threadDumpStatistic.setSubStatisticMap(subStatMap);
        }
        subStatMap.merge(monitorThread, 1, Integer::sum);
    }

    private String getRemoteIpAndPort(List<ThreadInfo.MemSpanInfo> memSpanInfoList) {
        String ipAndPort = null;
        for (ThreadInfo.MemSpanInfo memSpanInfo : memSpanInfoList) {
            String executeMethod = memSpanInfo.getExecuteMethod();
            if (!executeMethod.contains("DefaultFuture.get")) continue;
            for (KeyValueEntity keyValueEntity : memSpanInfo.getDetails()) {
                if (!keyValueEntity.getKey().equals("remoteUrl")) continue;
                ipAndPort = keyValueEntity.getValue().toString().substring(1);
            }
        }
        return ipAndPort;
    }

    private RequestContext getRequestContext(ThreadInfo threadInfo) {
        RequestContext requestContext = null;
        try {
            Field field = RequestContext.class.getDeclaredField("current");
            field.setAccessible(true);
            requestContext = (RequestContext)ThreadLocalUtils.getThreadLocalValue((Thread)threadInfo.getThread(), (ThreadLocal)((ThreadLocal)field.get(null)));
        }
        catch (Exception e) {
            log.error("get RequestContext fiald. ", (Throwable)e);
        }
        return requestContext;
    }

    private Map<String, String> parseQueryString(String queryString) {
        String[] params = queryString.split("&");
        HashMap<String, String> queryMap = new HashMap<String, String>(params.length);
        for (String param : params) {
            if (param.isEmpty() || !param.contains("=")) continue;
            String[] keyValue = param.split("=");
            queryMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
        }
        return queryMap;
    }

    private boolean enableControlPrivacy() {
        String enablePrivacy = System.getProperty("monitor.privacy.enable", "false");
        return "true".equalsIgnoreCase(enablePrivacy);
    }

    static {
        String DEFAULT_MONITOR_THREAD = "RpcRequest,MQ-rabbit-pool,http-request";
        String monitorThread = System.getProperty("monitor_threads", DEFAULT_MONITOR_THREAD);
        String[] threads = monitorThread.split(",");
        monitorThreadList.addAll(Arrays.asList(threads));
        excludeThreadNames.add("monitor-http");
        String[] split = HIDDEN_THREADS.split(",");
        excludeThreadNames.addAll(Arrays.asList(split));
    }
}

