/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.thread.ThreadDumpParamHook;
import kd.bos.eye.api.thread.ThreadDumpUtil;
import kd.bos.eye.api.thread.ThreadInfo;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpApiHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumpApiHandler.class);
    private static final String TIME_STR = "/time:";
    private static Set<String> excludeThreadNameSet = new HashSet<String>(6);
    private static final String TRACE_ID_STR = "/traceId:";
    private static final String DEFAULT_MONITOR_THREAD = "RpcRequest,MQ-rabbit-pool,http-request";
    private static ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private static List<String> monitorThreads = new ArrayList<String>(16);
    private static final String HIDDEN_THREADS = System.getProperty("monitor.hidden.threads", "HistoricalDataClearService,ShardingMovingService,MsgJetSubscirbe,PKTempTableDBRegistryHeartbeatService,PKTempTableDBRegistryClearService");

    private List<ThreadInfo> getSortedThreadsInfo() {
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        ArrayList<ThreadInfo> threads = new ArrayList<ThreadInfo>(32);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        threadMap.forEach((key, stes) -> {
            ThreadInfo threadInfoObj = new ThreadInfo(key.getId(), key.getName(), (StackTraceElement[])stes, (Thread)key);
            List threadTraceStatList = TraceStatistics.getThreadTraceStatisticInfo((Thread)key);
            threadInfoObj.setTraceStatisticList(threadTraceStatList);
            threads.add(threadInfoObj);
            Map spanMap = TracerImpl.getInstrumentMap((Thread)key);
            ArrayList<ThreadInfo.MemSpanInfo> memSpanInfos = new ArrayList<ThreadInfo.MemSpanInfo>(4);
            threadInfoObj.setMemSpanInfo(memSpanInfos);
            if (spanMap != null) {
                spanMap.forEach((spanKey, spanVal) -> {
                    cal.setTimeInMillis((long)spanVal);
                    ThreadInfo.MemSpanInfo memSpanInfo = new ThreadInfo.MemSpanInfo();
                    memSpanInfo.setExecuteMethod(spanKey.getType() + "." + spanKey.getName());
                    memSpanInfo.setMethodDuration(String.valueOf(System.currentTimeMillis() - spanVal));
                    memSpanInfo.setMethodStartTime(formatter.format(cal.getTime()));
                    ArrayList<KeyValueEntity> detailList = new ArrayList<KeyValueEntity>(4);
                    memSpanInfo.setDetails(detailList);
                    Map tagMap = spanKey.tags();
                    if (tagMap != null) {
                        tagMap.forEach((tKey, tValue) -> {
                            if (!"service".equals(tKey)) {
                                detailList.add(new KeyValueEntity((String)tKey, tValue));
                            }
                        });
                    }
                    memSpanInfos.add(memSpanInfo);
                });
            }
        });
        return ThreadDumpApiHandler.sort(threads);
    }

    private boolean isOutPrintThread(ThreadInfo t, String threadname, boolean isDbThread, int livesize, boolean live) {
        String _threadName = t.getThreadName();
        for (String exclude : excludeThreadNameSet) {
            if (!_threadName.toLowerCase().contains(exclude.toLowerCase())) continue;
            return false;
        }
        StackTraceElement[] stes = t.getStackTraceElements();
        if (stes.length > 0 && stes[0] != null && stes[0].toString().contains("Thread.dumpThreads")) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)threadname) && !_threadName.toLowerCase().contains(threadname.toLowerCase())) {
            return false;
        }
        if (_threadName.toLowerCase().contains("abandoned connection")) {
            return false;
        }
        for (StackTraceElement ste : stes) {
            String toString = ste.toString();
            if (!toString.contains("ProxyHandler")) continue;
            return false;
        }
        return !live || stes.length >= livesize;
    }

    private List<String> getDeadLockInfo() {
        long[] deadlockedThreads = mbean.findDeadlockedThreads();
        if (deadlockedThreads == null || deadlockedThreads.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(4);
        for (long pid : deadlockedThreads) {
            java.lang.management.ThreadInfo threadInfo = mbean.getThreadInfo(pid, Integer.MAX_VALUE);
            String s = threadInfo.toString();
            s = s.replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;").replaceAll("owned by", "owned by Thread ");
            list.add("Thread " + s);
        }
        return list;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String names = System.getProperty("monitor.exclude.threads");
            if (StringUtils.isNotEmpty((String)names)) {
                String[] split;
                for (String threadName : split = names.split(",")) {
                    excludeThreadNameSet.add(threadName);
                }
            }
            Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
            String tlive = params.get("live");
            String tlivesize = params.get("livesize");
            String paramThreadName = params.get("threadname");
            String dbThread = params.get("isDbThread");
            boolean isDbThread = dbThread == null ? false : "true".equals(dbThread);
            int livesize = 18;
            if (tlivesize != null) {
                try {
                    livesize = Integer.parseInt(tlivesize);
                }
                catch (Exception e) {
                    livesize = 18;
                }
            }
            boolean live = "true".equals(tlive) || "on".equals(tlive);
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List<ThreadInfo> threads = this.getSortedThreadsInfo();
            ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>(16);
            HashMap<String, ThreadDumpInfo.ThreadDumpStat> stats = new HashMap<String, ThreadDumpInfo.ThreadDumpStat>(8);
            ThreadDumpAllInfo threadDumpAllInfo = new ThreadDumpAllInfo();
            threadDumpAllInfo.setThreadDumpInfoList(threadDumpInfoList);
            threadDumpAllInfo.setThreadDumpStatMap(stats);
            for (ThreadInfo t : threads) {
                try {
                    String showThreadName;
                    boolean isOutThread;
                    StackTraceElement[] stes;
                    String afterShowTime;
                    ThreadDumpInfo threadDumpInfo = new ThreadDumpInfo();
                    threadDumpInfo.setAppName(Instance.getAppName());
                    String threadName = t.getThreadName();
                    threadDumpInfo.setThreadName(threadName);
                    threadDumpInfo.setThreadId(t.getThreadId());
                    threadDumpInfo.setMonitorPort(MonitorConfig.getMonitorPort());
                    threadDumpInfo.setIp(MonitorConfig.getMonitorIp());
                    RequestContext requestContext = this.getRequestContext(t);
                    if (requestContext != null) {
                        threadDumpInfo.setClientUrl(requestContext.getClientUrl());
                        threadDumpInfo.setTenantId(requestContext.getTenantId());
                        threadDumpInfo.setUserName(requestContext.getUserName());
                        if (StringUtils.isNotEmpty((String)requestContext.getQueryString())) {
                            Map<String, String> parameterMap = this.parseQueryString(requestContext.getQueryString());
                            threadDumpInfo.setFormId(parameterMap.get("f"));
                            threadDumpInfo.setAction(parameterMap.get("ac"));
                        }
                        threadDumpInfo.setSupportTerminationSql(ThreadDumpUtil.isSupportTerminationSql(requestContext));
                    }
                    if (StringUtils.isEmpty((String)(afterShowTime = ThreadDumpParamHook.getValue("monitor.threaddump.termination.showtime")))) {
                        afterShowTime = "30";
                    }
                    threadDumpInfo.setAfterTimeShow(Long.parseLong(afterShowTime));
                    boolean find = false;
                    for (String monitorThread : monitorThreads) {
                        if (t.getThread().getName().indexOf(monitorThread) < 0) continue;
                        this.handleThreadStat(stats, t, monitorThread);
                        find = true;
                    }
                    if (!find) {
                        this.handleThreadStat(stats, t, "others");
                    }
                    if ((stes = t.getStackTraceElements()) == null || !(isOutThread = this.isOutPrintThread(t, paramThreadName, isDbThread, livesize, live))) continue;
                    int pos = threadName.indexOf(TIME_STR);
                    String traceId = null;
                    if (pos > 0) {
                        showThreadName = threadName.substring(0, pos);
                        try {
                            long time = Long.parseLong(threadName.substring(pos + TIME_STR.length(), pos + 13 + TIME_STR.length()));
                            cal.setTimeInMillis(time);
                            threadDumpInfo.setStartTime(formatter.format(cal.getTime()));
                            threadDumpInfo.setDuration(String.valueOf(System.currentTimeMillis() - time));
                        }
                        catch (NumberFormatException e) {
                            showThreadName = threadName;
                        }
                        int traceIdPos = threadName.indexOf(TRACE_ID_STR);
                        if (traceIdPos > 0) {
                            traceId = threadName.substring(traceIdPos + TRACE_ID_STR.length()).split("/")[0];
                        }
                    } else {
                        showThreadName = threadName;
                    }
                    threadDumpInfo.setShowThreadName(showThreadName);
                    if (traceId != null) {
                        String traceType = System.getProperty("gov.trace.reporter.type");
                        String url = StringUtils.isNotEmpty((String)traceType) && traceType.contains("zipkin") ? "tc/traces/" + traceId : "#/trace-new?showFoldHeader=false&showFoldIcon=false&traceId=" + traceId;
                        threadDumpInfo.setTraceUrl(url);
                        threadDumpInfo.setTraceId(traceId);
                    }
                    threadDumpInfo.setMemSpanInfoList(t.getMemSpanInfo());
                    if (pos > 0 && t.getTraceStatisticList() != null) {
                        threadDumpInfo.setThreadTraceStatList(t.getTraceStatisticList());
                    }
                    ArrayList<String> stackInfoList = new ArrayList<String>(16);
                    for (StackTraceElement ste : stes) {
                        stackInfoList.add(ste.toString());
                    }
                    threadDumpInfo.setStackTraceInfoList(stackInfoList);
                    threadDumpInfoList.add(threadDumpInfo);
                }
                catch (Exception e) {
                    log.error("ThreadDumpApiHandler: threadDump query error, error info: {}, Log TraceId: {}", (Object)e.getMessage(), (Object)RequestContext.get().getTraceId());
                }
            }
            threadDumpAllInfo.setDeadLockList(this.getDeadLockInfo());
            response.put("code", 0);
            response.put("data", threadDumpAllInfo);
            response.put("msg", "success");
        }
        catch (Exception e) {
            log.error(LangRes.get((String)"ThreadDumpApiHandler_0", (String)"\u7ebf\u7a0b\u5806\u6808\u67e5\u8be2\u5f02\u5e38", (Object[])new Object[0]), (Throwable)e);
            response.put("code", -1);
            response.put("msg", LangRes.get((String)"ThreadDumpApiHandler_1", (String)"\u7ebf\u7a0b\u5806\u6808\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a: {0}, \u65e5\u5fd7TraceId: {1}", (Object[])new Object[]{e.getMessage(), RequestContext.get().getTraceId()}));
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void handleThreadStat(Map<String, ThreadDumpInfo.ThreadDumpStat> stats, ThreadInfo t, String monitorThread) {
        if (t.getThread().getState() == Thread.State.WAITING) {
            this.fillStatMap(stats, monitorThread, "WAITING");
        } else if (t.getThread().getState() == Thread.State.RUNNABLE) {
            this.fillStatMap(stats, monitorThread, "RUNNABLE");
        } else if (t.getThread().getState() == Thread.State.BLOCKED) {
            this.fillStatMap(stats, monitorThread, "BLOCKED");
        } else if (t.getThread().getState() == Thread.State.TIMED_WAITING) {
            this.fillStatMap(stats, monitorThread, "TIMED_WAITING");
        }
    }

    private void fillStatMap(Map<String, ThreadDumpInfo.ThreadDumpStat> stats, String monitorThread, String flag) {
        ThreadDumpInfo.ThreadDumpStat threadDumpStat = stats.get(flag);
        if (threadDumpStat == null) {
            threadDumpStat = new ThreadDumpInfo.ThreadDumpStat();
            threadDumpStat.setTotal(1);
            stats.put(flag, threadDumpStat);
        } else {
            threadDumpStat.setTotal(threadDumpStat.getTotal() + 1);
        }
        Map<String, Integer> subStatMap = threadDumpStat.getSubStatMap();
        if (subStatMap == null) {
            subStatMap = new HashMap<String, Integer>();
            threadDumpStat.setSubStatMap(subStatMap);
        }
        subStatMap.merge(monitorThread, 1, Integer::sum);
    }

    public static List<ThreadInfo> sort(List<ThreadInfo> threads) {
        ThreadInfo[] threadIfs = threads.toArray(new ThreadInfo[0]);
        int size = threadIfs.length;
        for (int i = 0; i < size; ++i) {
            for (int j = 1; j < size - i; ++j) {
                ThreadInfo threadIf1 = threadIfs[j - 1];
                ThreadInfo threadIf2 = threadIfs[j];
                String preName = threadIf1.getThreadName();
                String sufName = threadIf2.getThreadName();
                int prePos = preName.indexOf(TIME_STR);
                int sufPos = sufName.indexOf(TIME_STR);
                if (prePos < 0 && sufPos > 0) {
                    ThreadInfo temp = threadIfs[j - 1];
                    threadIfs[j - 1] = threadIfs[j];
                    threadIfs[j] = temp;
                    continue;
                }
                if (prePos <= 0 || sufPos <= 0) continue;
                try {
                    long l1 = Long.parseLong(preName.substring(prePos + TIME_STR.length()));
                    long l2 = Long.parseLong(sufName.substring(sufPos + TIME_STR.length()));
                    if (l1 <= l2) continue;
                    ThreadInfo temp = threadIfs[j - 1];
                    threadIfs[j - 1] = threadIfs[j];
                    threadIfs[j] = temp;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return Arrays.asList(threadIfs);
    }

    private RequestContext getRequestContext(ThreadInfo threadInfo) {
        RequestContext requestContext = null;
        try {
            Field field = RequestContext.class.getDeclaredField("current");
            field.setAccessible(true);
            requestContext = (RequestContext)ThreadLocalUtils.getThreadLocalValue((Thread)threadInfo.getThread(), (ThreadLocal)((ThreadLocal)field.get(null)));
        }
        catch (Exception e) {
            log.error("get RequestContext fiald. ", (Throwable)e);
        }
        return requestContext;
    }

    private Map<String, String> parseQueryString(String queryString) {
        String[] params = queryString.split("&");
        HashMap<String, String> queryMap = new HashMap<String, String>(params.length);
        for (String param : params) {
            if (param.isEmpty() || !param.contains("=")) continue;
            String[] keyValue = param.split("=");
            queryMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
        }
        return queryMap;
    }

    static {
        String monitorThreadStr = System.getProperty("monitor_threads", DEFAULT_MONITOR_THREAD);
        String[] threadsArr = monitorThreadStr.split(",");
        monitorThreads.addAll(Arrays.asList(threadsArr));
        String[] split = HIDDEN_THREADS.split(",");
        excludeThreadNameSet.add("eye-http");
        for (String threadName : split) {
            excludeThreadNameSet.add(threadName);
        }
    }

    private static class ThreadDumpInfo {
        private String appName;
        private String traceId;
        private long threadId;
        private String threadName;
        private String showThreadName;
        private String startTime;
        private String duration;
        private List<String> stackTraceInfoList;
        private String traceUrl;
        private List<TraceStatistics.ThreadTraceStat> threadTraceStatList;
        private List<ThreadInfo.MemSpanInfo> memSpanInfoList;
        private String clientUrl;
        private String userName;
        private String tenantId;
        private String formId;
        private String action;
        private String ip;
        private String monitorPort;
        private long afterTimeShow;
        private boolean isSupportTerminationSql;

        private ThreadDumpInfo() {
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public String getTraceUrl() {
            return this.traceUrl;
        }

        public void setTraceUrl(String traceUrl) {
            this.traceUrl = traceUrl;
        }

        public List<String> getStackTraceInfoList() {
            return this.stackTraceInfoList;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public void setStackTraceInfoList(List<String> stackTraceInfoList) {
            this.stackTraceInfoList = stackTraceInfoList;
        }

        public List<ThreadInfo.MemSpanInfo> getMemSpanInfoList() {
            return this.memSpanInfoList;
        }

        public void setMemSpanInfoList(List<ThreadInfo.MemSpanInfo> memSpanInfoList) {
            this.memSpanInfoList = memSpanInfoList;
        }

        public List<TraceStatistics.ThreadTraceStat> getThreadTraceStatList() {
            return this.threadTraceStatList;
        }

        public void setThreadTraceStatList(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
            this.threadTraceStatList = threadTraceStatList;
        }

        public String getShowThreadName() {
            return this.showThreadName;
        }

        public void setShowThreadName(String showThreadName) {
            this.showThreadName = showThreadName;
        }

        public String getClientUrl() {
            return this.clientUrl;
        }

        public void setClientUrl(String clientUrl) {
            this.clientUrl = clientUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public void setThreadId(long threadId) {
            this.threadId = threadId;
        }

        public String getMonitorPort() {
            return this.monitorPort;
        }

        public void setMonitorPort(String monitorPort) {
            this.monitorPort = monitorPort;
        }

        public long getAfterTimeShow() {
            return this.afterTimeShow;
        }

        public void setAfterTimeShow(long afterTimeShow) {
            this.afterTimeShow = afterTimeShow;
        }

        public boolean isSupportTerminationSql() {
            return this.isSupportTerminationSql;
        }

        public void setSupportTerminationSql(boolean supportTerminationSql) {
            this.isSupportTerminationSql = supportTerminationSql;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        private static class ThreadDumpStat {
            private int total;
            private Map<String, Integer> subStatMap;

            private ThreadDumpStat() {
            }

            public int getTotal() {
                return this.total;
            }

            public void setTotal(int total) {
                this.total = total;
            }

            public Map<String, Integer> getSubStatMap() {
                return this.subStatMap;
            }

            public void setSubStatMap(Map<String, Integer> subStatMap) {
                this.subStatMap = subStatMap;
            }
        }
    }

    private static class ThreadDumpAllInfo {
        private List<ThreadDumpInfo> threadDumpInfoList;
        private Map<String, ThreadDumpInfo.ThreadDumpStat> threadDumpStatMap;
        private List<String> deadLockList = new ArrayList<String>();

        private ThreadDumpAllInfo() {
        }

        public Map<String, ThreadDumpInfo.ThreadDumpStat> getThreadDumpStatMap() {
            return this.threadDumpStatMap;
        }

        public void setThreadDumpStatMap(Map<String, ThreadDumpInfo.ThreadDumpStat> threadDumpStatMap) {
            this.threadDumpStatMap = threadDumpStatMap;
        }

        public List<ThreadDumpInfo> getThreadDumpInfoList() {
            return this.threadDumpInfoList;
        }

        public void setThreadDumpInfoList(List<ThreadDumpInfo> threadDumpInfoList) {
            this.threadDumpInfoList = threadDumpInfoList;
        }

        public List<String> getDeadLockList() {
            return this.deadLockList;
        }

        public void setDeadLockList(List<String> deadLockList) {
            this.deadLockList = deadLockList;
        }
    }
}

