/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.armor.Grocery;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.api.thread.ThreadInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadDumpOutHandler
implements HttpHandler {
    private static final String INSTANCE_ID = "instanceId";
    private static final String SUCCESS = "success";
    private static final String PARAMS = "params";
    private static final String TIME_STR = "/time:";
    private static final String TRACE_ID_STR = "/traceId:";
    private static final String HIDDEN_THREADS = System.getProperty("monitor.hidden.threads", "HistoricalDataClearService,ShardingMovingService,MsgJetSubscirbe,PKTempTableDBRegistryHeartbeatService,PKTempTableDBRegistryClearService");
    private static Set<String> excludeThreadNames = new HashSet<String>(6);
    private static String DEFAULT_MONITOR_THREAD = "RpcRequest,MQ-rabbit-pool,http-request";
    private static ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private static List<String> monitorThreadList = new ArrayList<String>();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Map<String, Object> response;
        JSONObject params = ExchangeVueUtils.parseJsonFromPost(exchange, JSONObject.class);
        if (params != null) {
            JSONObject auth = params.getJSONObject("auth");
            String userName = auth.getString("userName");
            String password = auth.getString("password");
            if (userName == null || password == null) {
                response = this.ofResponse(403, "Access denied. userName or password is null", Collections.emptyList());
            } else {
                boolean isAllow = EyeAuther.checkUser(userName, Encrypters.decode((String)password));
                if (isAllow) {
                    JSONArray retList = new JSONArray();
                    JSONObject param = params.getJSONObject(PARAMS);
                    String instanceId = param.getString(INSTANCE_ID);
                    if (StringUtils.isEmpty((String)instanceId)) {
                        response = this.getAllThreadDump(params);
                    } else if (Instance.getInstanceId().equals(instanceId)) {
                        HashMap<String, ThreadDumpAllInfo> instanceThreadInfo = new HashMap<String, ThreadDumpAllInfo>(1);
                        instanceThreadInfo.put(instanceId, this.getLocalNodeThreadDump(params));
                        retList.add(instanceThreadInfo);
                        response = this.ofResponse(200, SUCCESS, retList);
                    } else {
                        response = this.getSpecialThreadDump(params);
                    }
                } else {
                    response = this.ofResponse(403, "Access denied", Collections.EMPTY_LIST);
                }
            }
        } else {
            response = this.ofResponse(400, "Bad request, http post params is null", Collections.EMPTY_LIST);
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private Map<String, Object> getAllThreadDump(JSONObject params) {
        Map<String, Object> response;
        ArrayList retList = new ArrayList(16);
        try {
            String instanceId = Instance.getInstanceId();
            JSONObject clone = params.clone();
            JSONObject param = clone.getJSONObject(PARAMS);
            ArrayList<EyeNodeInfo> sortedNodeInfos = Grocery.getAllNodeInfo();
            for (EyeNodeInfo nodeInfo : sortedNodeInfos) {
                try {
                    HashMap<String, ThreadDumpAllInfo> instanceThreadInfo = new HashMap<String, ThreadDumpAllInfo>(1);
                    String instanceId1 = nodeInfo.getInstanceId();
                    if (instanceId.equals(instanceId1)) {
                        ThreadDumpAllInfo localNodeThreadDump = this.getLocalNodeThreadDump(params);
                        instanceThreadInfo.put(instanceId1, localNodeThreadDump);
                        retList.add(instanceThreadInfo);
                        continue;
                    }
                    param.put(INSTANCE_ID, (Object)instanceId1);
                    clone.put(PARAMS, (Object)param);
                    String data = Grocery.httpPost(nodeInfo.getIp(), Integer.parseInt(nodeInfo.getMonitorPort()), clone.toJSONString(), "monitor/eye/printThreadDump");
                    if (StringUtils.isEmpty((String)data)) {
                        instanceThreadInfo.put(instanceId1, null);
                        retList.add(instanceThreadInfo);
                        continue;
                    }
                    JSONObject parseObject = JSON.parseObject((String)data);
                    List array = (List)parseObject.getObject("data", List.class);
                    retList.addAll(array);
                }
                catch (Exception e) {}
            }
            response = this.ofResponse(200, SUCCESS, retList);
        }
        catch (Exception e) {
            response = this.ofResponse(500, "query all thread dump error,exception message: " + e.getMessage(), retList);
        }
        return response;
    }

    private EyeNodeInfo getEyeNodeInfo(List<EyeNodeInfo> sortedNodeInfos, String instanceId) {
        for (EyeNodeInfo nodeInfo : sortedNodeInfos) {
            if (!instanceId.equalsIgnoreCase(nodeInfo.getInstanceId())) continue;
            return nodeInfo;
        }
        return null;
    }

    private Map<String, Object> getSpecialThreadDump(JSONObject params) {
        Map<String, Object> response;
        JSONObject param = params.getJSONObject(PARAMS);
        String instanceId = param.getString(INSTANCE_ID);
        try {
            ArrayList<EyeNodeInfo> sortedNodeInfos = Grocery.getAllNodeInfo();
            EyeNodeInfo eyeNodeInfo = this.getEyeNodeInfo(sortedNodeInfos, instanceId);
            if (eyeNodeInfo == null) {
                response = this.ofResponse(404, "Instance not found,instanceId: " + instanceId, Collections.EMPTY_LIST);
            } else {
                String data = Grocery.httpPost(eyeNodeInfo.getIp(), Integer.parseInt(eyeNodeInfo.getMonitorPort()), params.toJSONString(), "monitor/eye/printThreadDump");
                JSONObject parseObject = JSON.parseObject((String)data);
                List array = (List)parseObject.getObject("data", List.class);
                response = this.ofResponse(200, SUCCESS, array);
            }
        }
        catch (Exception e) {
            response = this.ofResponse(500, "query all thread dump error,exception message: " + e.getMessage(), Collections.EMPTY_LIST);
        }
        return response;
    }

    private ThreadDumpAllInfo getLocalNodeThreadDump(JSONObject params) {
        JSONObject param = params.getJSONObject(PARAMS);
        String tlive = param.getString("live");
        int tlivesize = param.getIntValue("liveSize");
        String paramThreadName = param.getString("threadName");
        int livesize = 20;
        if (tlivesize != 0) {
            livesize = tlivesize;
        }
        boolean live = "true".equals(tlive) || "on".equals(tlive);
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<ThreadInfo> threads = this.getSortedThreadsInfo();
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>(16);
        HashMap<String, ThreadDumpInfo.ThreadDumpStat> stats = new HashMap<String, ThreadDumpInfo.ThreadDumpStat>(8);
        ThreadDumpAllInfo threadDumpAllInfo = new ThreadDumpAllInfo();
        threadDumpAllInfo.setThreadDumpInfoList(threadDumpInfoList);
        threadDumpAllInfo.setThreadDumpStatMap(stats);
        for (ThreadInfo t : threads) {
            String showThreadName;
            boolean isOutThread;
            StackTraceElement[] stes;
            ThreadDumpInfo threadDumpInfo = new ThreadDumpInfo();
            String threadName = t.getThreadName();
            threadDumpInfo.setThreadName(threadName);
            boolean find = false;
            for (String monitorThread : monitorThreadList) {
                if (t.getThread().getName().indexOf(monitorThread) < 0) continue;
                this.handleThreadStat(stats, t, monitorThread);
                find = true;
            }
            if (!find) {
                this.handleThreadStat(stats, t, "others");
            }
            if ((stes = t.getStackTraceElements()) == null || !(isOutThread = this.isOutPrintThread(t, paramThreadName, livesize, live))) continue;
            int pos = threadName.indexOf(TIME_STR);
            String traceId = null;
            if (pos > 0) {
                showThreadName = threadName.substring(0, pos);
                try {
                    long time = Long.parseLong(threadName.substring(pos + TIME_STR.length(), pos + 13 + TIME_STR.length()));
                    cal.setTimeInMillis(time);
                    threadDumpInfo.setStartTime(formatter.format(cal.getTime()));
                    threadDumpInfo.setDuration(String.valueOf(now - time));
                }
                catch (NumberFormatException e) {
                    showThreadName = threadName;
                }
                int traceIdPos = threadName.indexOf(TRACE_ID_STR);
                if (traceIdPos > 0) {
                    traceId = threadName.substring(traceIdPos + TRACE_ID_STR.length()).split("/")[0];
                }
            } else {
                showThreadName = threadName;
            }
            threadDumpInfo.setShowThreadName(showThreadName);
            if (traceId != null) {
                String url = "tc/traces/" + traceId;
                threadDumpInfo.setTraceUrl(url);
            }
            threadDumpInfo.setMemSpanInfoList(t.getMemSpanInfo());
            if (pos > 0 && t.getTraceStatisticList() != null) {
                threadDumpInfo.setThreadTraceStatList(t.getTraceStatisticList());
            }
            ArrayList<String> stackInfoList = new ArrayList<String>(16);
            for (StackTraceElement ste : stes) {
                stackInfoList.add(ste.toString());
            }
            threadDumpInfo.setStackTraceInfoList(stackInfoList);
            threadDumpInfoList.add(threadDumpInfo);
        }
        threadDumpAllInfo.setDeadLockList(this.getDeadLockInfo());
        return threadDumpAllInfo;
    }

    private ArrayList<ThreadInfo> getSortedThreadsInfo() {
        Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
        ArrayList<ThreadInfo> threads = new ArrayList<ThreadInfo>();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        m.forEach((t, stes) -> {
            ThreadInfo threadInfo = new ThreadInfo(t.getId(), t.getName(), (StackTraceElement[])stes, (Thread)t);
            List threadTraceStatList = TraceStatistics.getThreadTraceStatisticInfo((Thread)t);
            threadInfo.setTraceStatisticList(threadTraceStatList);
            threads.add(threadInfo);
            Map map = TracerImpl.getInstrumentMap((Thread)t);
            ArrayList<ThreadInfo.MemSpanInfo> memSpanInfoList = new ArrayList<ThreadInfo.MemSpanInfo>(4);
            threadInfo.setMemSpanInfo(memSpanInfoList);
            if (map != null) {
                map.forEach((k, v) -> {
                    cal.setTimeInMillis((long)v);
                    ThreadInfo.MemSpanInfo memSpanInfo = new ThreadInfo.MemSpanInfo();
                    memSpanInfo.setExecuteMethod(k.getType() + "." + k.getName());
                    memSpanInfo.setMethodDuration(String.valueOf(System.currentTimeMillis() - v));
                    memSpanInfo.setMethodStartTime(formatter.format(cal.getTime()));
                    ArrayList<KeyValueEntity> details = new ArrayList<KeyValueEntity>(4);
                    memSpanInfo.setDetails(details);
                    Map tags = k.tags();
                    if (tags != null) {
                        tags.forEach((tk, tv) -> {
                            if (!"service".equals(tk)) {
                                details.add(new KeyValueEntity((String)tk, tv));
                            }
                        });
                    }
                    memSpanInfoList.add(memSpanInfo);
                });
            }
        });
        return threads;
    }

    private boolean isOutPrintThread(ThreadInfo t, String threadname, int livesize, boolean live) {
        String _threadName = t.getThreadName();
        for (String exclude : excludeThreadNames) {
            if (!_threadName.contains(exclude)) continue;
            return false;
        }
        StackTraceElement[] stes = t.getStackTraceElements();
        if (stes.length > 0 && stes[0] != null && stes[0].toString().contains("Thread.dumpThreads")) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)threadname) && !_threadName.toLowerCase().contains(threadname.toLowerCase())) {
            return false;
        }
        if (_threadName.toLowerCase().contains("abandoned connection")) {
            return false;
        }
        for (StackTraceElement ste : stes) {
            String toString = ste.toString();
            if (!toString.contains("ProxyHandler")) continue;
            return false;
        }
        return !live || stes.length >= livesize;
    }

    private List<String> getDeadLockInfo() {
        long[] deadlockedThreads = mbean.findDeadlockedThreads();
        if (deadlockedThreads == null || deadlockedThreads.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(4);
        for (long pid : deadlockedThreads) {
            java.lang.management.ThreadInfo threadInfo = mbean.getThreadInfo(pid, Integer.MAX_VALUE);
            String s = threadInfo.toString();
            s = s.replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;").replaceAll("owned by", "owned by Thread ");
            list.add("Thread " + s);
        }
        return list;
    }

    private void handleThreadStat(Map<String, ThreadDumpInfo.ThreadDumpStat> stats, ThreadInfo t, String monitorThread) {
        if (t.getThread().getState() == Thread.State.WAITING) {
            this.fillStatMap(stats, monitorThread, "WAITING");
        } else if (t.getThread().getState() == Thread.State.RUNNABLE) {
            this.fillStatMap(stats, monitorThread, "RUNNABLE");
        } else if (t.getThread().getState() == Thread.State.BLOCKED) {
            this.fillStatMap(stats, monitorThread, "BLOCKED");
        } else if (t.getThread().getState() == Thread.State.TIMED_WAITING) {
            this.fillStatMap(stats, monitorThread, "TIMED_WAITING");
        }
    }

    private void fillStatMap(Map<String, ThreadDumpInfo.ThreadDumpStat> stats, String monitorThread, String flag) {
        ThreadDumpInfo.ThreadDumpStat threadDumpStat = stats.get(flag);
        if (threadDumpStat == null) {
            threadDumpStat = new ThreadDumpInfo.ThreadDumpStat();
            threadDumpStat.setTotal(1);
            stats.put(flag, threadDumpStat);
        } else {
            threadDumpStat.setTotal(threadDumpStat.getTotal() + 1);
        }
        Map<String, Integer> subStatMap = threadDumpStat.getSubStatMap();
        if (subStatMap == null) {
            subStatMap = new HashMap<String, Integer>();
            threadDumpStat.setSubStatMap(subStatMap);
        }
        subStatMap.merge(monitorThread, 1, Integer::sum);
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private Map<String, Object> ofResponse(int code, String msg, Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("code", code);
        map.put("msg", msg);
        map.put("data", data);
        return map;
    }

    static {
        String monitorThread = System.getProperty("monitor_threads", DEFAULT_MONITOR_THREAD);
        String[] threads = monitorThread.split(",");
        monitorThreadList.addAll(Arrays.asList(threads));
        String[] split = HIDDEN_THREADS.split(",");
        excludeThreadNames.add("eye-http");
        for (String threadName : split) {
            excludeThreadNames.add(threadName);
        }
    }

    private static class ThreadDumpInfo {
        private String threadName;
        private String showThreadName;
        private String startTime;
        private String duration;
        private List<String> stackTraceInfoList;
        private String traceUrl;
        private List<TraceStatistics.ThreadTraceStat> threadTraceStatList;
        private List<ThreadInfo.MemSpanInfo> memSpanInfoList;

        private ThreadDumpInfo() {
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public String getTraceUrl() {
            return this.traceUrl;
        }

        public void setTraceUrl(String traceUrl) {
            this.traceUrl = traceUrl;
        }

        public List<String> getStackTraceInfoList() {
            return this.stackTraceInfoList;
        }

        public void setStackTraceInfoList(List<String> stackTraceInfoList) {
            this.stackTraceInfoList = stackTraceInfoList;
        }

        public List<ThreadInfo.MemSpanInfo> getMemSpanInfoList() {
            return this.memSpanInfoList;
        }

        public void setMemSpanInfoList(List<ThreadInfo.MemSpanInfo> memSpanInfoList) {
            this.memSpanInfoList = memSpanInfoList;
        }

        public List<TraceStatistics.ThreadTraceStat> getThreadTraceStatList() {
            return this.threadTraceStatList;
        }

        public void setThreadTraceStatList(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
            this.threadTraceStatList = threadTraceStatList;
        }

        public String getShowThreadName() {
            return this.showThreadName;
        }

        public void setShowThreadName(String showThreadName) {
            this.showThreadName = showThreadName;
        }

        private static class ThreadDumpStat {
            private int total;
            private Map<String, Integer> subStatMap;

            private ThreadDumpStat() {
            }

            public int getTotal() {
                return this.total;
            }

            public void setTotal(int total) {
                this.total = total;
            }

            public Map<String, Integer> getSubStatMap() {
                return this.subStatMap;
            }

            public void setSubStatMap(Map<String, Integer> subStatMap) {
                this.subStatMap = subStatMap;
            }
        }
    }

    private static class ThreadDumpAllInfo {
        private List<ThreadDumpInfo> threadDumpInfoList;
        private Map<String, ThreadDumpInfo.ThreadDumpStat> threadDumpStatMap;
        private List<String> deadLockList = new ArrayList<String>();

        private ThreadDumpAllInfo() {
        }

        public Map<String, ThreadDumpInfo.ThreadDumpStat> getThreadDumpStatMap() {
            return this.threadDumpStatMap;
        }

        public void setThreadDumpStatMap(Map<String, ThreadDumpInfo.ThreadDumpStat> threadDumpStatMap) {
            this.threadDumpStatMap = threadDumpStatMap;
        }

        public List<ThreadDumpInfo> getThreadDumpInfoList() {
            return this.threadDumpInfoList;
        }

        public void setThreadDumpInfoList(List<ThreadDumpInfo> threadDumpInfoList) {
            this.threadDumpInfoList = threadDumpInfoList;
        }

        public List<String> getDeadLockList() {
            return this.deadLockList;
        }

        public void setDeadLockList(List<String> deadLockList) {
            this.deadLockList = deadLockList;
        }
    }
}

