/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumpUtil.class);
    private static final Map<String, Boolean> accountIdIsSupportDbTypeMap = new ConcurrentHashMap<String, Boolean>(1);

    public static boolean isSupportTerminationSql(RequestContext requestContext) {
        if (StringUtils.isNotEmpty((String)requestContext.getTenantId()) && StringUtils.isNotEmpty((String)requestContext.getAccountId())) {
            return accountIdIsSupportDbTypeMap.computeIfAbsent(requestContext.getTenantId() + requestContext.getAccountId(), key -> {
                try {
                    List dbConfigs = DBConfig.loadFromDataCenter((String)requestContext.getTenantId(), (String)"sys", (String)requestContext.getAccountId(), (boolean)true);
                    if (dbConfigs.isEmpty()) {
                        return false;
                    }
                    List supportedDbTypes = CancelTaskManager.get().getSupportedDbTypes();
                    if (supportedDbTypes == null || supportedDbTypes.size() == 0) {
                        log.info("\u652f\u6301\u7ec8\u6b62sql\u64cd\u4f5c\u7684\u6570\u636e\u5e93\u5217\u8868\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u53c2\u6570ksql.timeout.cancel.enable\u662f\u5426\u8bbe\u7f6e\u4e3atrue");
                        return false;
                    }
                    DBConfig dbConfig = (DBConfig)dbConfigs.get(0);
                    DBType dbType = dbConfig.getDBType();
                    if (supportedDbTypes.contains(dbType.getValue())) {
                        log.info("TenantId: {}, AccountId: {} ,\u7ebf\u7a0b\u5806\u6808\u83b7\u53d6\u5230\u7684sys\u5e93\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a{},dbTypeValue\u503c\u4e3a\uff1a {},\u652f\u6301\u7ec8\u6b62sql\u64cd\u4f5c", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), dbType.name(), dbType.getValue()});
                        return true;
                    }
                    log.info("TenantId: {}, AccountId: {} ,\u7ebf\u7a0b\u5806\u6808\u83b7\u53d6\u5230\u7684sys\u5e93\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a{},dbTypeValue\u503c\u4e3a\uff1a {},\u4e0d\u652f\u6301\u7ec8\u6b62sql\u64cd\u4f5c", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), dbType.name(), dbType.getValue()});
                    return false;
                }
                catch (Exception e) {
                    log.error("TenantId: " + requestContext.getTenantId() + ", AccountId: " + requestContext.getTenantId() + " ,\u7ebf\u7a0b\u5806\u6808\u83b7\u53d6sys\u5e93\u7684\u6570\u636e\u5e93\u7c7b\u578b\u9519\u8bef", (Throwable)e);
                    return false;
                }
            });
        }
        return false;
    }
}

