/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread.timeout;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.Resources;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.thread.timeout.ThreadTimeoutInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.govern.eventdata.EventData;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.TerminationEvent;
import kd.bos.govern.timeout.ThreadTimeoutManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadTimeoutHandler
extends AbstractHttpHandler {
    private static final String PROXY_PROTOCOL = "http://";
    private static final String REMOTE_THREAD_TIMEOUT_URL = "/monitor/eye/threadTimeoutHandler";
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final Log log = LogFactory.getLog(ThreadTimeoutHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            ThreadTimeoutInfo threadTimeoutInfo = ExchangeVueUtils.parseJsonFromPost(exchange, ThreadTimeoutInfo.class);
            if (StringUtils.isNotEmpty((String)threadTimeoutInfo.getTerminateTraceId())) {
                this.resetMonitorRequestContext(threadTimeoutInfo.getTerminateTraceId());
            } else {
                threadTimeoutInfo.setTerminateTraceId(RequestContext.get().getTraceId());
            }
            String description = Resources.get((String)"bos-eye", (String)"ThreadTimeoutHandler_1", (String)"\u8d85\u65f6\u670d\u52a1ip\u4e3a\uff1a%1$s ,\u7ebf\u7a0b\u540d\u4e3a\uff1a%2$s ,\u5df2\u6267\u884c: %3$s ms,\u6267\u884c\u65b9\u6cd5\u4e3a: %4$s ", (Object[])new Object[]{threadTimeoutInfo.getIp(), threadTimeoutInfo.getThreadName(), threadTimeoutInfo.getDuration(), threadTimeoutInfo.getMethod()});
            if (threadTimeoutInfo.isRecordOplog()) {
                OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"ThreadTimeoutHandler_0", (String)"\u624b\u52a8\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c\u63a5\u53e3", (Object[])new Object[0]), LangRes.get((String)"ThreadTimeoutHandler_2", (String)"\u88ab\u7ec8\u6b62\u670d\u52a1ip\u4e3a\uff1a{0} ,\u7ebf\u7a0b\u540d\u4e3a\uff1a{1} ,\u5df2\u6267\u884c: {2} ms,\u6267\u884c\u8be6\u7ec6\u4e3a: {3}", (Object[])new Object[]{threadTimeoutInfo.getIp(), threadTimeoutInfo.getThreadName(), threadTimeoutInfo.getDuration(), threadTimeoutInfo.getMethod()}));
                Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
                EventDataReporter.report((EventData)new EventData((EventType)TerminationEvent.WebManualTimeoutEvent.getInstance(), description).setTraceId(threadTimeoutInfo.getTerminateTraceId()).setUserName(userInfo != null ? userInfo.get("user") : null));
                threadTimeoutInfo.setRecordOplog(false);
            }
            if (MonitorConfig.getMonitorIp().equals(threadTimeoutInfo.getIp())) {
                this.terminateHandle(threadTimeoutInfo);
                log.info("\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c\u6210\u529f: " + description);
            } else {
                log.info("\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c-\u5f53\u524d\u8282\u70b9\u53d1\u8d77\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1ip {} \u8fdb\u884c\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c", (Object)threadTimeoutInfo.getIp());
                this.remoteTimeoutHandle(threadTimeoutInfo);
            }
            response.put("code", 0);
            response.put("msg", "success");
        }
        catch (Exception e) {
            log.error((Throwable)e);
            response.put("code", -1);
            response.put("msg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void terminateHandle(ThreadTimeoutInfo threadTimeoutInfo) {
        switch (threadTimeoutInfo.getType()) {
            case "sql": {
                this.terminateSql(threadTimeoutInfo);
                break;
            }
            default: {
                this.terminateRequest(threadTimeoutInfo);
            }
        }
    }

    private void terminateSql(ThreadTimeoutInfo timeoutForm) {
        ThreadTimeoutManager.terminateSql((EventType)TerminationEvent.SqlManualTimeoutEvent.getInstance(), (String)timeoutForm.getTraceId(), (long)timeoutForm.getThreadId(), (String)timeoutForm.getThreadName());
    }

    private void terminateRequest(ThreadTimeoutInfo timeoutForm) {
        ThreadTimeoutManager.terminateRequest((EventType)TerminationEvent.WebManualTimeoutEvent.getInstance(), (String)timeoutForm.getTraceId(), (long)timeoutForm.getThreadId(), (String)timeoutForm.getThreadName());
    }

    private void remoteTimeoutHandle(ThreadTimeoutInfo timeoutForm) throws IOException {
        String ip = timeoutForm.getIp();
        String remoteUrl = PROXY_PROTOCOL + ip + ":" + timeoutForm.getMonitorPort() + REMOTE_THREAD_TIMEOUT_URL;
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
        String param = JSONUtils.toString((Object)timeoutForm);
        String jsonResult = EyeHttpClients.postjson(remoteUrl, proxyHeader, param, 5000, 10000);
        JSONObject jsonObject = JSON.parseObject((String)jsonResult);
        if (!"0".equals(String.valueOf(jsonObject.get((Object)"code")))) {
            log.warn("\u8d85\u65f6\u5904\u7406-\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1: {} \u8fdb\u884c\u8d85\u65f6\u5904\u7406\u5931\u8d25,the reason is : {}", (Object)ip, (Object)jsonResult);
        }
    }
}

