/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread.timeout.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.eye.api.thread.timeout.ThreadTimeoutInfo;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.govern.eventdata.EventData;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.timeout.ThreadTimeoutManager;
import kd.bos.govern.timeout.ThreadTimeoutService;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class EyeThreadTimeoutService
implements ThreadTimeoutService {
    private static final Log log = LogFactory.getLog(EyeThreadTimeoutService.class);
    private static final String PROXY_PROTOCOL = "http://";
    private static final String REMOTE_THREAD_TIMEOUT_SERVICE_URL = "/monitor/eye/threadTimeoutService";

    public void terminateRequest(EventType eventType, String traceId, long threadId, String threadName) {
        Thread thread = ThreadTimeoutManager.getThreadByName((String)threadName);
        if (thread == null) {
            log.warn("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c-\u88ab\u7ec8\u6b62\u7ebf\u7a0b {} \u5df2\u4e0d\u5b58\u5728", (Object)threadName);
            return;
        }
        RequestTimeoutContext requestTimeoutContext = (RequestTimeoutContext)ThreadTimeoutManager.getObject((Thread)thread, (String)"th", RequestTimeoutContext.class);
        if (requestTimeoutContext == null) {
            log.warn("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c-\u88ab\u7ec8\u6b62\u7ebf\u7a0b {} \u65e0\u8bf7\u6c42\u4e0a\u4e0b\u6587", (Object)threadName);
            return;
        }
        String info = String.format("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c-\u5f00\u59cb\u7ec8\u6b62\u7ebf\u7a0b %s \u7684\u8bf7\u6c42", thread.getName());
        log.info(info);
        EventDataReporter.report((EventData)new EventData(eventType, info));
        requestTimeoutContext.setTimeoutByManually(true);
        this.terminateSql(eventType, traceId, threadId, threadName);
        String nextServerIp = requestTimeoutContext.getNextServerIp();
        if (StringUtils.isEmpty((String)nextServerIp)) {
            return;
        }
        this.remoteTerminateRequest(traceId, nextServerIp);
    }

    public void terminateSql(EventType eventType, String traceId, long threadId, String threadName) {
        CancelTaskManager cancelTaskManager = CancelTaskManager.get();
        cancelTaskManager.killCancelTask(threadId, traceId);
    }

    private void remoteTerminateRequest(String traceId, String nextServerIp) {
        ServiceInfo serviceInfo = ServiceInfoFactory.get().getServiceInfoByIp(nextServerIp);
        String port = serviceInfo != null ? serviceInfo.getMonitorPort() : MonitorConfig.getMonitorPort();
        String remoteUrl = PROXY_PROTOCOL + nextServerIp + ":" + port + REMOTE_THREAD_TIMEOUT_SERVICE_URL;
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
        ThreadTimeoutInfo timeoutForm = new ThreadTimeoutInfo();
        timeoutForm.setTraceId(traceId);
        timeoutForm.setTerminateTraceId(RequestContext.get().getTraceId());
        String jsonResult = null;
        try {
            String param = JSONUtils.toString((Object)timeoutForm);
            log.info("\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c-\u5f00\u59cb\u53d1\u8d77\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1ip {} \u8fdb\u884c\u7ec8\u6b62\u7ebf\u7a0b\u64cd\u4f5c", (Object)nextServerIp);
            jsonResult = EyeHttpClients.postjson(remoteUrl, proxyHeader, param, 5000, 10000);
        }
        catch (IOException e) {
            log.warn("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c: \u8fdc\u7a0b\u8c03\u7528\u670d\u52a1ip " + nextServerIp + " \u8fdb\u884c\u7ec8\u6b62\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = JSON.parseObject((String)jsonResult);
        if (!"0".equals(String.valueOf(jsonObject.get((Object)"code")))) {
            log.warn("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c: \u8fdc\u7a0b\u8c03\u7528\u670d\u52a1ip {} \u8fdb\u884c\u7ec8\u6b62\u8bf7\u6c42\u8c03\u7528\u5931\u8d25,the reason is : {}", (Object)nextServerIp, (Object)jsonResult);
        }
    }
}

