/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.thread.timeout.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.thread.timeout.ThreadTimeoutInfo;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.TerminationEvent;
import kd.bos.govern.timeout.ThreadTimeoutManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadTimeoutServiceHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(ThreadTimeoutServiceHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String traceId;
            Thread thread;
            ThreadTimeoutInfo threadTimeoutInfo = ExchangeVueUtils.parseJsonFromPost(exchange, ThreadTimeoutInfo.class);
            if (StringUtils.isNotEmpty((String)threadTimeoutInfo.getTerminateTraceId())) {
                this.resetMonitorRequestContext(threadTimeoutInfo.getTerminateTraceId());
            }
            if ((thread = ThreadTimeoutManager.getThreadByTraceId((String)(traceId = threadTimeoutInfo.getTraceId()), (String)"RpcRequest")) == null) {
                log.warn("\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c-\u901a\u8fc7traceId: {} \u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684rpc\u6267\u884c\u7ebf\u7a0b", (Object)traceId);
                throw new KDException(BosErrorCode.bOS, new Object[]{"\u7ec8\u6b62\u8bf7\u6c42\u64cd\u4f5c-\u901a\u8fc7traceId: { + " + traceId + " } \u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684rpc\u6267\u884c\u7ebf\u7a0b"});
            }
            ThreadTimeoutManager.terminateRequest((EventType)TerminationEvent.WebManualTimeoutEvent.getInstance(), (String)traceId, (long)thread.getId(), (String)thread.getName());
            response.put("code", 0);
            response.put("msg", "success");
        }
        catch (Exception e) {
            log.error((Throwable)e);
            response.put("code", -1);
            response.put("msg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

