/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.threadpool;

import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;
import kd.bos.util.StringUtils;

public class ThreadPoolInfoHook
implements UnifiedConfigHookService {
    public static final String KEY_PRIORITY_THREAD_POOL_THREAD_MAX_THRESHOLD = "priority.threadpool.maxsize.max";
    public static final String KEY_PRIORITY_THREAD_POOL_THREAD_OVERFLOW_THRESHOLD = "priority.threadpool.overflow.max";
    public static final String PRIORITY_THREAD_POOL_THREAD_OVERFLOW_THRESHOLD_DEFAULT = "50";
    public static final String KEY_PRIORITY_THREAD_POOL_THREAD_TASKTYPE_QUEUE_MAX_THRESHOLD = "priority.threadpool.tasktype.queuesize.max";
    public static final String PRIORITY_THREAD_POOL_THREAD_TASKTYPE_QUEUE_MAX_THRESHOLD_DEFAULT = "1000";
    public static final String msg_tip_max_thread_number = "\u8bf7\u8f93\u5165\u5927\u4e8e\u7b49\u4e8e1\u4e14\u5c0f\u4e8e\u7b49\u4e8e5000\u7684\u6b63\u786e\u6570\u5b57";
    public static final String KEY_THRESHOLD_CONFIG_THRESHOLD_HOOK = "topoAnalysisThresholdHook";

    public static void registerHook() {
        ThreadPoolInfoHook hook = new ThreadPoolInfoHook();
        UnifiedConfigManager.registHookService(ConfigModule.P_THREAD_POOL_CONFIG.getNumber(), KEY_PRIORITY_THREAD_POOL_THREAD_OVERFLOW_THRESHOLD, hook);
        UnifiedConfigManager.registHookService(ConfigModule.P_THREAD_POOL_CONFIG.getNumber(), KEY_PRIORITY_THREAD_POOL_THREAD_MAX_THRESHOLD, hook);
        UnifiedConfigManager.registHookService(ConfigModule.P_THREAD_POOL_CONFIG.getNumber(), KEY_PRIORITY_THREAD_POOL_THREAD_TASKTYPE_QUEUE_MAX_THRESHOLD, hook);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String beforeSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
        String value = configParam.getValue();
        int cfgNormalValue = 0;
        if (key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_MAX_THRESHOLD)) {
            if (!StringUtils.isNumericString((String)value)) return "\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e5000\u7684\u6b63\u786e\u6570\u5b57";
            cfgNormalValue = Integer.parseInt(value);
            if (cfgNormalValue >= 1 && cfgNormalValue <= 5000) return "";
            return msg_tip_max_thread_number;
        }
        if (key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_OVERFLOW_THRESHOLD)) {
            if (!StringUtils.isNumericString((String)value)) return "\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e500\u7684\u6b63\u786e\u6570\u5b57";
            cfgNormalValue = Integer.parseInt(value);
            if (cfgNormalValue >= 0 && cfgNormalValue <= 500) return "";
            return "\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e500\u7684\u6b63\u786e\u6570\u5b57";
        }
        if (!key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_TASKTYPE_QUEUE_MAX_THRESHOLD)) return "";
        if (!StringUtils.isNumericString((String)value)) return "\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e10000\u7684\u6b63\u786e\u6570\u5b57";
        cfgNormalValue = Integer.parseInt(value);
        if (cfgNormalValue >= 0 && cfgNormalValue <= 10000) return "";
        return "\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e10000\u7684\u6b63\u786e\u6570\u5b57";
    }

    @Override
    public void afterSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
        String value = configParam.getValue();
        if (key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_MAX_THRESHOLD)) {
            ThreadPoolStrategyImpl.THREAD_MAX_THRESHOLD = Integer.parseInt(value);
        } else if (key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_OVERFLOW_THRESHOLD)) {
            ThreadPoolStrategyImpl.THREAD_OVERFLOW_THRESHOLD = Integer.parseInt(value);
        } else if (key.equals(KEY_PRIORITY_THREAD_POOL_THREAD_TASKTYPE_QUEUE_MAX_THRESHOLD)) {
            ThreadPoolStrategyImpl.THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD = Integer.parseInt(value);
        }
    }
}

