/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.threadpool;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.threadpool.ThreadPoolQueryForm;
import kd.bos.eye.config.EyeConfig;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.util.HttpClients;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.unifiedthreadpool.helper.vo.ThreadPoolInfo;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ThreadPoolInfoProxyHandler
extends AbstractHttpHandler {
    private static Log logger = LogFactory.getLog(ThreadPoolInfoProxyHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String REQUEST_PATH = "/monitor/eye/threadpool/getThreadPool";
    private static final int READ_TIME_OUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<JSONObject> response = new ApiResponse<JSONObject>();
        JSONObject result = new JSONObject();
        String msg = "success";
        List<Object> retList = new ArrayList(10);
        int code = 0;
        try {
            ThreadPoolQueryForm queryForm = ExchangeVueUtils.parseJsonFromPost(exchange, ThreadPoolQueryForm.class);
            List<EyeNodeInfo> list = EyeConfig.getSortedNodeList();
            ArrayList tempList = new ArrayList(10);
            for (EyeNodeInfo nodeInfo : list) {
                if (nodeInfo.isGateWay() || !nodeInfo.getHostIp().contains(queryForm.getIpPort()) || StringUtils.isNotEmpty((String)queryForm.getAppName()) && !nodeInfo.getAppName().toLowerCase().contains(queryForm.getAppName().toLowerCase())) continue;
                String reqPath = nodeInfo.getMonitorUrl(false) + REQUEST_PATH;
                HashMap<String, String> proxyHeader = new HashMap<String, String>();
                proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
                try {
                    String str = HttpClients.get((String)reqPath, proxyHeader, (int)100, (int)(READ_TIME_OUT * 100));
                    tempList.addAll((Collection)JSONUtils.cast((String)str, List.class, (Class[])new Class[]{ThreadPoolInfo.class}));
                }
                catch (Exception e) {
                    logger.error("cannot get ThreadPoolInfo from " + nodeInfo.getHostIp() + "," + e);
                }
            }
            ArrayList filterList = new ArrayList(10);
            tempList.forEach(threadPoolInfo -> {
                if (StringUtil.isEmpty((String)queryForm.getThreadPoolName()) || threadPoolInfo.getPoolName().toLowerCase().contains(queryForm.getThreadPoolName().toLowerCase())) {
                    filterList.add(threadPoolInfo);
                }
            });
            retList = filterList.stream().filter(s -> StringUtil.isEmpty((String)queryForm.getRegion()) || s.getCloudId().toLowerCase().contains(queryForm.getRegion().toLowerCase())).collect(Collectors.toList());
            result.put("maxSize", (Object)ConfigDbHelper.getValueByKey("priority.threadpool.maxsize.max", String.valueOf(ThreadPoolStrategyImpl.THREAD_MAX_THRESHOLD)));
            result.put("overflowMaxSize", (Object)ConfigDbHelper.getValueByKey("priority.threadpool.overflow.max", String.valueOf(ThreadPoolStrategyImpl.THREAD_OVERFLOW_THRESHOLD)));
            result.put("queueMaxSize", (Object)ConfigDbHelper.getValueByKey("priority.threadpool.tasktype.queuesize.max", String.valueOf(ThreadPoolStrategyImpl.THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD)));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            StringBuilder stringBuilder = new StringBuilder(LangRes.get((String)"NewThreadDumpHandler_18", (String)"Error Querying Thread Pool", (Object[])new Object[0]));
            stringBuilder.append("[").append(e.getMessage()).append("]");
            msg = stringBuilder.toString();
            code = -1;
        }
        result.put("pools", retList);
        response.setCode(code);
        response.setMsg(msg);
        response.setData(result);
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

