/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.top;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;

public class TopUtils {
    private static final Log log = LogFactory.getLog(TopUtils.class);
    private static final String COMMAND_CPU_NUM = "lscpu";
    private static final String LOAD_AVERAGE_FLAG = "load average:";

    public static String getCpuNumInfo() {
        String num = "0";
        try {
            Process ps = Runtime.getRuntime().exec(COMMAND_CPU_NUM);
            try (InputStream inputStream = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 LineNumberReader br = new LineNumberReader(isr);){
                String line;
                HashMap hashMap = new HashMap(8);
                boolean index = true;
                while ((line = br.readLine()) != null) {
                    if (!StringUtils.isNotEmpty((String)line) || !line.contains("CPU(s)")) continue;
                    num = line.split(":")[1].trim();
                    break;
                }
            }
            catch (Exception e) {
                log.error("Top get cpu number error:{}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Top get cpu number run ls cpu error:{}", (Object)e.getMessage());
        }
        return "CPU(s)\uff1a" + num;
    }

    public static String getAvgLoadInfo(String info) {
        StringBuilder cpuInfo = new StringBuilder(LangRes.get((String)"TopCpuAvgLoad", (String)"CPU Average Load (1 minute, 5 minutes, 15 minutes):", (Object[])new Object[0]));
        cpuInfo.append(info.substring(info.lastIndexOf(LOAD_AVERAGE_FLAG) + 13));
        return cpuInfo.toString();
    }

    public static String getCPUUsageInfo(String info) {
        StringBuilder cpuInfo = new StringBuilder(LangRes.get((String)"TopUSRate", (String)"User Space CPU:", (Object[])new Object[0]));
        cpuInfo.append(info.substring(8, info.lastIndexOf("us,")).trim()).append("%|");
        cpuInfo.append(LangRes.get((String)"TopCpuIdeRate", (String)"Idle CPU:", (Object[])new Object[0]));
        cpuInfo.append(info.substring(info.lastIndexOf("ni,") + 3, info.lastIndexOf("id,")).trim()).append("%|");
        cpuInfo.append(LangRes.get((String)"TopIOWaitCpuRate", (String)"IO Wait CPU:", (Object[])new Object[0]));
        cpuInfo.append(info.substring(info.lastIndexOf("id,") + 3, info.lastIndexOf("wa,")).trim()).append("%");
        return cpuInfo.toString();
    }
}

