/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.eye.api.metric.MetricApiHandler;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUrlUtils;

public class TraceHandler
extends AbstractHttpHandler {
    private final String path;

    public TraceHandler(String path) {
        this.path = path;
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        String baseUrl = EyeUrlUtils.getHomeUrl(exchange, "tc");
        if (baseUrl.toLowerCase().startsWith("http")) {
            baseUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
            baseUrl = baseUrl.substring(baseUrl.indexOf(47));
        } else {
            int pos = baseUrl.indexOf("/traces");
            if (pos > 0) {
                baseUrl = baseUrl.substring(0, pos + 1);
            }
        }
        try (InputStream in = MetricApiHandler.class.getResourceAsStream(this.path + "/trace.html");
             OutputStream os = exchange.getResponseBody();){
            byte[] response = this.readBytes(in);
            response = this.replaceIndex(response, baseUrl);
            exchange.sendResponseHeaders(202, response.length);
            os.write(response);
            exchange.close();
        }
    }

    private byte[] replaceIndex(byte[] response, String baseUrl) throws UnsupportedEncodingException {
        String text = new String(response, "UTF-8");
        text = text.replace("{baseUrl}", baseUrl);
        return text.getBytes("UTF-8");
    }

    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

