/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.unifiedmetrics.entity.FunctionDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.GraphDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.MetricDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.MetricsTag;
import kd.bos.eye.api.unifiedmetrics.entity.UnitDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.UnitEntity;
import kd.bos.eye.api.unifiedmetrics.helper.JsonFileParser;
import kd.bos.util.JSONUtils;

public class DictionaryParseHelper {
    private static final String FUNCTION_TEMPLATE_PATH = "unifiedmetrics/FunctionDictionary.json";
    private static final String GRAPH_DICTIONARY_PATH = "unifiedmetrics/GraphDictionary.json";
    private static final String METRIC_DICTIONARY_PATH = "unifiedmetrics/MetricDictionary.json";
    private static final String UNIT_DICTIONARY_PATH = "unifiedmetrics/UnitDictionary.json";
    private static final String METRICS_TAG_PATH = "unifiedmetrics/MetricsTag.json";
    private static Map<String, UnitEntity> unitMap;

    public static UnitEntity getUnitEntity(String unitName) throws IOException {
        if (unitMap == null) {
            unitMap = new HashMap<String, UnitEntity>();
            List<UnitDictionary> units = DictionaryParseHelper.getUnitDictionary();
            for (UnitDictionary dictionary : units) {
                List<UnitEntity> entityList = dictionary.getUnits();
                entityList.forEach(u -> unitMap.put(u.getName(), (UnitEntity)u));
            }
        }
        return unitMap.get(unitName);
    }

    public static List<FunctionDictionary> getFunctionTemplate() throws IOException {
        return (List)JSONUtils.cast((String)JsonFileParser.parseDictionaryFile(FUNCTION_TEMPLATE_PATH), List.class, (Class[])new Class[]{FunctionDictionary.class});
    }

    public static List<GraphDictionary> getGraphDictionary() throws IOException {
        return (List)JSONUtils.cast((String)JsonFileParser.parseDictionaryFile(GRAPH_DICTIONARY_PATH), List.class, (Class[])new Class[]{GraphDictionary.class});
    }

    public static List<MetricDictionary> getMetricDictionary() throws IOException {
        return (List)JSONUtils.cast((String)JsonFileParser.parseDictionaryFile(METRIC_DICTIONARY_PATH), List.class, (Class[])new Class[]{MetricDictionary.class});
    }

    public static List<UnitDictionary> getUnitDictionary() throws IOException {
        return (List)JSONUtils.cast((String)JsonFileParser.parseDictionaryFile(UNIT_DICTIONARY_PATH), List.class, (Class[])new Class[]{UnitDictionary.class});
    }

    public static List<MetricsTag> getMetricsTag() throws IOException {
        return (List)JSONUtils.cast((String)JsonFileParser.parseDictionaryFile(METRICS_TAG_PATH), List.class, (Class[])new Class[]{MetricsTag.class});
    }
}

