/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.prometheus.dao;

import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.eye.api.sso.cosmiceye.CommonResponse;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.unifiedmetrics.helper.ValueTypeEnum;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromApiArgs;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromData;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromResponse;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromResult;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class PromApiQueryDao {
    private static final String URL_CONFIG_KEY = "monitor.prometheus.url";
    private static final String USER_CONFIG_KEY = "monitor.prometheus.username";
    private static final String PASS_CONFIG_KEY = "monitor.prometheus.password";
    private static final String QUERY_SINGLE_API = "/api/v1/query";
    private static final String QUERY_RANGE_API = "/api/v1/query_range";
    private static Log logger = LogFactory.getLog(PromApiQueryDao.class);

    public PromResponse querySingle(PromApiArgs args) {
        if (StringUtils.isNotEmpty((String)args.getInterval())) {
            String ql = args.getQuery();
            String regex = "(?<=\\[)(.*?)(?=\\])";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(ql);
            String replaced = matcher.replaceAll(args.getInterval());
            args.setQuery(replaced);
        }
        return this.query(args, ValueTypeEnum.SINGLE);
    }

    public PromResponse queryRange(PromApiArgs args) {
        if (StringUtils.isNotEmpty((String)args.getStep())) {
            String ql = args.getQuery();
            String regex = "(?<=\\[)(.*?)(?=\\])";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(ql);
            String replaced = matcher.replaceAll(args.getStep());
            String regex2 = "\\boffset\\s+\\d+[a-z]?";
            pattern = Pattern.compile(regex2);
            matcher = pattern.matcher(replaced);
            String offset = "offset " + args.getStep();
            replaced = matcher.replaceAll(offset);
            args.setQuery(replaced);
        }
        return this.query(args, ValueTypeEnum.RANGE);
    }

    private PromResponse query(PromApiArgs args, ValueTypeEnum valueType) {
        PromResponse response;
        String server = System.getProperty(URL_CONFIG_KEY);
        if (StringUtils.isEmpty((String)server)) {
            return this.queryRangeFromApi(args, valueType);
        }
        try {
            String username = System.getProperty(USER_CONFIG_KEY);
            String password = System.getProperty(PASS_CONFIG_KEY);
            HashMap<String, String> header = new HashMap<String, String>(2);
            if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                String authString = username + ":" + password;
                String encodedAuthString = "Basic " + Base64.getEncoder().encodeToString(authString.getBytes());
                header.put("Authorization", encodedAuthString);
            }
            String api = ValueTypeEnum.RANGE == valueType ? QUERY_RANGE_API : QUERY_SINGLE_API;
            String ecQl = URLEncoder.encode(args.getQuery(), "utf-8");
            args.setQuery(ecQl);
            String url = this.createUrl(server, api, args);
            String rep = EyeHttpClients.get(url, header, 3000, 5000);
            response = (PromResponse)JSONUtils.cast((String)rep, PromResponse.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            response = new PromResponse();
            response.setStatus("error");
            response.setErrorType("bad_query");
            response.setError(e.getMessage());
        }
        return response;
    }

    private PromResponse queryRangeFromApi(PromApiArgs args, ValueTypeEnum valueType) {
        PromResponse response = new PromResponse();
        HashMap<String, String> data = new HashMap<String, String>(6);
        data.put("query", args.getQuery());
        data.put("start", args.getStart());
        data.put("end", args.getEnd());
        data.put("step", args.getStep());
        try {
            CommonResponse commonResponse;
            CommonResponse commonResponse2 = commonResponse = ValueTypeEnum.RANGE == valueType ? CosmiceyeAuth.get().promqlQueryRange(args.getToken(), data) : CosmiceyeAuth.get().promqlQueryRaw(args.getToken(), data);
            if (commonResponse.getErrcode() != 0) {
                response.setStatus("error");
                response.setErrorType("bad_query");
                response.setError(commonResponse.getDescription());
                return response;
            }
            String json = JSONUtils.toString((Object)commonResponse.getData());
            List list = (List)JSONUtils.cast((String)json, List.class, (Class[])new Class[]{PromResult.class});
            PromData promData = new PromData();
            promData.setResult(list);
            response.setData(promData);
            response.setStatus("success");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            response.setStatus("error");
            response.setErrorType("bad_query");
            response.setError(e.getMessage());
        }
        return response;
    }

    private String createUrl(String server, String api, PromApiArgs args) {
        StringBuilder builder = new StringBuilder(server);
        builder.append(api);
        builder.append("?").append("query").append("=").append(args.getQuery());
        if (StringUtils.isNotEmpty((String)args.getTime())) {
            builder.append("&").append("time").append("=").append(args.getTime());
        }
        if (StringUtils.isNotEmpty((String)args.getStart())) {
            builder.append("&").append("start").append("=").append(args.getStart());
        }
        if (StringUtils.isNotEmpty((String)args.getEnd())) {
            builder.append("&").append("end").append("=").append(args.getEnd());
        }
        if (StringUtils.isNotEmpty((String)args.getStep())) {
            builder.append("&").append("step").append("=").append(args.getStep());
        }
        return builder.toString();
    }
}

