/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.unifiedmetrics.prometheus.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.unifiedmetrics.MetricMetaReader;
import kd.bos.eye.api.unifiedmetrics.entity.MetricDictionary;
import kd.bos.eye.api.unifiedmetrics.entity.MetricsTag;
import kd.bos.eye.api.unifiedmetrics.entity.SpecificSourceMetrics;
import kd.bos.eye.api.unifiedmetrics.entity.UnifiedMetrics;
import kd.bos.eye.api.unifiedmetrics.entity.UnitEntity;
import kd.bos.eye.api.unifiedmetrics.helper.DictionaryParseHelper;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromItem;
import kd.bos.eye.api.unifiedmetrics.prometheus.pojo.PromMetricDictionary;
import kd.bos.eye.api.unifiedmetrics.prometheus.service.PromJsonParseHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class PromMetricMetaReader
implements MetricMetaReader {
    private static Log logger = LogFactory.getLog(PromMetricMetaReader.class);

    @Override
    public List<UnifiedMetrics> provide() {
        ArrayList<UnifiedMetrics> ret = new ArrayList<UnifiedMetrics>(8);
        try {
            List<MetricsTag> tags = DictionaryParseHelper.getMetricsTag();
            List<MetricDictionary> commonMetrics = DictionaryParseHelper.getMetricDictionary();
            PromMetricDictionary promMetrics = PromJsonParseHelper.getPromMetricDictionary();
            List<MetricDictionary> customMetrics = promMetrics.getCustomMetrics();
            List<PromItem> promItems = promMetrics.getCommonMetrics();
            Map<String, String> itemMapping = promItems.stream().collect(Collectors.toMap(PromItem::getKey, PromItem::getItem));
            commonMetrics = commonMetrics.stream().filter(m -> !itemMapping.containsKey(m)).collect(Collectors.toList());
            commonMetrics.addAll(customMetrics);
            HashMap<String, List> tagGroup = new HashMap<String, List>();
            for (MetricDictionary dictionary : commonMetrics) {
                String key = dictionary.getItem();
                String itemName = itemMapping.containsKey(key) ? itemMapping.get(key) : key;
                SpecificSourceMetrics metrics = (SpecificSourceMetrics)JSONUtils.cast((String)JSONUtils.toString((Object)dictionary), SpecificSourceMetrics.class);
                metrics.setItem(itemName);
                UnitEntity entity = DictionaryParseHelper.getUnitEntity(metrics.getUnit());
                metrics.setTransformUnit(entity.getTransformUnit());
                List finalMetrics = tagGroup.computeIfAbsent(metrics.getTag(), k -> new ArrayList());
                finalMetrics.add(metrics);
            }
            for (MetricsTag tag : tags) {
                if (!tagGroup.containsKey(tag.getName())) continue;
                UnifiedMetrics um = new UnifiedMetrics();
                um.setName(tag.getName());
                um.setAlias(tag.getAlias());
                um.setMetrics((List)tagGroup.get(tag.getName()));
                ret.add(um);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return ret;
    }
}

