/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.xcache;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.Node;
import kd.bos.eye.api.xcache.XCacheNode;
import kd.bos.eye.api.xcache.XCacheRequest;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.redis.RedisProtocols;
import kd.bos.redis.analysis.AnalysisResult;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.wrapper.Wrapper;
import kd.bos.redis.xcache.XCacheClient;
import kd.bos.redis.xcache.XCacheJedisClientCreator;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import redis.clients.jedis.util.Slowlog;

public class XCacheMrgHandler
extends AbstractHttpHandler
implements Serializable {
    private static final Log LOG = LogFactory.getLog(XCacheMrgHandler.class);
    private static String DEFAULT_HIGHLIGHT_KEYS = "allocator_used_memory_human,allocator_out_of_memory,timer_eviction_cache";
    private static final String[] HIGH_LIGHT_KEYS = System.getProperty("monitor.redis.highlightkeys", DEFAULT_HIGHLIGHT_KEYS).split(",");

    private Set<String> getXCacheUrls() {
        try {
            Map<String, Pool0> poolmap = XCacheMrgHandler.getJedisPool0Map();
            return poolmap.keySet().stream().filter(RedisProtocols::isXCache).collect(Collectors.toSet());
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    private static Map<String, Pool0> getJedisPool0Map() throws NoSuchFieldException, IllegalAccessException {
        Field filed = RedisFactory.class.getDeclaredField("poolMap");
        filed.setAccessible(true);
        Map poolmap = (Map)filed.get(RedisFactory.class);
        return poolmap;
    }

    private List<XCacheNode> getXCacheNodes() {
        return this.getXCacheNodes(this.getXCacheUrls());
    }

    private List<XCacheNode> getXCacheNodes(Set<String> urls) {
        HashSet<String> mserviceNodes = new HashSet<String>();
        ArrayList<XCacheNode> result = new ArrayList<XCacheNode>();
        for (String url : urls) {
            String[] info = url.split(":");
            if ("xcache_mservice".equalsIgnoreCase(info[0])) {
                String group = info[1];
                String port = info[2];
                Elector elector = ElectFactory.getElector((String)("xcache_" + group));
                String master = elector.getMaster().getHost();
                Set hosts = elector.getNodes().stream().filter(n -> n.getHost() != null).map(Node::getHost).collect(Collectors.toSet());
                for (String host : hosts) {
                    XCacheNode xCacheNode = XCacheNode.createMServiceNode(url, String.format("%s:%s", host, port), host.equals(master));
                    result.add(xCacheNode);
                    mserviceNodes.add(xCacheNode.getNode());
                }
                continue;
            }
            result.add(XCacheNode.createHostingNode(url));
        }
        return result.stream().filter(n -> !"hosting".equalsIgnoreCase(n.getMode()) || !mserviceNodes.contains(n.getNode())).sorted((o1, o2) -> o1.isMaster() ? -1 : (o2.isMaster() ? 1 : o1.getNode().compareTo(o2.getNode()))).collect(Collectors.toList());
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        XCacheRequest params;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            params = (XCacheRequest)ExchangeVueUtils.parsePostJson(exchange, XCacheRequest.class);
        }
        catch (Exception e) {
            return;
        }
        List<XCacheNode> xcacheNodes = this.getXCacheNodes();
        HashMap nodeDataMap = new HashMap(8);
        ArrayList<XCacheNode> nodeDataList = new ArrayList<XCacheNode>(8);
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        if (!xcacheNodes.isEmpty()) {
            for (XCacheNode xCacheNode : xcacheNodes) {
                if (nodeDataMap.containsKey(xCacheNode.getNode())) continue;
                nodeDataList.add(xCacheNode);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
                nodeDataMap.put(xCacheNode.getNode(), dataMap);
                dataMap.put("node", xCacheNode);
                try (JedisClient client = XCacheMrgHandler.$getUnPooledHostingXCacheClient(xCacheNode.getNode());){
                    dataMap.put("runtimeList", this.getRuntimeList(client));
                    dataMap.put("slowList", this.getSlowList(client, dateFormat));
                    if (xCacheNode.isMatch(params.getNode())) {
                        this.tryToSendCommand(params.getKv(), client, response);
                        XCacheMrgHandler.tryToAnalysisBigKeys(params, client, response);
                    }
                }
                xCacheNode.setNode(XCacheMrgHandler.trimParameters(xCacheNode.getNode()));
            }
        }
        response.put("clusterName", Instance.getClusterName() == null ? " " : Instance.getClusterName());
        response.put("code", 0);
        response.put("nodeList", nodeDataList);
        response.put("nodeData", nodeDataMap);
        response.put("keys", HIGH_LIGHT_KEYS);
        response.put("xcacheEnabled", Boolean.parseBoolean(System.getProperty("xcache.client.enable")));
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private static String trimParameters(String url) {
        int index = url.indexOf(47);
        String substring = url;
        if (index != -1) {
            substring = url.substring(0, index);
        }
        return substring;
    }

    private static void tryToAnalysisBigKeys(XCacheRequest params, JedisClient client, Map<String, Object> response) {
        if (params.getBigKeyCount() > 0 && params.getBigKeySize() > 0) {
            XCacheClient xcacheClient = XCacheClient.newClient((JedisClient)client);
            AnalysisResult result = xcacheClient.analysis(params.getBigKeySize(), params.getBigKeyCount());
            response.put("bigKeyAnalysisResult", result);
        }
    }

    private List<Map<String, String>> getRuntimeList(JedisClient client) {
        ArrayList<Map<String, String>> runtimeList = new ArrayList<Map<String, String>>();
        List infos = null;
        try {
            infos = client.getRedisInfo();
        }
        catch (Exception e) {
            LOG.error("Error occurred when get xcache runtime list information", (Throwable)e);
        }
        if (infos != null) {
            for (Map info : infos) {
                Set set = info.entrySet();
                for (Map.Entry entry : set) {
                    HashMap<String, Object> runtimeMap = new HashMap<String, Object>(2);
                    runtimeMap.put("key", entry.getKey());
                    runtimeMap.put("value", entry.getValue());
                    runtimeList.add(runtimeMap);
                }
            }
        }
        return runtimeList;
    }

    private List<Map<String, Object>> getSlowList(JedisClient client, SimpleDateFormat dateFormat) {
        ArrayList<Map<String, Object>> slowList = new ArrayList<Map<String, Object>>();
        List logs = null;
        try {
            logs = client.getLogs(20L);
        }
        catch (Exception e) {
            LOG.error("Error occurred when get xcache showlog", (Throwable)e);
        }
        if (logs != null) {
            Collections.sort(logs, Comparator.comparing(Slowlog::getExecutionTime).reversed());
            for (Slowlog log : logs) {
                HashMap<String, Object> slowMap = new HashMap<String, Object>(3);
                slowMap.put("time", dateFormat.format(new Date(log.getTimeStamp() * 1000L)));
                slowMap.put("log", log.getArgs());
                slowMap.put("costTime", log.getExecutionTime() / 1000L);
                slowList.add(slowMap);
            }
        }
        return slowList;
    }

    private void tryToSendCommand(String kv, JedisClient client, Map<String, Object> response) {
        if (StringUtils.isNotEmpty((String)(kv = kv.trim()))) {
            String type;
            switch (type = client.type(kv)) {
                case "string": {
                    response.put("commandData", client.get(kv));
                    break;
                }
                case "hash": {
                    Map hgetAll = client.hgetAll(kv);
                    response.put("commandData", hgetAll.toString());
                    break;
                }
            }
        }
    }

    private static JedisClient $getUnPooledHostingXCacheClient(String url) {
        return Wrapper.wrap((Object)XCacheJedisClientCreator.create((String)url));
    }
}

