/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.auth;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.eye.auth.SessionStore;

public class DistributeSessionStore
extends SessionStore {
    private static final int TIMEOUT_SECONDS = Integer.getInteger("monitor.session.expire.time", 1800);
    private static final int COSMIC_EYE_TIMEOUT_SECONDS = Integer.getInteger("cosmiceye.session.expire.time", 7200);
    private static final String SESSION_KEY_PRE = "monitor-session-";
    private DistributeSessionableCache cache = CacheFactory.getCommonCacheFactory().$getDistributeSessionableCache();

    private String makeKey(String sessionId) {
        return SESSION_KEY_PRE + sessionId;
    }

    private int getTimeoutSeconds(String sessionId) {
        return sessionId.endsWith("$COSMICEYE") ? COSMIC_EYE_TIMEOUT_SECONDS : TIMEOUT_SECONDS;
    }

    @Override
    public void store(String sessionId, Map<String, String> sessionInfo) {
        this.cache.put(this.makeKey(sessionId), sessionInfo);
        this.cache.expireAfter(this.makeKey(sessionId), this.getTimeoutSeconds(sessionId));
    }

    @Override
    public void expireAfter(String sessionId) {
        this.cache.expireAfter(this.makeKey(sessionId), this.getTimeoutSeconds(sessionId));
    }

    @Override
    public boolean exists(String sessionId) {
        Map all = this.cache.getAll(this.makeKey(sessionId));
        return all != null && !all.isEmpty();
    }

    @Override
    public Map<String, String> get(String sessionId) {
        return this.cache.getAll(this.makeKey(sessionId));
    }

    @Override
    public void remove(String sessionId) {
        this.cache.remove(this.makeKey(sessionId));
    }

    @Override
    public DistributeSessionableCache getCache() {
        return this.cache;
    }
}

