/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.auth;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.permission.dao.RoleDao;
import kd.bos.eye.api.permission.dao.UserDao;
import kd.bos.eye.api.permission.entity.Role;
import kd.bos.eye.api.permission.entity.User;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.RequestTypeEnum;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.eye.util.PBKDF2Util;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class EyeAuther {
    public static final String AUTH_TOKEN = Instance.getClusterName() + "-Auth_Token";
    public static final String CSRF_TOKEN = "monitor-csrf-token";
    public static final String TIANYAN_USER = "cosmiceye";
    private static final String KEY_HEALTHCHECK_URI = "/monitor/service/healthcheckk8s";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String IGNORE_CHECK_URI = "/monitor/eye/permission/user,/monitor/eye/user/info,/monitor/eye/topology";
    private static final Log log = LogFactory.getLog(EyeAuther.class);

    public static boolean checkSkip(HttpExchange exchange) {
        URI requestURI = exchange.getRequestURI();
        if (Instance.getClusterName() == null) {
            return true;
        }
        if (EyeAuther.checkURIRequestNoneLogin(requestURI)) {
            return true;
        }
        return EyeAuther.checkProxyHeader(exchange);
    }

    public static boolean check(HttpExchange exchange) {
        boolean pass;
        if (EyeAuther.checkSkip(exchange)) {
            return true;
        }
        boolean bl = pass = EyeAuther.checkToken(exchange) && EyeAuther.checkPermission(exchange, "");
        if (pass) {
            SessionStore.get().expireAfter(EyeAuther.getToken(exchange));
        }
        return pass;
    }

    public static boolean checkCosmiceyeAuth(HttpExchange exchange) throws IOException {
        if (EyeAuther.checkSkip(exchange)) {
            return true;
        }
        boolean pass = EyeAuther.checkCosmiceyePermission(exchange);
        if (pass) {
            SessionStore.get().expireAfter(EyeAuther.getToken(exchange));
        }
        return pass;
    }

    public static boolean checkCosmiceyeToken(HttpExchange exchange) {
        String token = EyeAuther.getToken(exchange);
        if (token == null) {
            return false;
        }
        return EyeAuther.checkToken(token);
    }

    public static boolean checkCosmiceyePermission(HttpExchange exchange) throws IOException {
        JSONObject permissionMap;
        String apiUri = exchange.getRequestURI().getPath();
        if (StringUtils.isEmpty((String)apiUri)) {
            return false;
        }
        String model = System.getProperty("monitor.dev.model");
        if ("debug".equals(model)) {
            return true;
        }
        if (!apiUri.startsWith("/monitor") && apiUri.contains("/monitor")) {
            apiUri = apiUri.substring(apiUri.indexOf("/monitor"));
        }
        if (apiUri.contains("?")) {
            apiUri = apiUri.substring(0, apiUri.indexOf("?"));
        }
        if (apiUri.endsWith("/")) {
            apiUri = apiUri.substring(0, apiUri.length() - 1);
        }
        if (!(permissionMap = EyeAuther.getPermissionMappingJSON()).containsKey((Object)apiUri)) {
            return true;
        }
        String permissionPoint = permissionMap.getString(apiUri);
        CosmiceyeResponse rs = CosmiceyeAuth.get().checkpermission(EyeAuther.getToken(exchange), permissionPoint);
        return rs != null && rs.getErrcode() == 0;
    }

    private static boolean checkURIRequestNoneLogin(URI requestURI) {
        String path = requestURI.getPath();
        return path.equals(KEY_HEALTHCHECK_URI);
    }

    private static boolean checkURIRequest(URI requestURI) {
        String path = requestURI.getPath();
        return path.equals(KEY_HEALTHCHECK_URI) || path.contains("/eye/algox") || path.contains("/goldeye/algoxfp");
    }

    public static boolean checkUser(String userName, String password) {
        String initUser = System.getProperty("monitor.user");
        String model = System.getProperty("monitor.dev.model");
        if (userName.equals(initUser)) {
            if (!DBHelper.dbIsConfigured() || "debug".equals(model)) {
                return EyeAuther.checkInitUser(password);
            }
            UserDao userDao = new UserDao();
            User user = userDao.getUserByName(userName);
            return user == null ? EyeAuther.checkInitUser(password) : EyeAuther.checkDBUser(user, password);
        }
        if (!DBHelper.dbIsConfigured()) {
            return false;
        }
        UserDao userDao = new UserDao();
        User user = userDao.getUserByName(userName);
        return user != null && EyeAuther.checkDBUser(user, password);
    }

    public static boolean checkCSRFToken(HttpExchange exchange) {
        URI requestURI = exchange.getRequestURI();
        if (Instance.getClusterName() == null) {
            return true;
        }
        if (EyeAuther.checkURIRequest(requestURI)) {
            return true;
        }
        if (EyeAuther.checkProxyHeader(exchange)) {
            return true;
        }
        if (EyeAuther.isProxy(exchange)) {
            return true;
        }
        if (EyeAuther.isMetric(exchange)) {
            return true;
        }
        if (EyeAuther.isDownloadFile(exchange)) {
            return true;
        }
        if (EyeAuther.isThreadDump(requestURI)) {
            return true;
        }
        if (EyeAuther.isZipkinTrace(requestURI)) {
            return true;
        }
        String token = EyeAuther.getToken(exchange);
        Map<String, String> info = SessionStore.get().get(token);
        String csrfToken = info.get(CSRF_TOKEN);
        String csrfTokenInHeader = exchange.getRequestHeaders().getFirst(CSRF_TOKEN);
        return csrfToken.equals(csrfTokenInHeader);
    }

    public static String getCsrfToken(String token) {
        Map<String, String> info = SessionStore.get().get(token);
        return info.get(CSRF_TOKEN);
    }

    private static boolean checkInitUser(String password) {
        String mp = System.getProperty("monitor.password");
        if (mp != null) {
            mp = Encrypters.decode((String)mp);
            return password.equals(mp);
        }
        return false;
    }

    private static boolean checkDBUser(User user, String password) {
        boolean correct;
        String dbPassword = user.getUserPassword();
        if (PBKDF2Util.isEncryptByPbkdf2(dbPassword)) {
            correct = PBKDF2Util.authenticate(password, dbPassword, user.getUserName());
        } else {
            String encryptedPassword = MonitorLoginUtils.encryptPSWWihtSHA256(password);
            correct = dbPassword.equals(encryptedPassword);
        }
        return correct;
    }

    public static boolean isFirstLoginUser(String userName, String password) {
        String initUser = System.getProperty("monitor.user");
        String mp = System.getProperty("monitor.password");
        if (!userName.equals(initUser)) {
            return false;
        }
        if (!DBHelper.dbIsConfigured()) {
            return true;
        }
        UserDao userDao = new UserDao();
        User user = userDao.getUserByName(userName);
        if (user == null) {
            RoleDao roleDao = new RoleDao();
            roleDao.initAdminRole();
            userDao.initAdminUser();
            return true;
        }
        if (mp != null) {
            mp = Encrypters.decode((String)mp);
            return password.equals(mp);
        }
        return false;
    }

    public static String getCurrentUserPermission(HttpExchange exchange) {
        String token = EyeAuther.getToken(exchange);
        Map<String, String> userInfo = SessionStore.get().get(token);
        return EyeAuther.getUserPermission(userInfo.get("user"));
    }

    public static String getUserPermission(String userName) {
        RoleDao roleDao = new RoleDao();
        UserDao userDao = new UserDao();
        User user = userDao.getUserByName(userName);
        Role role = roleDao.getRoleByName(user.getUserRole());
        return role == null ? null : role.getRoleResource();
    }

    public static String getRolePermission(String role) {
        RoleDao roleDao = new RoleDao();
        if (!DBHelper.dbIsConfigured()) {
            return System.getProperty("monitor.guest.default.action", "[\"appList\",\"appList-threadDump\",\"appList-systemAttributes\",\"appList-memoryObject\",\"appList-tempTable\",\"appList-algox\",\"appList-localCacheMonitor\",\"appList-mqConsumerMonitor\",\"appList-top\",\"logQuery\",\"threadAnalyse\",\"realTimeMonitor\",\"baseComponent\",\"baseComponent-redis\",\"baseComponent-mqMonitor\",\"baseComponent-healthCheck\",\"performance\",\"performance-slowQuery\",\"microService\",\"microService-trace\",\"microService-apiMonitor\",\"microService-armor-apiLink\",\"platform\",\"platform-dts\",\"platform-dlock\"]");
        }
        Role roleInfo = roleDao.getRoleByName(role);
        if (roleInfo != null) {
            return roleInfo.getRoleResource();
        }
        if (role.equals("admin")) {
            return RoleDao.getAllPermission();
        }
        return System.getProperty("monitor.guest.default.action", "[\"appList\",\"appList-threadDump\",\"appList-systemAttributes\",\"appList-memoryObject\",\"appList-tempTable\",\"appList-algox\",\"appList-localCacheMonitor\",\"appList-mqConsumerMonitor\",\"appList-top\",\"logQuery\",\"threadAnalyse\",\"realTimeMonitor\",\"baseComponent\",\"baseComponent-redis\",\"baseComponent-mqMonitor\",\"baseComponent-healthCheck\",\"performance\",\"performance-slowQuery\",\"microService\",\"microService-trace\",\"microService-apiMonitor\",\"microService-armor-apiLink\",\"platform\",\"platform-dts\",\"platform-dlock\"]");
    }

    public static boolean isExpirePassword(String userName) {
        String initUser = System.getProperty("monitor.user");
        if (!DBHelper.dbIsConfigured() && userName.equals(initUser)) {
            return false;
        }
        UserDao userDao = new UserDao();
        User user = userDao.getUserByName(userName);
        if (user.getExpireDate() == null) {
            return false;
        }
        LocalDate expireDate = LocalDate.parse(user.getExpireDate(), dateTimeFormatter);
        LocalDate now = LocalDate.now();
        return expireDate.isBefore(now);
    }

    private static boolean checkToken(HttpExchange exchange) {
        String token = EyeAuther.getToken(exchange);
        if (token == null) {
            return false;
        }
        return EyeAuther.checkToken(token);
    }

    private static boolean checkProxyHeader(HttpExchange exchange) {
        if (exchange.getClass().toString().endsWith(".ServletExchangeImpl")) {
            return false;
        }
        String value = exchange.getRequestHeaders().getFirst(EyeProxyHandler.PROXY_HEADER_KEY);
        return EyeProxyHandler.PROXY_HEADER_VALUE.equals(value);
    }

    private static boolean isMetric(HttpExchange exchange) {
        return exchange.getRequestURI().getPath().contains("/eye/metric");
    }

    private static boolean isZipkinTrace(URI requestURI) {
        String uri = requestURI.getPath();
        return uri.contains("/eye/tc");
    }

    private static boolean isDownloadFile(HttpExchange exchange) {
        String url = exchange.getRequestURI().getPath();
        return url.contains("/goldeye/flame/graph/download") || url.contains("/goldeye/flame/graph/view") || url.contains("/eye/fileServerManager/server/downloadScript");
    }

    private static boolean isThreadDump(URI requestURI) {
        String uri = requestURI.getPath();
        return uri.contains("/eye/newthreaddumpproxy") || uri.contains("/eye/newthreaddump") || uri.contains("/eye/newremotethreaddump") || uri.contains("/eye/ShowThreadDumpInfo") || uri.contains("/eye/threadmonitor");
    }

    private static boolean isProxy(HttpExchange exchange) {
        String url = exchange.getRequestURI().getPath();
        return url.contains("/eye/proxy1") || url.contains("/eye/proxy") || url.contains("/eye/proxy0") || url.contains("/eye/jmxProxy") || url.contains("/eye/proxy2");
    }

    private static boolean checkToken(String token) {
        return SessionStore.get().exists(token);
    }

    public static String getToken(HttpExchange exchange) {
        String authToken = exchange.getRequestHeaders().getFirst(AUTH_TOKEN);
        if (StringUtils.isEmpty((String)authToken)) {
            String[] cookiearry;
            String cookies = exchange.getRequestHeaders().getFirst("Cookie");
            if (StringUtils.isEmpty((String)cookies)) {
                return null;
            }
            for (String cookie : cookiearry = cookies.split(";")) {
                if (!(cookie = cookie.replaceAll(" ", "")).startsWith(AUTH_TOKEN + "=")) continue;
                authToken = cookie.replace(AUTH_TOKEN + "=", "").replace(";", "");
            }
        }
        return authToken;
    }

    public static String newToken(String user, String password) {
        String token = StringUtils.randomWord((int)32);
        String csrfToken = StringUtils.randomWord((int)32);
        String model = System.getProperty("monitor.dev.model");
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("logintype", "ierp");
        info.put("user", user);
        info.put("password", password);
        info.put(CSRF_TOKEN, csrfToken);
        if ("debug".equals(model)) {
            info.put("isFirstLogin", "false");
            info.put("isExpired", "false");
        } else {
            info.put("isFirstLogin", EyeAuther.isFirstLoginUser(user, password) ? "true" : "false");
            info.put("isExpired", EyeAuther.isExpirePassword(user) ? "true" : "false");
        }
        SessionStore.get().store(token, info);
        return token;
    }

    public static String createClientSession(String token, String client) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("logintype", client);
        String csrfToken = StringUtils.randomWord((int)32);
        info.put("token", token);
        info.put("user", TIANYAN_USER);
        info.put(CSRF_TOKEN, csrfToken);
        info.put("isFirstLogin", "false");
        info.put("isExpired", "false");
        SessionStore.get().store(token, info);
        return token;
    }

    public static boolean checkNewUser(HttpExchange exchange) {
        String token = EyeAuther.getToken(exchange);
        Map<String, String> userInfo = SessionStore.get().get(token);
        String userName = userInfo.get("user");
        String initUser = System.getProperty("monitor.user");
        String model = System.getProperty("monitor.dev.model");
        if (initUser.equals(userName) || "debug".equals(model) || !DBHelper.dbIsConfigured()) {
            return false;
        }
        String uri = exchange.getRequestURI().getPath();
        if (!uri.startsWith("/monitor") && uri.contains("/monitor")) {
            uri = uri.substring(uri.indexOf("/monitor"));
        }
        if (IGNORE_CHECK_URI.contains(uri)) {
            return false;
        }
        return EyeAuther.isNewUser(userName);
    }

    public static boolean isNewUser(String userName) {
        UserDao dao = new UserDao();
        User user = dao.getUserByName(userName);
        if (user != null) {
            return user.getUserPassword().endsWith("_NEW");
        }
        return false;
    }

    public static boolean checkPermission(HttpExchange exchange, String filed, String requestType) throws IOException {
        String token = EyeAuther.getToken(exchange);
        if (!EyeAuther.checkToken(token)) {
            return false;
        }
        Map<String, String> userInfo = SessionStore.get().get(token);
        String userName = userInfo.get("user");
        String initUser = System.getProperty("monitor.user");
        String model = System.getProperty("monitor.dev.model");
        if (userName.equals(initUser) || "debug".equals(model)) {
            return true;
        }
        if (!DBHelper.dbIsConfigured()) {
            return false;
        }
        String currentUser = "";
        if (filed.contains(":")) {
            String[] arr = filed.split(":");
            filed = arr[0];
            currentUser = arr[1];
        }
        if ("user".equals(filed) && RequestTypeEnum.USER_LIST_EDIT.getRequestType().equals(requestType) && (userName.equals(currentUser) || EyeAuther.isNewUser(userName))) {
            return true;
        }
        String permissionId = EyeAuther.getPermissionId(filed, requestType);
        if (StringUtils.isBlank((String)permissionId)) {
            return false;
        }
        if (permissionId.contains(requestType)) {
            return true;
        }
        if (userInfo.get("logintype").equals(SsoClients.COSMICEYE.getName()) && userName.equals(TIANYAN_USER)) {
            CosmiceyeResponse response = CosmiceyeAuth.get().checkpermission(token, permissionId);
            return response != null && response.getErrcode() == 0;
        }
        String userPermission = EyeAuther.getUserPermission(userName);
        if (StringUtils.isBlank((String)userPermission)) {
            return false;
        }
        JSONArray permissionArray = JSONArray.parseArray((String)userPermission);
        return permissionArray.contains((Object)permissionId);
    }

    public static boolean checkPermission(HttpExchange exchange, String apiUri) {
        String token = EyeAuther.getToken(exchange);
        if (StringUtils.isEmpty((String)apiUri)) {
            apiUri = exchange.getRequestURI().getPath();
        }
        boolean contains = false;
        if (token != null && token.endsWith("$COSMICEYE")) {
            try {
                contains = EyeAuther.checkCosmiceyeAuth(exchange);
            }
            catch (IOException e) {
                log.error("checkCosmiceyeAuth error:" + e.getMessage(), (Throwable)e);
            }
        } else {
            Map<String, String> userInfo = SessionStore.get().get(token);
            String userName = userInfo.get("user");
            contains = EyeAuther.checkPermission(userName, apiUri);
        }
        if (contains) {
            SessionStore.get().expireAfter(token);
        }
        return contains;
    }

    public static boolean checkPermission(String userName, String apiUri) {
        JSONObject permissionMap;
        String initUser = System.getProperty("monitor.user");
        String model = System.getProperty("monitor.dev.model");
        if (userName.equals(initUser) || "debug".equals(model)) {
            return true;
        }
        if (!DBHelper.dbIsConfigured()) {
            return false;
        }
        if (StringUtils.isEmpty((String)apiUri)) {
            return false;
        }
        if (!apiUri.startsWith("/monitor") && apiUri.contains("/monitor")) {
            apiUri = apiUri.substring(apiUri.indexOf("/monitor"));
        }
        if (apiUri.contains("?")) {
            apiUri = apiUri.substring(0, apiUri.indexOf("?"));
        }
        if (apiUri.endsWith("/")) {
            apiUri = apiUri.substring(0, apiUri.length() - 1);
        }
        if (!(permissionMap = EyeAuther.getPermissionMappingJSON()).containsKey((Object)apiUri)) {
            return true;
        }
        String permissionPoint = permissionMap.getString(apiUri);
        String userPermission = EyeAuther.getUserPermission(userName);
        if (StringUtils.isBlank((String)userPermission)) {
            return false;
        }
        JSONArray permissionArray = JSONArray.parseArray((String)userPermission);
        boolean contains = permissionArray.contains((Object)permissionPoint);
        return contains;
    }

    private static String getPermissionId(String filed, String requestType) {
        JSONArray array = EyeAuther.getPermissionConfigJSON();
        String permissionId = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            if (!obj.containsKey((Object)filed)) continue;
            JSONObject map = obj.getJSONObject(filed);
            String ignoreType = map.getString("ignore");
            if (ignoreType.contains(requestType)) {
                permissionId = ignoreType;
                break;
            }
            permissionId = map.getString(requestType);
            break;
        }
        return permissionId;
    }

    private static JSONArray getPermissionConfigJSON() {
        StringBuilder json = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("permission-type.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return JSONArray.parseArray((String)json.toString());
    }

    private static JSONObject getPermissionMappingJSON() {
        StringBuilder json = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("permission-mapping.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return JSONObject.parseObject((String)json.toString());
    }

    public static boolean isForbidden(String userName) {
        String key = "monitor-forbidden-account-" + userName;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String oldNum = (String)cache.get(key, (Object)userName);
        if (StringUtils.isEmpty((String)oldNum)) {
            cache.put(key, (Object)userName, (Object)"1");
            return false;
        }
        int config = Integer.getInteger("monitor.login.errorTimes", 8);
        int parseInt = Integer.parseInt(oldNum);
        if (parseInt >= config) {
            return true;
        }
        if (parseInt == config - 1) {
            int effectiveTimes = Integer.getInteger("monitor.account.lock.time", 1800);
            cache.put(key, (Object)userName, (Object)String.valueOf(config));
            cache.expireAfter(key, effectiveTimes);
        } else {
            cache.put(key, (Object)userName, (Object)String.valueOf(parseInt + 1));
        }
        return false;
    }

    public static boolean isLocked(String userName) {
        String key;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String oldNum = (String)cache.get(key = "monitor-forbidden-account-" + userName, (Object)userName);
        if (StringUtils.isEmpty((String)oldNum)) {
            return false;
        }
        int config = Integer.getInteger("monitor.login.errorTimes", 8);
        int parseInt = Integer.parseInt(oldNum);
        if (parseInt >= config) {
            return true;
        }
        cache.remove(key);
        return false;
    }
}

