/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.auth.third;

import java.util.Map;
import kd.bos.eye.api.thirdauth.AuthResponseInfo;
import kd.bos.eye.auth.third.TokenCheckPlugin;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class DefaultTokenCheckPlugin
implements TokenCheckPlugin {
    private static final String PLUGIN_PREFIX = "monitor.auth.plugin";
    private static final String URL_SUFFIX = "url";
    private final Log logger = LogFactory.getLog(DefaultTokenCheckPlugin.class);

    @Override
    public boolean check(Map<String, String> params) {
        AuthResponseInfo authResponseInfo;
        String data;
        String source = params.get("source");
        String authUrl = System.getProperty("monitor.auth.plugin." + source + "." + URL_SUFFIX);
        authUrl = this.createAuthUrl(params, authUrl);
        try {
            data = EyeHttpClients.get(authUrl);
        }
        catch (Exception e) {
            this.logger.error("Checking token by third http interface is failed! ERROR INFO: " + e);
            return false;
        }
        try {
            authResponseInfo = (AuthResponseInfo)JSONUtils.cast((String)data, AuthResponseInfo.class);
        }
        catch (Exception e) {
            this.logger.error("Casting response of checking token is failed! ERROR INFO: " + e);
            return false;
        }
        return authResponseInfo != null && authResponseInfo.getCode().equals("0");
    }

    private String createAuthUrl(Map<String, String> params, String authUrl) {
        StringBuilder query = new StringBuilder(authUrl).append('?');
        for (Map.Entry<String, String> entry : params.entrySet()) {
            query.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return query.substring(0, query.length() - 1);
    }
}

