/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.config.service.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.config.service.AbstractEyeConfigService;
import kd.bos.eye.config.service.DbExecuteService;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.util.EyeZkFactory;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZookeeperEyeConfigService
extends AbstractEyeConfigService {
    private static final ExecutorService pool = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10000), (ThreadFactory)new NamedThreadFactory("monitor-zookeeper-config-update", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static final Log log = LogFactory.getLog(ZookeeperEyeConfigService.class);
    private final String region;
    private final String zkPath;
    private final String serverAddr;
    private final DbExecuteService loadDBDataCall;
    private CuratorCacheListener listener;
    private CuratorFramework zkClient = null;
    private CuratorCache nodeCache = null;

    public ZookeeperEyeConfigService(String region, String path, DbExecuteService loadDBDataCall, EyeConfigChangeListener eyeConfigChangeListener) {
        this.region = region;
        this.serverAddr = EyeZkFactory.getZKUrl(region);
        this.zkPath = ZKFactory.getZkRootPath((String)this.serverAddr) + path;
        this.loadDBDataCall = loadDBDataCall;
        this.getEyeConfigChanger().addListener(eyeConfigChangeListener);
        this.init();
    }

    private void init() {
        this.initZookeeperListener();
        this.loadInitialConfigFromDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialConfigFromDB() {
        block10: {
            DLock dLock = null;
            try {
                Map<String, String> dbDataMap;
                if (!DBHelper.dbIsConfigured() || (dbDataMap = this.loadDBDataCall.queryData("initDataFromDB")) == null || !EyeZkFactory.isModifyZKUrl(this.region, this.serverAddr) && this.zkClient.checkExists().forPath(this.zkPath) != null) break block10;
                try {
                    dLock = DLock.create((String)this.zkPath);
                    if (this.zkClient.checkExists().forPath(this.zkPath) != null) {
                        this.zkClient.delete().deletingChildrenIfNeeded().forPath(this.zkPath);
                    }
                    for (Map.Entry<String, String> entry : dbDataMap.entrySet()) {
                        this.saveConfig(entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    log.warn("[ZookeeperEyeConfigService] loadInitialConfigFromDB saveConfig exception,path: " + this.zkClient, (Throwable)e);
                }
                finally {
                    if (dLock != null) {
                        dLock.unlock();
                    }
                }
            }
            catch (Exception e) {
                log.warn("[ZookeeperEyeConfigService] loadInitialConfigFromDB exception,path: " + this.zkClient, (Throwable)e);
            }
        }
    }

    private void initZookeeperListener() {
        try {
            this.listener = CuratorCacheListener.builder().forPathChildrenCache(this.zkPath, this.zkClient, (client, event) -> {
                try {
                    if (event.getData() != null) {
                        String changePath = event.getData().getPath();
                        this.getEyeConfigChanger().updateValue(changePath.substring(this.zkPath.length() + 1), new String(event.getData().getData(), StandardCharsets.UTF_8));
                    }
                }
                catch (Exception ex) {
                    RecordLog.warn((String)"[ZookeeperEyeConfigService] loadConfig exception", (Throwable)ex);
                }
            }).build();
            this.zkClient = ZKFactory.getZKClient((String)this.serverAddr);
            this.nodeCache = CuratorCache.build((CuratorFramework)this.zkClient, (String)this.zkPath, (CuratorCache.Options[])new CuratorCache.Options[0]);
            this.nodeCache.listenable().addListener((Object)this.listener, (Executor)pool);
            this.nodeCache.start();
        }
        catch (Exception e) {
            log.warn("[ZookeeperEyeConfigService] Error occurred when initializing Zookeeper data source", (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.nodeCache != null) {
            this.nodeCache.listenable().removeListener((Object)this.listener);
            this.nodeCache.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        pool.shutdown();
    }

    @Override
    public String getPath() {
        return this.zkPath;
    }

    @Override
    public void saveConfig(String childrenPath, String timeout) {
        if (childrenPath == null) {
            throw new IllegalArgumentException("The childrenPath not allowed to be null");
        }
        if (!childrenPath.startsWith("/")) {
            childrenPath = "/" + childrenPath;
        }
        String fullPath = this.zkPath + childrenPath;
        try {
            Stat exists = (Stat)this.zkClient.checkExists().forPath(fullPath);
            if (exists == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(fullPath, timeout.getBytes(StandardCharsets.UTF_8));
            } else {
                this.zkClient.setData().forPath(fullPath, timeout.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }
}

