/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.mservice.monitor.lang.LangContext;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.JSONUtils;

public abstract class AbstractHttpHandler
implements HttpHandler {
    protected static String getToken(HttpExchange exchange) {
        return EyeAuther.getToken(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            this.creatMonitorRequestContext();
            ThreadTruck.put((Object)"monitor-requestContext-login", (Object)true);
            LangContext.setLangContext((HttpExchange)exchange);
            String token = EyeAuther.getToken(exchange);
            String logintype = "ierp";
            if (token != null) {
                if (!SessionStore.get().exists(token)) {
                    if (token.endsWith("$COSMICEYE")) {
                        logintype = SsoClients.COSMICEYE.getName();
                    }
                } else {
                    Map<String, String> info = SessionStore.get().get(token);
                    logintype = info.get("logintype");
                }
            } else if (!EyeAuther.checkSkip(exchange)) {
                this.noToken(exchange);
            }
            if (logintype.equals(SsoClients.COSMICEYE.getName())) {
                CosmiceyeResponse rs;
                if (!this.checkCosmiceyeToken(exchange) && (rs = CosmiceyeAuth.get().auth(token)) != null) {
                    if (rs.getErrcode() == 0) {
                        String localToken = CosmiceyeAuth.get().formatLocalToken(token);
                        EyeAuther.createClientSession(localToken, SsoClients.COSMICEYE.getName());
                    } else if (rs.getErrcode() == 401) {
                        this.noCosmiceyeAuth(exchange);
                    }
                }
                if (this.checkCosmiceyeAuth(exchange)) {
                    this.handle0(exchange);
                } else {
                    this.noCosmiceyePermission(exchange);
                }
            } else if (this.checkAuth(exchange)) {
                if (!this.checkCSRF(exchange)) {
                    this.attackByCSRF(exchange);
                } else if (this.checkNewUser(exchange)) {
                    this.noModifyNewUserPassword(exchange);
                } else {
                    this.handle0(exchange);
                }
            } else {
                this.noPermission(exchange);
            }
        }
        finally {
            ThreadTruck.current().close();
        }
    }

    private void creatMonitorRequestContext() {
        String traceId = TraceIdUtil.createTraceIdString();
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setTraceId(traceId);
        rc.setUserAgent("Monitor");
        rc.setClient("Monitor");
        RequestContextThreadBinder.bind((RequestContext)rc);
    }

    public void resetMonitorRequestContext(String traceId) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            requestContext.setTraceId(traceId);
            RequestContextThreadBinder.bind((RequestContext)requestContext);
        }
    }

    private void noCosmiceyeAuth(HttpExchange exchange) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("code", 60009);
        map.put("msg", "No permission");
        ApiResponse<HashMap<String, Object>> response = new ApiResponse<HashMap<String, Object>>();
        response.setCode(60009);
        response.setData(map);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void noCosmiceyePermission(HttpExchange exchange) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("code", 60010);
        map.put("msg", "No permission");
        ApiResponse<HashMap<String, Object>> response = new ApiResponse<HashMap<String, Object>>();
        response.setCode(60010);
        response.setData(map);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void noToken(HttpExchange exchange) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("code", 50009);
        map.put("msg", "No token");
        ApiResponse<HashMap<String, Object>> response = new ApiResponse<HashMap<String, Object>>();
        response.setCode(50009);
        response.setMsg("No token");
        response.setData(map);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void noPermission(HttpExchange exchange) throws IOException {
        String uri = exchange.getRequestURI().getPath();
        if (uri.endsWith("/eye/tc/") || uri.endsWith("/eye/tc")) {
            ExchangeVueUtils.redirect(exchange, "/monitor/eye/#/login?redirect=%2Ftc");
            return;
        }
        if (uri.contains("eye/newthreaddump") || uri.contains("eye/ShowThreadDumpInfo")) {
            ExchangeVueUtils.redirect(exchange, "../");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("code", 50009);
        map.put("msg", "No permission");
        ApiResponse<HashMap<String, Object>> response = new ApiResponse<HashMap<String, Object>>();
        response.setCode(50009);
        response.setMsg("No permission");
        response.setData(map);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void attackByCSRF(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(50009);
        response.setMsg("attack by CSRF!");
        response.setData(null);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void noModifyNewUserPassword(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(50009);
        response.setMsg("\u63d0\u793a\uff1a\u65b0\u7528\u6237\u672a\u4fee\u6539\u5bc6\u7801\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u540e\u518d\u64cd\u4f5c!");
        response.setData(null);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private boolean checkNewUser(HttpExchange exchange) {
        return EyeAuther.checkNewUser(exchange);
    }

    private boolean checkAuth(HttpExchange exchange) {
        return EyeAuther.check(exchange);
    }

    private boolean checkCosmiceyeToken(HttpExchange exchange) throws IOException {
        return EyeAuther.checkCosmiceyeToken(exchange);
    }

    private boolean checkCosmiceyeAuth(HttpExchange exchange) throws IOException {
        return EyeAuther.checkCosmiceyeAuth(exchange);
    }

    private boolean checkCSRF(HttpExchange exchange) {
        return EyeAuther.checkCSRFToken(exchange);
    }

    protected abstract void handle0(HttpExchange var1) throws IOException;

    protected Map<String, String> getParams(HttpExchange exchange, boolean rawQuery) {
        URI uri = exchange.getRequestURI();
        String query = rawQuery ? uri.getRawQuery() : uri.getQuery();
        Map<String, String> params = EyeUriQuery.toMap(query);
        for (Map.Entry<String, String> param : params.entrySet()) {
            params.put(param.getKey(), this.cleanXSSParam(param.getValue()));
        }
        return params;
    }

    protected String cleanXSSParam(String value) {
        String cleanValue = value;
        cleanValue = cleanValue.replaceAll("\"", "&quot;");
        cleanValue = cleanValue.replaceAll("'", "&#39;");
        cleanValue = cleanValue.replaceAll("<", "&lt;");
        cleanValue = cleanValue.replaceAll(">", "&gt;");
        return cleanValue;
    }

    protected String cleanXSSResponse(String value) {
        String cleanValue = value;
        cleanValue = cleanValue.replaceAll("<script>", "&lt;script&gt;").replaceAll("</script>", "&lt;/script&gt;");
        return cleanValue;
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected void writeHtml(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

