/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.httpserver;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.eye.httpserver.HandlerProvider;

public class EyeHttpServer {
    public static final String THREAD_NAME = "eye-http";
    private final HttpServer server;
    private final Executor executor;
    private final AtomicLong id = new AtomicLong();

    public EyeHttpServer(int port) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.executor = Executors.newFixedThreadPool(4, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "eye-http-" + EyeHttpServer.this.id.incrementAndGet());
            }
        });
    }

    public void addHandler(String context, HttpHandler handler) {
        this.server.createContext(context, handler);
    }

    public void addHandler(String context, HandlerProvider provider) {
        this.server.createContext(context, provider.get());
    }

    public void start() throws IOException {
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }
}

