/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.httpserver;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.EyeResourceHandler;
import kd.bos.eye.api.alarm.AlarmConfigHandler;
import kd.bos.eye.api.alarm.AlarmRecordHandler;
import kd.bos.eye.api.algox.AlgoXNodeCheckHandler;
import kd.bos.eye.api.algox.FlinkProxyApiHandler;
import kd.bos.eye.api.algox.FlinkResourceHandler;
import kd.bos.eye.api.apicall.APICallDetailHandler;
import kd.bos.eye.api.apicall.APICallHandler;
import kd.bos.eye.api.apicall.APIDescConfigHandler;
import kd.bos.eye.api.appha.handler.AppHealthCheckHandler;
import kd.bos.eye.api.appha.handler.AppHealthQueryHandler;
import kd.bos.eye.api.appha.handler.AppNamesHandler;
import kd.bos.eye.api.appha.handler.ExceptionDetailsHandler;
import kd.bos.eye.api.appha.handler.ExceptionQueryHandler;
import kd.bos.eye.api.appha.handler.HealthIndicatorConfigHandler;
import kd.bos.eye.api.appha.handler.LoadBalanceReporterHandler;
import kd.bos.eye.api.appha.handler.LoadForwardHandler;
import kd.bos.eye.api.appinfo.AppInfoApiHandler;
import kd.bos.eye.api.armor.APILinkHandler;
import kd.bos.eye.api.armor.DegradeHandler;
import kd.bos.eye.api.armor.FlowHandler;
import kd.bos.eye.api.config.DbConfigHandler;
import kd.bos.eye.api.config.GovernConfigHandler;
import kd.bos.eye.api.config.RpcConfigHandler;
import kd.bos.eye.api.config.UnifiedConfigHandler;
import kd.bos.eye.api.dashboard.DeleteDashboardHandler;
import kd.bos.eye.api.dashboard.QueryDashboardHandler;
import kd.bos.eye.api.dashboard.QueryDashboardRelationHandler;
import kd.bos.eye.api.dashboard.SaveDashboardHandler;
import kd.bos.eye.api.dashboard.SaveDashboardRelationHandler;
import kd.bos.eye.api.dashboard.metrics.MetricsConfigHandler;
import kd.bos.eye.api.dashboard.metrics.QueryMetricsHandler;
import kd.bos.eye.api.dashboard.widgets.DeleteWidgetsHandler;
import kd.bos.eye.api.dashboard.widgets.QueryWidgetsHandler;
import kd.bos.eye.api.dashboard.widgets.SaveWidgetsHandler;
import kd.bos.eye.api.datasource.DataSourceApiHandler;
import kd.bos.eye.api.dbmonitor.handler.DataBaseManageHandler;
import kd.bos.eye.api.dbmonitor.handler.ExplainHandler;
import kd.bos.eye.api.dbmonitor.handler.ProcessListHandler;
import kd.bos.eye.api.dbmonitor.handler.SqlKillHandler;
import kd.bos.eye.api.dlock.DLockApiHandler;
import kd.bos.eye.api.dtx.service.AccountInfoHandler;
import kd.bos.eye.api.dtx.service.DateRangeHandler;
import kd.bos.eye.api.dtx.service.NoSuccessInfosHandler;
import kd.bos.eye.api.dtx.service.SceneInfosHandler;
import kd.bos.eye.api.dtx.service.SearchLogHandler;
import kd.bos.eye.api.dtx.service.TenantInfosHandler;
import kd.bos.eye.api.dtx.service.lockedBusiness.DeleteLockedBusinessInfoHandler;
import kd.bos.eye.api.dtx.service.lockedBusiness.LockedBusinessHandler;
import kd.bos.eye.api.dtx.service.methodparams.MethodParamsHandler;
import kd.bos.eye.api.dtx.service.reporter.history.HistoryNotRepairHandler;
import kd.bos.eye.api.dtx.service.reporter.history.HistoryOverViewHandler;
import kd.bos.eye.api.dtx.service.reporter.history.HistorySceneViewHandler;
import kd.bos.eye.api.dtx.service.reporter.history.HistoryTenantViewHandler;
import kd.bos.eye.api.dtx.service.reporter.realtime.OverViewHandler;
import kd.bos.eye.api.dtx.service.reporter.realtime.SceneViewHandler;
import kd.bos.eye.api.dtx.service.reporter.realtime.TenantViewHandler;
import kd.bos.eye.api.eventdata.EventDataHandler;
import kd.bos.eye.api.filemanager.CryptFileRepairHandler;
import kd.bos.eye.api.filemanager.FileServiceMonitorHandler;
import kd.bos.eye.api.flamegraphs.FlameConfigHandler;
import kd.bos.eye.api.flamegraphs.FlameGraphHandler;
import kd.bos.eye.api.healthcheck.HeartBeatHandler;
import kd.bos.eye.api.healthcheck.spi.ClusterHealthCheckHandler;
import kd.bos.eye.api.home.ServiceInstTopologyHandler;
import kd.bos.eye.api.home.TopoDetailHandler;
import kd.bos.eye.api.home.TopoHandler;
import kd.bos.eye.api.home.TopoInvokeDetailHandler;
import kd.bos.eye.api.home.TopologyHandler;
import kd.bos.eye.api.jmx.JmxHandler;
import kd.bos.eye.api.jmx.chart.ChartJsonHandler;
import kd.bos.eye.api.jmx.chart.ConnectPoolChartJsonHandler;
import kd.bos.eye.api.limiter.LimiterSceneHandler;
import kd.bos.eye.api.localcache.LocalCacheClearHandler;
import kd.bos.eye.api.localcache.LocalCacheInfoApiHandler;
import kd.bos.eye.api.log.LogDatasourceHandler;
import kd.bos.eye.api.log.LogDiscardCountHandler;
import kd.bos.eye.api.log.LogQueryHandler;
import kd.bos.eye.api.log.QueryLogHandler;
import kd.bos.eye.api.log.SlowQueryHandler;
import kd.bos.eye.api.log.ruleconfig.LogRuleConfigHandler;
import kd.bos.eye.api.loghealth.service.ConfigCompleteCheckHandeler;
import kd.bos.eye.api.loghealth.service.ESHealthCheckHandler;
import kd.bos.eye.api.loghealth.service.ESSampleHandler;
import kd.bos.eye.api.loghealth.service.KafkaHealthCheckHandler;
import kd.bos.eye.api.loghealth.service.KafkaSampleHandler;
import kd.bos.eye.api.loghealth.service.LogChainCheckHandler;
import kd.bos.eye.api.loghealth.service.LogstashHealthCheckHandler;
import kd.bos.eye.api.loghealth.service.LogstashSampleHandler;
import kd.bos.eye.api.login.LoginApiHandler;
import kd.bos.eye.api.login.LoginoutApiHandler;
import kd.bos.eye.api.login.PublicKeyHandler;
import kd.bos.eye.api.login.TokenHandler;
import kd.bos.eye.api.login.UserinfoApiHandler;
import kd.bos.eye.api.login.VerifyCodeHandler;
import kd.bos.eye.api.memobj.MemObjInfoApiHandler;
import kd.bos.eye.api.metric.MetricApiHandler;
import kd.bos.eye.api.mservice.MServiceCataLogHandler;
import kd.bos.eye.api.mservice.MServiceInfoHandler;
import kd.bos.eye.api.oplog.add.AddOpDataHandler;
import kd.bos.eye.api.oplog.service.OpLogHandler;
import kd.bos.eye.api.permission.CheckpermissionApiHandler;
import kd.bos.eye.api.permission.RoleHandler;
import kd.bos.eye.api.permission.SecondAuthHandler;
import kd.bos.eye.api.permission.UserHandler;
import kd.bos.eye.api.pktemptable.PKTempTableHandler;
import kd.bos.eye.api.pmm.PmmLoginHandler;
import kd.bos.eye.api.prometheus.ClusterMetricsHandler;
import kd.bos.eye.api.prometheus.MetricsHandler;
import kd.bos.eye.api.redis.RedisMrgHandler;
import kd.bos.eye.api.sso.SsoLoginApiHandler;
import kd.bos.eye.api.sso.components.DBListApiHandler;
import kd.bos.eye.api.sso.components.MiddlewareListApiHandler;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuthHandler;
import kd.bos.eye.api.sysprop.SystemPropApiHandler;
import kd.bos.eye.api.temptable.TempTableHandler;
import kd.bos.eye.api.tenantresource.AccountsListHandler;
import kd.bos.eye.api.tenantresource.DefaultResourceQueueHandler;
import kd.bos.eye.api.tenantresource.DefaultTenantConfigHandler;
import kd.bos.eye.api.tenantresource.ResourcesListHandler;
import kd.bos.eye.api.tenantresource.ResourcesMetricsHandler;
import kd.bos.eye.api.tenantresource.TenantConfigHandler;
import kd.bos.eye.api.tenantresource.TenantConfigSaveHandler;
import kd.bos.eye.api.tenantresource.TenantMetricsHandler;
import kd.bos.eye.api.thirdauth.ThirdAuthHandler;
import kd.bos.eye.api.thread.NewRemoteThreadHandler;
import kd.bos.eye.api.thread.NewThreadDumpHandler;
import kd.bos.eye.api.thread.NewThreadDumpProxyHandler;
import kd.bos.eye.api.thread.ShowThreadDumpInfo;
import kd.bos.eye.api.thread.ThreadDumpApiHandler;
import kd.bos.eye.api.thread.ThreadDumpOutHandler;
import kd.bos.eye.api.thread.ThreadMonitor;
import kd.bos.eye.api.thread.timeout.ThreadTimeoutHandler;
import kd.bos.eye.api.thread.timeout.service.ThreadTimeoutServiceHandler;
import kd.bos.eye.api.threadpool.ThreadPoolInfoHandler;
import kd.bos.eye.api.threadpool.ThreadPoolInfoProxyHandler;
import kd.bos.eye.api.threadpool.ThreadPoolSetHandler;
import kd.bos.eye.api.threadpool.ThreadPoolSetProxyHandler;
import kd.bos.eye.api.threadpool.ThreadPoolTaskHandler;
import kd.bos.eye.api.top.TopHandler;
import kd.bos.eye.api.trace.TraceHandler;
import kd.bos.eye.api.trace.TraceHandlerV2;
import kd.bos.eye.api.trace.TraceJsonHandler;
import kd.bos.eye.api.trace.TraceListHandler;
import kd.bos.eye.api.trace.TraceResourceHandler;
import kd.bos.eye.api.trace.TraceServiceHandler;
import kd.bos.eye.api.trace.TraceSpanHandler;
import kd.bos.eye.api.trace.WebPortHandler;
import kd.bos.eye.api.unifiedmetrics.handler.GraphDictionaryHandler;
import kd.bos.eye.api.unifiedmetrics.handler.MetricQueryHandler;
import kd.bos.eye.api.unifiedmetrics.handler.UnifiedMetaMetricsHandler;
import kd.bos.eye.api.unifiedmetrics.handler.UnifiedMetricInfoHandler;
import kd.bos.eye.api.xcache.XCacheMrgHandler;
import kd.bos.eye.httpserver.EyeHttpServer;
import kd.bos.eye.proxy.EyeJmxProxyHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.proxy.EyeProxyHandler2;
import kd.bos.monitor.httpserver.HttpServerHandler;
import kd.bos.monitor.httpserver.MonitorHttpServer;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.util.EnvUtils;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.jvmagent.handler.JolokiaHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EyeInstaller {
    private static final String MONITOR = "/monitor";
    private static final boolean enableCloseApi = Boolean.getBoolean("monitor.api.close");
    private static final Logger log = LoggerFactory.getLogger(EyeInstaller.class);
    private static final Multimap<String, Object> multiServerMap = ArrayListMultimap.create();
    private static JolokiaHttpHandler jolokiaHttpHandler;
    private static final ExtensionFactory<HttpServerHandler> httpServerFactory;
    private static final Map<String, HttpHandler> handlerMap;

    public static void install(ServletContextHandler server) throws IOException {
        EyeInstaller.install0(server, MONITOR);
    }

    public static void install(ServletContextHandler server, String contextPath) throws IOException {
        EyeInstaller.install0(server, contextPath + MONITOR);
    }

    public static void install(Object server) throws IOException {
        EyeInstaller.install0(server, MONITOR);
    }

    public static void installIerp(Object server) throws IOException {
        EyeInstaller.installIerp0(server, "");
    }

    public static synchronized void installIerp0(Object server, String contextPath) {
        EyeInstaller.addHandler(server, contextPath + "/cbs/api/log/querylogbytrace", QueryLogHandler::new);
    }

    private static synchronized void install0(Object server, String contextPath) {
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/getConfig", TenantConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/saveManualConfig", TenantConfigSaveHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/saveDefaultConfig", DefaultTenantConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/saveDefaultQueue", DefaultResourceQueueHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/resources", ResourcesListHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/resourcesMetrics", ResourcesMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/tenantMetrics", TenantMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/multitenant/accounts", AccountsListHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/proxy", () -> new EyeProxyHandler(true));
        EyeInstaller.addHandler(server, contextPath + "/eye/proxy1", () -> new EyeProxyHandler(true, true));
        EyeInstaller.addHandler(server, contextPath + "/eye/proxy0", () -> new EyeProxyHandler(false));
        EyeInstaller.addHandler(server, contextPath + "/eye/jmxProxy", () -> new EyeJmxProxyHandler(false));
        EyeInstaller.addHandler(server, contextPath + "/eye/proxy2/*", EyeProxyHandler2::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/hasToken/", TokenHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/hasToken", TokenHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/getPublicKey/", () -> PublicKeyHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/getPublicKey", () -> PublicKeyHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/", () -> new EyeResourceHandler("/bos-eye", contextPath + "/eye"));
        EyeInstaller.addHandler(server, contextPath + "/eye/*", () -> new EyeResourceHandler("/bos-eye", contextPath + "/eye"));
        EyeInstaller.addHandler(server, contextPath + "/eye/login/", () -> LoginApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/login", () -> LoginApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/loginout/", () -> LoginoutApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/loginout", () -> LoginoutApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/verifyCode", VerifyCodeHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/home/", AppInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/home", AppInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/threaddump/", ThreadDumpApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/threaddump", ThreadDumpApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/systemproperties/", SystemPropApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/systemproperties", SystemPropApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/localcacheinfo/", LocalCacheInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/localcacheinfo", LocalCacheInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/clearAllLocalCache", LocalCacheClearHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/datasource/", DataSourceApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/datasource", DataSourceApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/meminfo/", MemObjInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/meminfo", MemObjInfoApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/topCommand", TopHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/pktemptable", PKTempTableHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/pktemptable/", PKTempTableHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/algoXNodeCheck", AlgoXNodeCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/algox", () -> new FlinkResourceHandler("/bos-eye/flink", contextPath + "/eye/algox"));
        EyeInstaller.addHandler(server, contextPath + "/eye/algox/*", () -> new FlinkResourceHandler("/bos-eye/flink", contextPath + "/eye/algox"));
        EyeInstaller.addHandler(server, contextPath + "/goldeye/algoxfp/", FlinkProxyApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/algoxfp/*", FlinkProxyApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logQuery/", LogQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logQuery", LogQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/log/ruleConfig/", LogRuleConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/log/ruleConfig", LogRuleConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/queryLogDatasource", LogDatasourceHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/newthreaddumpproxy", NewThreadDumpProxyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/newthreaddump", NewThreadDumpHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/newremotethreaddump", NewRemoteThreadHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/ShowThreadDumpInfo", ShowThreadDumpInfo::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadTimeoutHandler", ThreadTimeoutHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadTimeoutService", ThreadTimeoutServiceHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadmonitor", ThreadMonitor::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/metrics", JmxHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/pigeon/metrics", JmxHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/topCommandToCluster", TopHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/alarm/record/*", AlarmRecordHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/alarm/record", AlarmRecordHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/alarm/config/*", AlarmConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/alarm/config", AlarmConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/redis/", RedisMrgHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/redis", RedisMrgHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/xcache/", XCacheMrgHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/xcache", XCacheMrgHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logChainCheck", LogChainCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logChainCheck/", LogChainCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/configCompleteCheck", ConfigCompleteCheckHandeler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/configCompleteCheck/", ConfigCompleteCheckHandeler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/kafkaHealthCheck", KafkaHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/kafkaHealthCheck/", KafkaHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/kafkaSample", KafkaSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/kafkaSample/", KafkaSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/esHealthCheck", ESHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/esHealthCheck/", ESHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/esSample", ESSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/esSample/", ESSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logstashHealthCheck", LogstashHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logstashHealthCheck/", LogstashHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logstashSample", LogstashSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logstashSample/", LogstashSampleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logDiscardCount", LogDiscardCountHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/logDiscardCount/", LogDiscardCountHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/slowQuery/", SlowQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/slowQuery", SlowQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/processListQuery", ProcessListHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/processListQuery/", ProcessListHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/explainSQL", ExplainHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/explainSQL/", ExplainHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/killSQL", SqlKillHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/killSQL/", SqlKillHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/topoAnalyse", TopoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/topoAnalyse/queryApi", TopoDetailHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/topoAnalyse/queryInvokeDetail", TopoInvokeDetailHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/flame/graph/*", FlameGraphHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/flame/graph", FlameGraphHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/flame/config/*", FlameConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/flame/config", FlameConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/trace/v2", TraceHandlerV2::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/traces/*", () -> new TraceHandler("/bos-eye/trd/trace"));
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/api/v1/trace/*", TraceJsonHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/api/v1/services", TraceServiceHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/api/v1/spans", TraceSpanHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/api/v1/traces", TraceListHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/apiCall", APICallHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/apiCall/", APICallHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/apiAction", APIDescConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/apiCallDetail", APICallDetailHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/apiCallDetail/", APICallDetailHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/armor/getApiLinkData", APILinkHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/armor/flow", FlowHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/armor/degrade", DegradeHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/config/rpcConfig", RpcConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/ratelimiter/*", LimiterSceneHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/ratelimiter", LimiterSceneHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/eventdata/", EventDataHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/eventdata", EventDataHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/queryDashboard", QueryDashboardHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/saveDashboard", SaveDashboardHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/deleteDashboard", DeleteDashboardHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/metrics", MetricsConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/queryMetrics", QueryMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/saveWidgets", SaveWidgetsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/queryWidgets", QueryWidgetsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/deleteWidgets", DeleteWidgetsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/queryRelation", QueryDashboardRelationHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dashboard/editRelation", SaveDashboardRelationHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/user/info/", () -> UserinfoApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/user/info", () -> UserinfoApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/appHealthCheck", AppHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/appHealthCheck/", AppHealthCheckHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/appHealthQuery", AppHealthQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/appHealthQuery/", AppHealthQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/appNames", AppNamesHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/appNames/", AppNamesHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/nodeExceptionInfo", ExceptionQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/nodeExceptionInfo/", ExceptionQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/exceptionDatails", ExceptionDetailsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/exceptionDatails/", ExceptionDetailsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/loadBalanceReporter", LoadBalanceReporterHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/loadBalanceReporter/", LoadBalanceReporterHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/indicatorConfig", HealthIndicatorConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/indicatorConfig/", HealthIndicatorConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadpool/getThreadPool", ThreadPoolInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadpool/setThreadPool", ThreadPoolSetHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadpool/proxyGetThreadPool", ThreadPoolInfoProxyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadpool/proxySetThreadPool", ThreadPoolSetProxyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threadpool/taskTest", ThreadPoolTaskHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dlock/", () -> new DLockApiHandler("/eye/dlock/"));
        EyeInstaller.addHandler(server, contextPath + "/eye/dlock", () -> new DLockApiHandler("/eye/dlock"));
        EyeInstaller.addHandler(server, contextPath + "/eye/tenantInfos/", TenantInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tenantInfos", TenantInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/sceneInfos/", SceneInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/sceneInfos", SceneInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dateRange/", DateRangeHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dateRange", DateRangeHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/overViewInfos/", OverViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/overViewInfos", OverViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyOverViewInfos/", HistoryOverViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyOverViewInfos", HistoryOverViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tenantViewData/", TenantViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tenantViewData", TenantViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyTenantViewInfos/", HistoryTenantViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyTenantViewInfos", HistoryTenantViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/sceneViewInfos/", SceneViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/sceneViewInfos", SceneViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historySceneViewInfos/", HistorySceneViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historySceneViewInfos", HistorySceneViewHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/accountInfos/", AccountInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/accountInfos", AccountInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/noSuccessInfos/", NoSuccessInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/noSuccessInfos", NoSuccessInfosHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/searchLog/", SearchLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/searchLog", SearchLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/methodParamsInfos/", MethodParamsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/methodParamsInfos", MethodParamsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/lockedBusinessInfos/", LockedBusinessHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/lockedBusinessInfos", LockedBusinessHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/deleteLockedBusinessInfos/", DeleteLockedBusinessInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/deleteLockedBusinessInfos", DeleteLockedBusinessInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyNotRepairInfos/", HistoryNotRepairHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/historyNotRepairInfos", HistoryNotRepairHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/fileServerManager/server/*", FileServiceMonitorHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/fileServerManager/server", FileServiceMonitorHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/pmmLogin/", PmmLoginHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/pmmLogin", PmmLoginHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/config/dbConfig", DbConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/dbmanager", DataBaseManageHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/dbmonitor/dbmanager/", DataBaseManageHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/config/governConfig", GovernConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/permission/role/", RoleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/permission/role", RoleHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/permission/user/", UserHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/permission/user", UserHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedconfig", UnifiedConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedconfig/", UnifiedConfigHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/opLog/", OpLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/opLog", OpLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/addOp/", AddOpDataHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/addOp", AddOpDataHandler::new);
        if (!enableCloseApi) {
            EyeInstaller.addHandler(server, contextPath + "/eye/thirdauth/", () -> ThirdAuthHandler.instance);
            EyeInstaller.addHandler(server, contextPath + "/eye/thirdauth", () -> ThirdAuthHandler.instance);
        }
        EyeInstaller.addHandler(server, contextPath + "/eye/sso/login/", () -> SsoLoginApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/sso/login", () -> SsoLoginApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/cosmiceyeauth/", () -> CosmiceyeAuthHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/cosmiceyeauth", () -> CosmiceyeAuthHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/hasPermission/", () -> CheckpermissionApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/hasPermission", () -> CheckpermissionApiHandler.instance);
        EyeInstaller.addHandler(server, contextPath + "/eye/listMiddleware/", MiddlewareListApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/listMiddleware", MiddlewareListApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/listDB/", DBListApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/listDB", DBListApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threaddump/", ThreadDumpApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/threaddump", ThreadDumpApiHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/healthcheck/v1", ClusterHealthCheckHandler::new);
        if (!enableCloseApi) {
            EyeInstaller.addHandler(server, contextPath + "/eye/printThreadDump", ThreadDumpOutHandler::new);
        }
        EyeInstaller.addHandler(server, contextPath + "/eye/loadForward", LoadForwardHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/loadForward/", LoadForwardHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/secondAuth/", SecondAuthHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/secondAuth", SecondAuthHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/topology", TopologyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/topology/", TopologyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/serviceInstance/topology", ServiceInstTopologyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/serviceInstance/topology/", ServiceInstTopologyHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/webPort", WebPortHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/tc/*", () -> new TraceResourceHandler("/bos-eye/trd/trace", contextPath + "/eye/tc"));
        EyeInstaller.addHandler(server, contextPath + "/goldeye/temptable", TempTableHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/temptable/", TempTableHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/heartbeat/", HeartBeatHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/heartbeat", HeartBeatHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/getAllCatalog/", MServiceCataLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/getAllCatalog", MServiceCataLogHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/getServiceInfo/", MServiceInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/getServiceInfo", MServiceInfoHandler::new);
        String jmxProxyUrl = contextPath + "/eye/jmxProxy";
        String jmxapiUrl = contextPath + "/goldeye/jmxapi";
        String chartJsonUrl = contextPath + "/goldeye/charts.json";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("jmxapiUrl", jmxapiUrl);
        variables.put("chartJsonUrl", chartJsonUrl);
        variables.put("jmxProxyUrl", jmxProxyUrl);
        EyeInstaller.addHandler(server, contextPath + "/eye/metric", () -> new MetricApiHandler("/metric", variables, "/jmx/web"));
        EyeInstaller.addHandler(server, contextPath + "/eye/metric/*", () -> new MetricApiHandler("/metric", variables, "/jmx/web"));
        EyeInstaller.addHandler(server, contextPath + "/eye/prometheus", ClusterMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/prometheus/", ClusterMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/prometheusmetrics", MetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/prometheusmetrics/", MetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedmetrics/graphDictionary", GraphDictionaryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedmetrics/metaMetrics", UnifiedMetaMetricsHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedmetrics/metaMetricInfo", UnifiedMetricInfoHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/unifiedmetrics/queryMetrics", MetricQueryHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/fileRepair/", CryptFileRepairHandler::new);
        EyeInstaller.addHandler(server, contextPath + "/eye/fileRepair", CryptFileRepairHandler::new);
        EyeInstaller.addHandler(server, chartJsonUrl, ChartJsonHandler::new);
        EyeInstaller.addHandler(server, jmxapiUrl + "/", (HttpHandler)jolokiaHttpHandler);
        EyeInstaller.addHandler(server, contextPath + "/goldeye/connectcharts.json", ConnectPoolChartJsonHandler::new);
        multiServerMap.put((Object)contextPath, server);
    }

    public static synchronized void registyHandler(String uriPath, Supplier<HttpHandler> handlerSupplier) {
        if (!multiServerMap.isEmpty()) {
            for (Map.Entry entry : multiServerMap.asMap().entrySet()) {
                String key = (String)entry.getKey();
                Collection values = (Collection)entry.getValue();
                for (Object value : values) {
                    EyeInstaller.addHandler(value, key + uriPath, handlerSupplier);
                }
            }
        }
    }

    private static void addHandler(Object server, String context, Supplier<HttpHandler> handlerSupplier) {
        HttpHandler handler = exchange -> {
            try {
                HttpHandler lazyHandler = handlerMap.computeIfAbsent(context, arg_0 -> EyeInstaller.lambda$null$30((Supplier)handlerSupplier, arg_0));
                lazyHandler.handle(exchange);
            }
            catch (Exception e) {
                log.error("Monitor handler\u5f02\u5e38:", (Throwable)e);
                throw new KDException(BosErrorCode.bOS, new Object[]{e});
            }
        };
        EyeInstaller.addHandler(server, context, handler);
    }

    private static void addHandler(Object server, String context, HttpHandler handler) {
        if (server instanceof EyeHttpServer) {
            ((EyeHttpServer)server).addHandler(context, handler);
            return;
        }
        if (server instanceof MonitorHttpServer) {
            ((MonitorHttpServer)server).addHandler(context, handler);
            return;
        }
        HttpServerHandler httpServerHandler = (HttpServerHandler)httpServerFactory.getExtension(System.getProperty("webserver.type", "jetty"));
        httpServerHandler.addHandler(server, context, handler);
    }

    private static /* synthetic */ HttpHandler lambda$null$30(Supplier handlerSupplier, String key) {
        return (HttpHandler)handlerSupplier.get();
    }

    static {
        httpServerFactory = ExtensionFactory.getExtensionFacotry(HttpServerHandler.class);
        try {
            EnvUtils.isRunningInsideContainer();
            jolokiaHttpHandler = MonitorInstaller.jolokiaHttpHandler;
            if (jolokiaHttpHandler == null) {
                ArrayList<Object> list = new ArrayList<Object>(4);
                list.add(ConfigKey.AGENT_CONTEXT);
                list.add("/jmx");
                list.add(ConfigKey.POLICY_LOCATION);
                list.add(EyeInstaller.class.getResource("/bos-monitor/jmx/jolokia-restrictions.xml").toString());
                list.add(ConfigKey.AGENT_ID);
                list.add("eye");
                list.add(ConfigKey.DISCOVERY_ENABLED);
                list.add("false");
                Configuration configuration = new Configuration(list.toArray());
                jolokiaHttpHandler = new JolokiaHttpHandler(configuration);
                jolokiaHttpHandler.start(false);
            }
        }
        catch (Exception e) {
            log.error("jolokiaHttpHandler realtime monitor start error", (Throwable)e);
        }
        handlerMap = new ConcurrentHashMap<String, HttpHandler>(8);
    }
}

