/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.eye.EyeServerMain;
import kd.bos.eye.api.alarm.AlarmConfigManager;
import kd.bos.eye.api.alarm.record.task.AlarmRecordTask;
import kd.bos.eye.api.appha.helper.HealthIndicatorConfigHelper;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.armor.config.manager.EyeDegradeRuleManager;
import kd.bos.eye.api.armor.config.manager.EyeFlowRuleManager;
import kd.bos.eye.api.config.manager.DbConfigManager;
import kd.bos.eye.api.config.manager.GovernConfigManager;
import kd.bos.eye.api.config.manager.RpcConfigManager;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.api.dashboard.metrics.commom.ApiMetricsCollector;
import kd.bos.eye.api.dashboard.metrics.query.sessions.OnlineSessionCollector;
import kd.bos.eye.api.flamegraphs.task.FlameGraphWork;
import kd.bos.eye.api.home.TopoHandler;
import kd.bos.eye.api.limiter.manager.LimiterSceneManager;
import kd.bos.eye.api.log.ruleconfig.LoggerRuleMgrService;
import kd.bos.eye.api.oplog.OpLogTaskService;
import kd.bos.eye.api.thread.ThreadDumpParamHook;
import kd.bos.eye.api.thread.entity.NodeInfo;
import kd.bos.eye.api.thread.timeout.service.EyeThreadTimeoutService;
import kd.bos.eye.api.threadpool.ThreadPoolInfoHook;
import kd.bos.eye.api.unifiedmetrics.impl.MetricSpiServiceLoaderImpl;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.govern.eventdata.EventTypeManager;
import kd.bos.govern.timeout.ThreadTimeoutManager;
import kd.bos.govern.timeout.ThreadTimeoutService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class EyeServerService
implements Service {
    private static final Log log = LogFactory.getLog(EyeServerService.class);
    private boolean started = false;

    public String getName() {
        return "EyeServerService";
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        try {
            EyeServerMain.start();
            this.registerEyeExtendedHandler();
            this.startEyeConfigService();
        }
        catch (IOException e) {
            this.started = true;
        }
        this.started = true;
    }

    private void registerEyeExtendedHandler() {
        block3: {
            try {
                Class<?> cls = Class.forName("kd.bos.eye.EyeExtendedHandlerRegister");
                Method registerMethod = cls.getMethod("register", new Class[0]);
                registerMethod.setAccessible(true);
                registerMethod.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                log.warn("registerEyeExtendedHandler failed...");
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (!Boolean.getBoolean("eye.server.start.log")) break block3;
                log.warn(e);
            }
        }
    }

    private void startEyeConfigService() {
        ThreadTimeoutManager.setThreadTimeoutService((ThreadTimeoutService)new EyeThreadTimeoutService());
        ThreadPools.executeOnce((String)"startEyeConfigService-thread", () -> {
            EventTypeManager.init();
            DbConfigManager.initDbConfig();
            LoggerRuleMgrService.registerEyeConfigService();
            RpcConfigManager.registerEyeConfigService();
            GovernConfigManager.registerEyeConfigService();
            EyeFlowRuleManager.registerFlowRuleDataSource();
            EyeDegradeRuleManager.registerDegradeRuleDataSource();
            HealthIndicatorConfigHelper.initIndicatorConfigs();
            UnifiedConfigManager.registerEyeConfigService();
            AlarmConfigManager.registerEyeConfigService();
            OpLogTaskService.registScheduleWork(new AlarmRecordTask(), 60L, 300L, TimeUnit.SECONDS);
            OpLogTaskService.registScheduleWork(new FlameGraphWork(), 60L, TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
            ThreadPoolInfoHook.registerHook();
            MetricSpiServiceLoaderImpl.MetricsStorageConfigHook.registerHook();
            TopoHandler.TopoAnalysisConfigHook.registerHook();
            ThreadDumpParamHook.registerHook();
            OnlineSessionCollector.start();
            ApiMetricsCollector.registerApiMetrics();
            LimiterSceneManager.registerEyeConfigService();
            log.info("EyeConfigService start completed ...");
        });
    }

    public void stop() {
        this.started = false;
    }

    public static ArrayList<EyeNodeInfo> getAllEyeNodes() {
        ArrayList<EyeNodeInfo> list = new ArrayList<EyeNodeInfo>();
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        nodesMap.forEach((k, v) -> {
            try {
                EyeNodeInfo nodeInfo = (EyeNodeInfo)JSONUtils.cast((String)v, EyeNodeInfo.class, (boolean)true);
                list.add(nodeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return list;
    }

    public static ArrayList<NodeInfo> getAllNodes() {
        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        nodesMap.forEach((k, v) -> {
            try {
                NodeInfo nodeInfo = (NodeInfo)JSONUtils.cast((String)v, NodeInfo.class, (boolean)true);
                list.add(nodeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return list;
    }

    public static List<String> getAllInstanceNodes() {
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        ArrayList<String> allNodes = new ArrayList<String>();
        nodesMap.forEach((k, item) -> allNodes.add(k.split("\\(")[0]));
        return allNodes;
    }

    public static List<String> getAllInstanceNodesForCrossCluster(String clusterName) {
        if (Instance.getClusterName().equals(clusterName)) {
            return EyeServerService.getAllInstanceNodes();
        }
        ZooEventifyCenter zooEventify = ZooEventifyCenterFactory.getMessageCenter();
        Map nodesMap = zooEventify.getChildrenForCrossCluster("configUrl", clusterName, clusterName + "/runtime/monitor/nodes");
        ArrayList<String> allNodes = new ArrayList<String>();
        nodesMap.forEach((k, item) -> allNodes.add(k.split("\\(")[0]));
        return allNodes;
    }
}

