/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.security.Key;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class Encrypt {
    private static final String ALGORITHMSTR = "AES/CBC/PKCS5Padding";

    public static String decryptAscii(String password) {
        String[] split;
        StringBuilder pwd = new StringBuilder();
        for (String pwdString : split = password.split("=")) {
            String[] pwdArr = pwdString.split(",");
            byte[] bytes = new byte[pwdArr.length];
            for (int i = 0; i < pwdArr.length; ++i) {
                bytes[i] = (byte)Integer.parseInt(pwdArr[i], 16);
            }
            try {
                pwd.append(new String(bytes, "utf-8"));
            }
            catch (Exception e) {
                return pwd.toString();
            }
        }
        return pwd.toString();
    }

    public static String decryptAes(String password, String key) throws Exception {
        byte[] bytes = StringUtils.isEmpty((String)password) ? null : Base64.decodeBase64((byte[])password.getBytes());
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        Encrypt.checkIv(key);
        byte[] temp = key.getBytes("UTF-8");
        IvParameterSpec iv = new IvParameterSpec(temp);
        cipher.init(2, (Key)new SecretKeySpec(temp, "AES"), iv);
        byte[] decryptBytes = cipher.doFinal(bytes);
        return new String(decryptBytes);
    }

    public static String encryptAes(String password, String key) throws Exception {
        byte[] bytes = StringUtils.isEmpty((String)password) ? null : password.getBytes();
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        Encrypt.checkIv(key);
        byte[] temp = key.getBytes("UTF-8");
        IvParameterSpec iv = new IvParameterSpec(temp);
        cipher.init(1, (Key)new SecretKeySpec(temp, "AES"), iv);
        byte[] encryptBytes = cipher.doFinal(bytes);
        return new String(Base64.encodeBase64((byte[])encryptBytes));
    }

    private static void checkIv(String key) {
        List<Integer> list = Arrays.asList(16, 24, 32);
        if (key == null || list.contains(key.length())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"Illegal IV length! The length of IV must be 16 or 24 or 32"});
        }
    }
}

