/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.instance.Instance;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.xdb.endpoint.EndPointValueChangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPointValueNotifierHelper {
    private static final Logger log = LoggerFactory.getLogger(EndPointValueNotifierHelper.class);
    private static final ThreadPool pool = ThreadPools.newCachedThreadPool((String)"EndPointValueNotifier-thread", (int)0, (int)2);

    public static void endPointFireChange(String key, String value) {
        pool.execute(() -> {
            EndPointValueNotifierHelper.getOrCreateRequestContext();
            List serviceInfos = ServiceInfoFactory.get().getServiceList();
            for (ServiceInfo serviceInfo : serviceInfos) {
                try {
                    if (Instance.getInstanceId().equals(serviceInfo.getInstanceId())) continue;
                    EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)EndPointValueChangeService.class.getName(), (String)"receiveValueChange", (Object[])new Object[]{key, value});
                }
                catch (Exception e) {
                    log.warn("EyeConfigBroadcastHelper broadCast failed,ip:" + serviceInfo.getIp() + " ,key:" + key + ",value:" + value, (Throwable)e);
                }
            }
        });
    }

    private static void getOrCreateRequestContext() {
        RequestContext requestContext = RequestContext.getOrCreate();
        if (requestContext.getTraceId() == null) {
            requestContext.setTraceId(TraceIdUtil.createTraceIdString());
        }
        RequestContextThreadBinder.bind((RequestContext)requestContext);
    }
}

