/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.eye.util.ApiRequest;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.util.JSONUtils;

public class ExchangeVueUtils {
    private static final String DEFAULT_CHARSET = "utf-8";

    public static void redirect(HttpExchange exchange, String url) throws IOException {
        exchange.getResponseHeaders().add("Location", url);
        exchange.sendResponseHeaders(301, -1L);
        exchange.close();
    }

    public static Map<String, String> parseParameters(HttpExchange exchange) throws IOException {
        if ("post".equalsIgnoreCase(exchange.getRequestMethod())) {
            return ExchangeVueUtils.parsePostParameters(exchange);
        }
        return ExchangeVueUtils.parseGetParameters(exchange);
    }

    private static Map<String, String> parseGetParameters(HttpExchange exchange) {
        URI uri = exchange.getRequestURI();
        String query = uri.getQuery();
        return EyeUriQuery.toMap(query);
    }

    public static ApiRequest parsePostJson(HttpExchange exchange, Class t) throws IOException, IllegalAccessException, InstantiationException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), DEFAULT_CHARSET);
        String query = CharStreams.toString((Readable)isr);
        String str = StringUtils.trimToNull((String)query);
        return str == null ? null : (ApiRequest)SerializationUtils.fromJsonString((String)str, (Class)t);
    }

    public static <T> T parseJsonFromPost(HttpExchange exchange, Class<T> t) throws IOException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), DEFAULT_CHARSET);
        String query = CharStreams.toString((Readable)isr);
        String str = StringUtils.trimToNull((String)query);
        return (T)(str == null ? null : SerializationUtils.fromJsonString((String)str, t));
    }

    public static <T> T parseJsonFromPost(HttpExchange exchange, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), DEFAULT_CHARSET);
        String query = CharStreams.toString((Readable)isr);
        String str = StringUtils.trimToNull((String)query);
        return (T)(str == null ? null : JSONUtils.cast((String)str, collectionType, (Class[])elementType));
    }

    public static Map<String, String> parsePostParameters(HttpExchange exchange) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), DEFAULT_CHARSET);
        String query = CharStreams.toString((Readable)isr);
        ExchangeVueUtils.parseQuery(query, parameters);
        return parameters;
    }

    private static void parseQuery(String query, Map<String, String> parameters) throws UnsupportedEncodingException {
        if (query != null) {
            String[] pairs = query.split("[&]");
            String encoding = System.getProperty("file.encoding");
            for (String pair : pairs) {
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], encoding);
                }
                if (param.length > 1) {
                    value = URLDecoder.decode(param[1], encoding);
                }
                parameters.put(key, value);
            }
        }
    }
}

