/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class EyeHttpClients {
    private static final int default_connectionTimeout = 3000;
    private static final int default_readTimeout = 5000;
    private static final String SCHEME_HTTPS = "https";
    private static final String X_GZIP = "x-gzip";
    private static final Log logger = LogFactory.getLog(EyeHttpClients.class);

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build()).build();
        return client;
    }

    public static HttpClient wrapperHttpClient(HttpClient client) {
        if (client == null) {
            client = EyeHttpClients.createHttpClient(3000, 5000);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme(SCHEME_HTTPS, 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, client.getParams());
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder(LangRes.get((String)"EyeCommon_0", (String)"Failed to package without certificate verification client:", (Object[])new Object[0]));
            sb.append(ex.getMessage());
            return null;
        }
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return EyeHttpClients.post(url, header, body, 3000, 5000);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        HttpClient clients = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost httpPosts = new HttpPost(url);
        URI uri = httpPosts.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (clients = EyeHttpClients.wrapperHttpClient(clients)) == null) {
            return data;
        }
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> httpPosts.setHeader(key, value));
            }
            if (body != null && body.size() != 0) {
                ArrayList params = new ArrayList(body.size());
                body.forEach((key, value) -> params.add(new BasicNameValuePair(key, value.toString())));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                httpPosts.setEntity((HttpEntity)entity);
            }
            if ((response = clients.execute((HttpUriRequest)httpPosts)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 202) {
                HttpEntity httpRespEntity = response.getEntity();
                Header httpRespHeader = httpRespEntity.getContentEncoding();
                if (httpRespHeader != null && ("gzip".equalsIgnoreCase(httpRespHeader.getValue()) || X_GZIP.equalsIgnoreCase(httpRespHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(httpRespEntity);
                    InputStream in = gzipEntity.getContent();
                    data = EyeHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)httpRespEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("post error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            httpPosts.releaseConnection();
            if (clients instanceof CloseableHttpClient) {
                ((CloseableHttpClient)clients).close();
            }
        }
        return data;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return EyeHttpClients.postjson(url, header, json, 3000, 5000);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String resultData = "";
        HttpClient httpClients = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (httpClients = EyeHttpClients.wrapperHttpClient(httpClients)) == null) {
            return resultData;
        }
        try {
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> post.setHeader(key, value));
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = httpClients.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 202) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || X_GZIP.equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    resultData = EyeHttpClients.getHTMLContent(in);
                } else {
                    resultData = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("url: [" + url + "] get error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
            if (httpClients instanceof CloseableHttpClient) {
                ((CloseableHttpClient)httpClients).close();
            }
        }
        return resultData;
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return EyeHttpClients.postAppJson(url, header, body, 3000, 5000);
    }

    public static String postAppJson(String url, Map<String, String> header1, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "application/json;";
        String data = "";
        HttpClient httpClient1 = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post1 = new HttpPost(url);
        URI uri1 = post1.getURI();
        if (SCHEME_HTTPS.equals(uri1.getScheme()) && (httpClient1 = EyeHttpClients.wrapperHttpClient(httpClient1)) == null) {
            return data;
        }
        try {
            if (header1 != null && header1.size() != 0) {
                header1.forEach((key, value) -> post1.setHeader(key, value));
            }
            String jsEntity = "{}";
            if (body != null) {
                jsEntity = JSONUtils.toString(body);
            }
            StringEntity se1 = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se1.setContentType("application/json;");
            post1.setEntity((HttpEntity)se1);
            HttpResponse response1 = httpClient1.execute((HttpUriRequest)post1);
            if (response1.getStatusLine().getStatusCode() == 200 || response1.getStatusLine().getStatusCode() == 202) {
                HttpEntity resEntity = response1.getEntity();
                Header respHeader1 = resEntity.getContentEncoding();
                if (respHeader1 != null && ("gzip".equalsIgnoreCase(respHeader1.getValue()) || X_GZIP.equalsIgnoreCase(respHeader1.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = EyeHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("post error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            post1.releaseConnection();
            if (httpClient1 instanceof CloseableHttpClient) {
                ((CloseableHttpClient)httpClient1).close();
            }
        }
        return data;
    }

    public static String get(String url) throws Exception {
        return EyeHttpClients.get(url, 3000, 5000);
    }

    public static String get(String url, int connectionTimeout, int readTimeout) throws Exception {
        return HttpClientUtils.get((String)url, (int)connectionTimeout, (int)readTimeout);
    }

    public static String get(String url, Map<String, String> headers, int connectionTimeout, int readTimeout) throws IOException {
        String content;
        String bodyStr = "";
        HttpClient client = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        try {
            String destUrlStr = StringUtils.isEmpty((String)bodyStr) ? url : url + "?" + bodyStr;
            HttpGet request = new HttpGet(destUrlStr);
            if (headers != null && headers.size() != 0) {
                headers.forEach((key, value) -> request.setHeader(key, value));
            }
            HttpResponse response = client.execute((HttpUriRequest)request);
            StringBuilder sb = new StringBuilder();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try (InputStream inputStream = entity.getContent();
                     InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                     BufferedReader in = new BufferedReader(streamReader);){
                    String line;
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            content = sb.toString();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
        return content;
    }

    private static String getHTMLContent(InputStream in) {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(in);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    public static String putjson(String url, Map<String, String> header, String json) throws IOException {
        return EyeHttpClients.putjson(url, header, json, 3000, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPut httpPut = new HttpPut(url);
        String data = "";
        try {
            HttpResponse hResponse;
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> httpPut.setHeader(key, value));
            }
            if (!StringUtils.isEmpty((String)json)) {
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                httpPut.setEntity((HttpEntity)se);
            }
            if ((hResponse = client.execute((HttpUriRequest)httpPut)).getStatusLine().getStatusCode() == 200 || hResponse.getStatusLine().getStatusCode() == 202) {
                HttpEntity resEntity = hResponse.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || X_GZIP.equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = EyeHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            String string = data;
            return string;
        }
        finally {
            httpPut.releaseConnection();
            if (client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
        return data;
    }

    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas, int connectionTimeout, int readTimeout) throws IOException {
        HttpClient hClient = EyeHttpClients.createHttpClient(connectionTimeout, readTimeout);
        try {
            HttpPost hPost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> string : headers.entrySet()) {
                    hPost.setHeader(string.getKey(), string.getValue());
                }
            }
            try {
                MultipartEntity reqEntity = new MultipartEntity();
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        if (e.getValueInputStream() != null) {
                            reqEntity.addPart(e.getKey(), (ContentBody)new InputStreamBody(e.getValueInputStream(), e.getFileName()));
                            continue;
                        }
                        reqEntity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString()));
                    }
                }
                hPost.setEntity((HttpEntity)reqEntity);
                HttpResponse httpResponse = hClient.execute((HttpUriRequest)hPost);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = httpResponse.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
        }
        finally {
            hClient.getConnectionManager().shutdown();
            if (hClient instanceof CloseableHttpClient) {
                ((CloseableHttpClient)hClient).close();
            }
        }
        return null;
    }

    public static class FormDataEntity {
        private final String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

