/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import com.sun.net.httpserver.HttpExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class EyeUrlUtils {
    private static final String CONTEXT_IERP = "/ierp";
    private static final String HTTPS = "https";
    private static final String UTF8 = "UTF-8";

    public static String getHomeUrl(HttpExchange exchange, String context) {
        String url = System.getProperty("monitor.urlcontext");
        if (url == null) {
            url = System.getProperty("monitor.url");
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if (context != null) {
                url = url + context;
            }
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url;
        }
        url = exchange.getRequestURI().getRawPath();
        if (url.endsWith("/monitor")) {
            url = url + "/";
        }
        url = url.substring(0, url.lastIndexOf(47) + 1);
        return url;
    }

    public static String getMonitorRootUrl(HttpExchange exchange) {
        String url = exchange.getRequestURI().toString();
        if (url.startsWith(CONTEXT_IERP)) {
            url = url.substring(5);
        }
        int pos = url.indexOf("/monitor");
        url = url.substring(0, pos) + "/";
        return EyeUrlUtils.getFullHostUrl(exchange) + url;
    }

    public static String getMonitorUriContext(HttpExchange exchange) {
        String url = exchange.getRequestURI().toString();
        if (url.startsWith(CONTEXT_IERP)) {
            return CONTEXT_IERP;
        }
        return "";
    }

    public static String getContext(HttpExchange exchange) {
        String url = EyeUrlUtils.getFullHostUrl(exchange);
        String context = exchange.getRequestURI().getPath();
        if (context.startsWith(CONTEXT_IERP)) {
            context = context.substring(CONTEXT_IERP.length());
        }
        return url + context;
    }

    private static String getFullHostUrl(HttpExchange exchange) {
        String url = System.getProperty("monitor.urlcontext");
        if (url != null) {
            return url;
        }
        String host = exchange.getRequestHeaders().getFirst("host");
        String context = exchange.getRequestHeaders().getFirst("context");
        String protocol = null;
        String s = exchange.getRequestHeaders().getFirst(HTTPS);
        boolean https = false;
        https = s != null ? "1".equals(s) : exchange.getProtocol().toLowerCase().contains(HTTPS);
        protocol = https ? HTTPS : "http";
        url = protocol + "://" + host;
        if (context != null) {
            url = context.startsWith("/") ? url + context : url + "/" + context;
        }
        return url;
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeProxy(String uri, String proxyurl) {
        if (proxyurl == null) {
            return uri;
        }
        try {
            String url = URLEncoder.encode(uri, UTF8);
            url = proxyurl + "?url=" + url;
            return url;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeProxy0(String uri, String proxyurl) {
        if (proxyurl == null) {
            return uri;
        }
        proxyurl = proxyurl + "0";
        try {
            String url = URLEncoder.encode(uri, UTF8);
            url = proxyurl + "?url=" + url;
            return url;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

