/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContextCreator;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpClients {
    private static Logger logger = LoggerFactory.getLogger(HttpClients.class);
    private static int default_connectionTimeout = 3000;
    private static int default_readTimeout = 5000;
    private static String SCHEME_HTTPS = "https";

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build()).build();
        return client;
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClients.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> headerMap, Map<String, Object> bodyMap, int connectionTimeout, int readTimeout) throws IOException {
        String retData = "";
        HttpClient httpClient = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost httpPost = new HttpPost(url);
        URI u = httpPost.getURI();
        if (SCHEME_HTTPS.equals(u.getScheme()) && (httpClient = HttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout)) == null) {
            return retData;
        }
        try {
            HttpResponse resp;
            if (headerMap != null && headerMap.size() != 0) {
                headerMap.forEach((k, v) -> httpPost.setHeader(k, v));
            }
            if (bodyMap != null && bodyMap.size() != 0) {
                ArrayList params = new ArrayList(bodyMap.size());
                bodyMap.forEach((key, value) -> params.add(new BasicNameValuePair(key, value.toString())));
                UrlEncodedFormEntity urlEntity = new UrlEncodedFormEntity(params, "UTF-8");
                httpPost.setEntity((HttpEntity)urlEntity);
            }
            if ((resp = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = resp.getEntity();
                Header header = resEntity.getContentEncoding();
                if (header != null && ("gzip".equalsIgnoreCase(header.getValue()) || "x-gzip".equalsIgnoreCase(header.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream inputStream = gzipEntity.getContent();
                    retData = HttpClients.getHTMLContent(inputStream);
                } else {
                    retData = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            httpPost.releaseConnection();
        }
        return retData;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HttpClients.postjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postjson(String url, Map<String, String> hMap, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String returnData = "";
        HttpClient cli = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost hPost = new HttpPost(url);
        URI postURI = hPost.getURI();
        if (SCHEME_HTTPS.equals(postURI.getScheme()) && (cli = HttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout)) == null) {
            return returnData;
        }
        try {
            if (hMap != null && hMap.size() != 0) {
                hMap.forEach((key, value) -> hPost.setHeader(key, value));
            }
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            entity.setContentType("text/json;");
            hPost.setEntity((HttpEntity)entity);
            HttpResponse response = cli.execute((HttpUriRequest)hPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header resHeader = resEntity.getContentEncoding();
                if (resHeader != null && ("gzip".equalsIgnoreCase(resHeader.getValue()) || "x-gzip".equalsIgnoreCase(resHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream input = gzipEntity.getContent();
                    returnData = HttpClients.getHTMLContent(input);
                } else {
                    returnData = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            hPost.releaseConnection();
        }
        return returnData;
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClients.postAppJson(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "application/json;";
        String data = "";
        HttpClient client = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout)) == null) {
            return data;
        }
        try {
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> post.setHeader(key, value));
            }
            String jsEntity = "{}";
            if (body != null) {
                jsEntity = JSONUtils.toString(body);
            }
            StringEntity se = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se.setContentType("application/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String get(String url) throws IOException, URISyntaxException {
        return HttpClients.get(url, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, int connectionTimeout, int readTimeout) throws IOException, URISyntaxException {
        String content;
        HttpClient client = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpGet request = new HttpGet();
        request.setURI(new URI(url));
        HttpResponse response = client.execute((HttpUriRequest)request);
        try (InputStreamReader streamReader = new InputStreamReader(response.getEntity().getContent());
             BufferedReader in = new BufferedReader(streamReader);){
            String line;
            StringBuilder sb = new StringBuilder();
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line).append(NL);
            }
            content = sb.toString();
        }
        return content;
    }

    public static String get(String url, Map<String, String> headers, int connectionTimeout, int readTimeout) throws IOException {
        String content;
        String strBody = "";
        try {
            String destUrl = StringUtils.isEmpty((String)strBody) ? url : url + "?" + strBody;
            HttpClient client = HttpClients.createHttpClient(connectionTimeout, readTimeout);
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                headers.forEach((key, value) -> request.setHeader(key, value));
            }
            StringBuilder sb = new StringBuilder();
            request.setURI(new URI(destUrl));
            HttpResponse response = client.execute((HttpUriRequest)request);
            try (InputStreamReader streamReader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
                 BufferedReader in = new BufferedReader(streamReader);){
                String line;
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line).append(NL);
                }
            }
            content = sb.toString();
        }
        catch (IOException | URISyntaxException e) {
            throw new IOException(e);
        }
        return content;
    }

    private static String getHTMLContent(InputStream in) {
        OperationContextCreator.getOrCreateForBos();
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(in);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error("getHTMLContent error", (Throwable)e);
        }
        return sb.toString();
    }

    public static String putjson(String url, Map<String, String> header, String json) {
        return HttpClients.putjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPut httpput = new HttpPut(url);
        String data = "";
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> httpput.setHeader(key, value));
            }
            if (!StringUtils.isEmpty((String)json)) {
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                httpput.setEntity((HttpEntity)se);
            }
            if ((response = client.execute((HttpUriRequest)httpput)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            OperationContextCreator.getOrCreateForBos();
            logger.error("Http putjson error", (Throwable)ex);
        }
        finally {
            httpput.releaseConnection();
        }
        return data;
    }

    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headersMap, List<FormDataEntity> formDatas, int connectionTimeout, int readTimeout) {
        HttpClient httpclient = HttpClients.createHttpClient(connectionTimeout, readTimeout);
        try {
            HttpPost post = new HttpPost(url);
            if (headersMap != null && headersMap.size() > 0) {
                for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            try {
                MultipartEntity multipartEntity = new MultipartEntity();
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        if (e.getValueInputStream() != null) {
                            multipartEntity.addPart(e.getKey(), (ContentBody)new InputStreamBody(e.getValueInputStream(), e.getFileName()));
                            continue;
                        }
                        multipartEntity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString()));
                    }
                }
                post.setEntity((HttpEntity)multipartEntity);
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = httpResponse.getEntity();
                    String resultStr = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = resultStr;
                    return string;
                }
            }
            catch (IOException e) {
                OperationContextCreator.getOrCreateForBos();
                logger.error("Failed to post formdata.", (Throwable)e);
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static class FormDataEntity {
        private String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

