/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.nacos;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.nacos.RegistryNotifier;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.dubbo.DubboProtocol;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.mservice.rpc.dubbo.registry.registryService.nacos.NacosRegistryConfig;
import kd.bos.mservice.rpc.dubbo.registry.registryService.nacos.NacosRegistryService;
import kd.bos.mservice.rpc.dubbo.rpc.RequestStatus;

public class NacosRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(NacosRegistry.class);
    private static final String DEFAULT_PROTOCOL = "dubbo";
    private static final String ADDRESS_KEY = "address";
    private static final String ADDRESS_INSTANCE_ID_KEY = "address_instance_id";
    private static final String SERVICE_NAME_SEPARATOR = "@@";
    private final SecureRandom random = new SecureRandom();
    private final AtomicLong index = new AtomicLong(this.random.nextInt(1000));
    private final ConcurrentMap<String, EventListener> nacosListeners = new ConcurrentHashMap<String, EventListener>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, (ThreadFactory)new NamedThreadFactory("nacos-refresh-instances-task", true));
    private final ConcurrentMap<String, ConsumerUrlNode> serviceNameMap = new ConcurrentHashMap<String, ConsumerUrlNode>();
    private final long nextQueryTime = TimeUnit.SECONDS.toMillis(20L);
    private final TimeUnit nextQueryTimeUnit = TimeUnit.MILLISECONDS;
    private final LinkedBlockingQueue<URL> registerQueue = new LinkedBlockingQueue(10000);
    private final int div = Integer.getInteger("dubbo.failregister.interval", 60) / 5;
    private static final boolean isAddGroupInCategoryPath = Boolean.parseBoolean(System.getProperty("dubbo.registry.category.withgourp", "true"));

    public NacosRegistry(URL url) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        this.doRegisterQueue();
        this.queryRegistryInstance();
    }

    @Override
    protected void doUnregister(URL url) {
        try {
            NacosRegistryService.getNamingService().deregisterInstance(this.toServiceName(url, url.getParameter("side")), url.getParameter("group"), this.getNacosInstance(url));
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to unregister " + url + " to nacos " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        try {
            if (this.isAvailable()) {
                String parameter = url.getParameter("group");
                if (parameter == null) {
                    url = url.addParameter("group", "DEFAULT_GROUP");
                }
                String serviceName = this.toServiceName(url, "provider");
                if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
                    this.doSubscribe(url, listener, serviceName);
                }
            }
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to subscribe " + url + " to nacos:" + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    protected void doSubscribe(URL url, NotifyListener notifyListener, String serviceName) {
        try {
            List instances;
            String parameter = url.getParameter("group");
            if (parameter == null) {
                url = url.addParameter("group", "DEFAULT_GROUP");
            }
            if (CollectionUtils.isEmpty((Collection)(instances = NacosRegistryService.getNamingService().getAllInstances(serviceName, url.getParameter("group"))))) {
                throw new RpcException("not exists health instances about serviceName:" + serviceName);
            }
            List<URL> providerUrls = this.notifySubscriber(url, notifyListener, instances);
            this.saveLocalCachedMap(serviceName, url, notifyListener, providerUrls);
            this.subscribeEventListener(serviceName, url, notifyListener);
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to subscribe " + url + " to nacos:" + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private void saveLocalCachedMap(String serviceName, URL url, NotifyListener notifyListener, List<URL> providerUrls) {
        HashMap<String, String> instanceIdMap = new HashMap<String, String>(8);
        for (URL providerUrl : providerUrls) {
            instanceIdMap.put(providerUrl.getAddress() + providerUrl.getParameter("default.instance.id"), null);
        }
        this.serviceNameMap.put(url.getParameter("group") + SERVICE_NAME_SEPARATOR + serviceName, new ConsumerUrlNode(url, instanceIdMap, notifyListener));
    }

    private void subscribeEventListener(String serviceName, URL url, NotifyListener listener) throws NacosException {
        EventListener eventListener = this.nacosListeners.computeIfAbsent(serviceName, k -> new RegistryChildListenerImpl(serviceName, url, listener));
        NacosRegistryService.getNamingService().subscribe(serviceName, url.getParameter("group"), eventListener);
    }

    private List<URL> notifySubscriber(URL url, NotifyListener listener, Collection<com.alibaba.nacos.api.naming.pojo.Instance> instances) {
        List<URL> urls = this.toUrlWithEmpty(url, instances);
        this.notify(url, listener, urls);
        return urls;
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        try {
            NacosRegistryService.getNamingService().unsubscribe(this.toServiceName(url, "provider"), url.getParameter("group"), event -> {
                if (event instanceof NamingEvent) {
                    NamingEvent e = (NamingEvent)event;
                    List instances = e.getInstances();
                    for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
                        ConsumerUrlNode consumerUrlNode = (ConsumerUrlNode)this.serviceNameMap.get(this.buildURL(instance));
                        if (consumerUrlNode == null) continue;
                        this.destroyInvalidInstance(instance);
                        logger.info("success destroy instance:" + instance);
                    }
                }
            });
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to subscribe " + url + " to nacos:" + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private String toServicePath(URL url, String root) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return "/";
        }
        String group = url.getParameter("group");
        if (isAddGroupInCategoryPath && group != null && group.length() > 0) {
            return root + ":" + group + ":" + URL.encode(name);
        }
        return root + ":" + URL.encode(name);
    }

    private String toServiceName(URL url, String root) {
        return this.toServicePath(url, root);
    }

    @Override
    protected void checkProviderNodeExists() {
        HashSet recoverRegistered = new HashSet(this.getRegistered());
        if (Instance.isPausedServiceByMonitor()) {
            recoverRegistered.forEach(url -> this.doUnregister((URL)url));
        } else if (this.index.incrementAndGet() % (long)this.div == 0L) {
            recoverRegistered.forEach(url -> {
                if (RequestStatus.isAppRequestFrequency(url.getParameter("group")) || this.random.nextInt(100) % 10 == 0) {
                    this.doRegister((URL)url);
                    LockSupport.parkNanos(10000000L);
                }
            });
        }
    }

    @Override
    protected void doRegister(URL url) {
        try {
            String parameter = url.getParameter("group");
            if (parameter == null) {
                url = url.addParameter("group", "DEFAULT_GROUP");
            }
            if (this.registerQueue.remainingCapacity() < 10) {
                logger.warn("doRegister queue is full and will remove some of the queue");
                int max = this.registerQueue.size() / 2;
                for (int i = 0; i < max; ++i) {
                    this.registerQueue.poll();
                }
            }
            this.registerQueue.put(url);
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to register " + url + " to nacos " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    protected void doRegisterInstance(URL url) {
        try {
            if (this.isAvailable()) {
                NacosRegistryService.getNamingService().registerInstance(this.toServiceName(url, url.getParameter("side")), url.getParameter("group"), this.getNacosInstance(url));
            }
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to register " + url + " to nacos " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private com.alibaba.nacos.api.naming.pojo.Instance getNacosInstance(URL url) {
        com.alibaba.nacos.api.naming.pojo.Instance instance = new com.alibaba.nacos.api.naming.pojo.Instance();
        instance.setIp(url.getIp());
        instance.setPort(url.getPort());
        instance.setWeight((double)NacosRegistryConfig.getWeight());
        instance.setClusterName(NacosRegistryConfig.getClusterName());
        instance.setEnabled(NacosRegistryConfig.isInstanceEnabled());
        Map<String, String> metadata = NacosRegistryConfig.getMetadata();
        metadata.put(ADDRESS_KEY, url.getAddress());
        metadata.put("path", url.getPath());
        String appId = url.getParameter("group");
        metadata.put("group", url.getParameter("group"));
        metadata.put("default.instance.id", url.getParameter("default.instance.id"));
        metadata.put(ADDRESS_INSTANCE_ID_KEY, url.getAddress() + url.getParameter("default.instance.id"));
        if (appId != null) {
            metadata.put("appgroup", AppGroup.getRegistyAppGroup((String)appId));
        }
        instance.setMetadata(metadata);
        instance.setEphemeral(NacosRegistryConfig.isEphemeral());
        return instance;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.serviceNameMap.clear();
            NacosRegistryService.getNamingService().shutDown();
        }
        catch (Exception e) {
            logger.warn("Failed to close nacos client " + this.getUrl() + ", cause:" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAvailable() {
        return "UP".equals(NacosRegistryService.getNamingService().getServerStatus());
    }

    public List<URL> lookup(URL url) {
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            List instances = NacosRegistryService.getNamingService().getAllInstances(this.toServiceName(url, "provider"), url.getParameter("group"));
            urls.addAll(this.buildURLs(url, instances));
            return urls;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to lookup " + url + " from nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    public void doReSubscribeIfNecessary() {
        boolean reSubscribe = false;
        ConcurrentMap<String, ConsumerUrlNode> nodeMap = this.serviceNameMap;
        for (String key : nodeMap.keySet()) {
            try {
                List instances = NacosRegistryService.getNamingService().getAllInstances(key.split(SERVICE_NAME_SEPARATOR)[1], key.split(SERVICE_NAME_SEPARATOR)[0]);
                if (!this.existsValidInstance(instances) && this.isMatch(((ConsumerUrlNode)nodeMap.get(key)).getInstanceIdMap(), instances)) continue;
                reSubscribe = true;
                this.clearLocalValidClientMap(((ConsumerUrlNode)nodeMap.get(key)).getInstanceIdMap());
            }
            catch (NacosException e) {
                logger.error("query nacos instances error", (Throwable)e);
            }
        }
        if (reSubscribe) {
            for (String key : nodeMap.keySet()) {
                String serviceName = this.toServiceName(((ConsumerUrlNode)nodeMap.get(key)).getConsumerUrl(), "provider");
                try {
                    this.doSubscribe(((ConsumerUrlNode)nodeMap.get(key)).getConsumerUrl(), ((ConsumerUrlNode)nodeMap.get(key)).getNotifyListener(), serviceName);
                }
                catch (Exception e) {
                    logger.error("Failed to subscribe " + ((ConsumerUrlNode)nodeMap.get(key)).getConsumerUrl() + " to nacos:" + this.getUrl() + ", cause: " + e.getMessage());
                }
            }
        }
    }

    private boolean isMatch(Map<String, String> map, List<com.alibaba.nacos.api.naming.pojo.Instance> instances) {
        if (map == null) {
            return !CollectionUtils.isNotEmpty(instances);
        }
        if (map.size() != instances.size()) {
            return false;
        }
        for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
            if (map.containsKey(instance.getMetadata().get(ADDRESS_INSTANCE_ID_KEY))) continue;
            return false;
        }
        return true;
    }

    private List<URL> toUrlWithEmpty(URL consumerURL, Collection<com.alibaba.nacos.api.naming.pojo.Instance> instances) {
        List<URL> urls = this.buildURLs(consumerURL, instances);
        if (urls.isEmpty()) {
            URL empty = consumerURL.setProtocol("empty").addParameter("category", consumerURL.getParameter("category"));
            urls.add(empty);
        }
        return urls;
    }

    private List<URL> buildURLs(URL consumerURL, Collection<com.alibaba.nacos.api.naming.pojo.Instance> instances) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (instances != null && instances.size() > 0) {
            for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
                URL url = this.buildURL(instance);
                if (!UrlUtils.isMatch(consumerURL, url)) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private URL buildURL(com.alibaba.nacos.api.naming.pojo.Instance instance) {
        URL url = new URL(DEFAULT_PROTOCOL, instance.getIp(), instance.getPort(), (String)instance.getMetadata().get("path"), instance.getMetadata()).addParameter("buildTime", System.currentTimeMillis());
        return url;
    }

    private void doRegisterQueue() {
        this.scheduler.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        URL url;
                        if ((url = this.registerQueue.take()) == null) {
                            continue;
                        }
                        this.doRegisterInstance(url);
                    }
                }
                catch (Error | Exception e) {
                    logger.error("register provider from queue fail", e);
                    continue;
                }
                break;
            }
        });
    }

    private void queryRegistryInstance() {
        QueryInstancesTask queryInstancesTask = new QueryInstancesTask();
        this.scheduler.schedule(queryInstancesTask, this.nextQueryTime, this.nextQueryTimeUnit);
    }

    private boolean existsValidInstance(List<com.alibaba.nacos.api.naming.pojo.Instance> instances) {
        for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
            if (!this.isAvailableInstance(instance) || !this.isNeedReSubscribeInstance(instance)) continue;
            return true;
        }
        return false;
    }

    private boolean isAvailableInstance(com.alibaba.nacos.api.naming.pojo.Instance instance) {
        return instance.isHealthy() && instance.isEnabled();
    }

    private boolean isNeedReSubscribeInstance(com.alibaba.nacos.api.naming.pojo.Instance instance) {
        URL url = this.buildURL(instance);
        return DubboProtocol.getDubboProtocol().existExchangeClient(url) && !DubboProtocol.getDubboProtocol().exchangeClientIsConnected(url) || !DubboProtocol.getDubboProtocol().existExchangeClient(url);
    }

    private void destroyInvalidInstance(com.alibaba.nacos.api.naming.pojo.Instance instance) {
        DubboProtocol.getDubboProtocol().doRemoveLocalCachedClientIfNecessary((String)instance.getMetadata().get(ADDRESS_INSTANCE_ID_KEY));
    }

    private void clearLocalValidClientMap(Map<String, String> instanceIdMap) {
        if (instanceIdMap == null) {
            return;
        }
        DubboProtocol.getDubboProtocol().clearValidReferenceClientMap(instanceIdMap);
    }

    private static class ConsumerUrlNode {
        private URL consumerUrl;
        private Map<String, String> instanceIdMap;
        private NotifyListener notifyListener;

        public ConsumerUrlNode(URL consumerUrl, Map<String, String> instanceIdMap, NotifyListener notifyListener) {
            this.consumerUrl = consumerUrl;
            this.instanceIdMap = instanceIdMap;
            this.notifyListener = notifyListener;
        }

        public URL getConsumerUrl() {
            return this.consumerUrl;
        }

        public Map<String, String> getInstanceIdMap() {
            return this.instanceIdMap;
        }

        public NotifyListener getNotifyListener() {
            return this.notifyListener;
        }
    }

    private final class QueryInstancesTask
    implements Runnable {
        private QueryInstancesTask() {
        }

        @Override
        public void run() {
            NacosRegistry.this.doReSubscribeIfNecessary();
            NacosRegistry.this.scheduler.schedule(this, NacosRegistry.this.nextQueryTime, NacosRegistry.this.nextQueryTimeUnit);
        }
    }

    private class RegistryChildListenerImpl
    implements EventListener {
        private final RegistryNotifier notifier;
        private final String serviceName;
        private final URL consumerUrl;
        private final NotifyListener listener;

        public RegistryChildListenerImpl(String serviceName, URL consumerUrl, NotifyListener listener) {
            this.serviceName = serviceName;
            this.consumerUrl = consumerUrl;
            this.listener = listener;
            this.notifier = new RegistryNotifier(){

                @Override
                protected void doNotify(Object rawAddresses) {
                    NacosRegistry.this.doReSubscribeIfNecessary();
                }
            };
        }

        public void onEvent(Event event) {
            if (event instanceof NamingEvent) {
                NamingEvent e = (NamingEvent)event;
                this.notifier.notify(e.getInstances());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryChildListenerImpl that = (RegistryChildListenerImpl)o;
            return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.consumerUrl, that.consumerUrl) && Objects.equals(this.listener, that.listener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.consumerUrl, this.listener);
        }
    }
}

