/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support.header;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.ExchangeChannel;
import com.alibaba.dubbo.remoting.exchange.ExchangeHandler;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.remoting.exchange.support.DefaultFuture;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcStatus;
import java.net.InetSocketAddress;
import kd.bos.mservice.rpc.handshake.entity.HandShakeException;
import kd.bos.mservice.rpc.handshake.entity.HandShakeRequest;
import kd.bos.mservice.rpc.handshake.entity.HandShakeResponse;
import kd.bos.mservice.rpc.handshake.entity.HandShakeStatus;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

final class HeaderExchangeChannel
implements ExchangeChannel {
    private static final Logger logger = LoggerFactory.getLogger(HeaderExchangeChannel.class);
    private static final String CHANNEL_KEY = HeaderExchangeChannel.class.getName() + ".CHANNEL";
    private final Channel channel;
    private volatile boolean closed = false;

    HeaderExchangeChannel(Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        this.channel = channel;
    }

    static HeaderExchangeChannel getOrAddChannel(Channel ch) {
        if (ch == null) {
            return null;
        }
        HeaderExchangeChannel ret = (HeaderExchangeChannel)ch.getAttribute(CHANNEL_KEY);
        if (ret == null) {
            ret = new HeaderExchangeChannel(ch);
            if (ch.isConnected()) {
                ch.setAttribute(CHANNEL_KEY, (Object)ret);
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(Channel ch) {
        if (ch != null && !ch.isConnected()) {
            ch.removeAttribute(CHANNEL_KEY);
        }
    }

    public void send(Object message) throws RemotingException {
        this.send(message, this.getUrl().getParameter("sent", false));
    }

    public void send(Object message, boolean sent) throws RemotingException {
        if (this.closed) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send message " + message + ", cause: The channel " + this + " is closed!");
        }
        if (message instanceof Request || message instanceof Response || message instanceof String) {
            this.channel.send(message, sent);
        } else {
            Request request = new Request();
            request.setVersion("2.0.0");
            request.setTwoWay(false);
            request.setData(message);
            this.channel.send((Object)request, sent);
        }
    }

    public ResponseFuture request(Object request) throws RemotingException {
        return this.request(request, this.channel.getUrl().getPositiveParameter("timeout", 1000));
    }

    public ResponseFuture request(Object request, int timeout) throws RemotingException {
        if (this.closed) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send request " + request + ", cause: The channel " + this + " is closed!");
        }
        this.handShakeBeforeRequest(request);
        Request req = new Request();
        req.setVersion("2.0.0");
        req.setTwoWay(true);
        req.setData(request);
        String customTimeout = RpcContext.getContext().getAttachment("customRpcTimeout");
        timeout = customTimeout != null ? Integer.parseInt(customTimeout) : timeout;
        DefaultFuture future = new DefaultFuture(this.channel, req, timeout);
        try {
            this.channel.send((Object)req);
        }
        catch (RemotingException e) {
            future.cancel();
            throw e;
        }
        return future;
    }

    private void handShakeBeforeRequest(Object request) {
        if (!"true".equals(System.getProperty("mservice.handshake.enable", "true")) || !Boolean.TRUE.equals(ThreadTruck.get((Object)"dubbo.Handshake"))) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"RpcHandShake", (String)"handshake", (boolean)true);){
            long start = System.currentTimeMillis();
            HandShakeRequest hrequest = new HandShakeRequest();
            span.addTag("handshaketag", "handshaketag");
            Request req = new Request();
            req.setVersion("2.0.0");
            req.setTwoWay(true);
            req.setEvent("handshake");
            req.setData(hrequest);
            long begin = 0L;
            HandShakeResponse response = null;
            try {
                DefaultFuture future = new DefaultFuture(this.channel, req, Integer.getInteger("handshake.timeout", 1000));
                begin = System.currentTimeMillis();
                this.channel.send((Object)req);
                span.addTag("finishSendReq", System.currentTimeMillis() - start + "ms", true);
                response = (HandShakeResponse)((Result)future.get()).getValue();
                span.addTag("finishGetResult", System.currentTimeMillis() - start + "ms", true);
                span.addTag("serverTime", response.getServerTime() + "ms", true);
                span.addTag("serverQueue", response.getServerQueueTime() + "ms", true);
            }
            catch (Exception e) {
                DefaultFuture future = new DefaultFuture(this.channel, req, 500);
                begin = System.currentTimeMillis();
                this.channel.send((Object)req);
                response = (HandShakeResponse)((Result)future.get()).getValue();
            }
            URL url = this.getUrl();
            String methodname = "";
            if (request instanceof Invocation) {
                methodname = ((Invocation)request).getMethodName();
            }
            if (System.currentTimeMillis() - begin > 500L) {
                RpcStatus.getStatus(url, methodname).busyHandShake();
            }
            if (hrequest.getCheckCode() != response.getCheckCode()) {
                throw new HandShakeException("hand shake checkcode error!");
            }
            if (HandShakeStatus.REFUSE == response.getStatus()) {
                RpcStatus.getStatus(url, methodname).limit(response.getLimit().ability());
                throw new HandShakeException("overload limit error,server refuse this requset!");
            }
            if (HandShakeStatus.LIMITED == response.getStatus()) {
                RpcStatus.getStatus(url, methodname).limit(response.getLimit().ability());
            } else if (HandShakeStatus.BUSY == response.getStatus()) {
                RpcStatus.getStatus(url, methodname).busyHandShake();
            }
        }
        catch (Exception e) {
            throw new HandShakeException("handShake error : " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void close(int timeout) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (timeout > 0) {
            long start = System.currentTimeMillis();
            while (DefaultFuture.hasFuture((Channel)this) && System.currentTimeMillis() - start < (long)timeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.close();
    }

    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public URL getUrl() {
        return this.channel.getUrl();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public ChannelHandler getChannelHandler() {
        return this.channel.getChannelHandler();
    }

    public ExchangeHandler getExchangeHandler() {
        return (ExchangeHandler)this.channel.getChannelHandler();
    }

    public Object getAttribute(String key) {
        return this.channel.getAttribute(key);
    }

    public void setAttribute(String key, Object value) {
        this.channel.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.channel.removeAttribute(key);
    }

    public boolean hasAttribute(String key) {
        return this.channel.hasAttribute(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderExchangeChannel other = (HeaderExchangeChannel)obj;
        if (this.channel == null) {
            return other.channel == null;
        }
        return this.channel.equals(other.channel);
    }

    public String toString() {
        return this.channel.toString();
    }
}

