/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Serialization;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.rpc.dubbo.serialize.CustomSerializationFactory;

public class CodecSupport {
    private static final Logger logger = LoggerFactory.getLogger(CodecSupport.class);
    private static Map<Byte, Serialization> ID_SERIALIZATION_MAP = new HashMap<Byte, Serialization>();

    private CodecSupport() {
    }

    public static Serialization getSerializationById(Byte id) {
        Serialization s = CustomSerializationFactory.get();
        if (s != null) {
            return s;
        }
        return ID_SERIALIZATION_MAP.get(id);
    }

    public static Serialization getSerialization(URL url) {
        Serialization s = CustomSerializationFactory.get();
        if (s != null) {
            return s;
        }
        return (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(url.getParameter("serialization", "hessian2"));
    }

    public static Serialization getSerialization(URL url, Byte id) {
        Serialization result = CodecSupport.getSerializationById(id);
        if (result == null) {
            result = CodecSupport.getSerialization(url);
        }
        return result;
    }

    static {
        Set supportedExtensions = ExtensionLoader.getExtensionLoader(Serialization.class).getSupportedExtensions();
        for (String name : supportedExtensions) {
            Serialization serialization = (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(name);
            byte idByte = serialization.getContentTypeId();
            Serialization se = ID_SERIALIZATION_MAP.get(idByte);
            if (se != null) {
                logger.error("Serialization extension " + serialization.getClass().getName() + " has duplicate id to Serialization extension " + se.getClass().getName() + ", ignore this Serialization extension");
                continue;
            }
            ID_SERIALIZATION_MAP.put(idByte, serialization);
        }
    }
}

